/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.ArmoredFrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.projectile.SeedBombEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBossMob;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpewterEntity
extends SkiesMonsterEntity
implements ISkyBossMob,
RangedAttackMob {
    protected static final EntityDataAccessor<Boolean> GROWN = SynchedEntityData.m_135353_(SpewterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int prevCounter;
    public int counter;
    public int spawnCounter;

    public SpewterEntity(EntityType<? extends SpewterEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GROWN, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return ArmoredFrostSpiritEntity.registerAttributes().m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 7.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 7.0f));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, new Vec3(0.0, pos.f_82480_, 0.0));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (!this.f_19853_.f_46443_) {
            double maxHealth = difficultyIn.m_19048_() == Difficulty.HARD ? 32.0 : (difficultyIn.m_19048_() == Difficulty.NORMAL ? 28.0 : 26.0);
            this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
            this.m_21153_((float)maxHealth);
        }
        return spawnDataIn;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevCounter = this.counter;
        if (this.spawnCounter > 0) {
            --this.spawnCounter;
        }
        if (this.spawnCounter < 0) {
            ++this.spawnCounter;
        }
        if (this.f_20919_ > 0 && this.counter < 20) {
            this.counter += 2;
        } else if (this.f_20919_ <= 0 && this.counter > 0) {
            --this.counter;
        }
        this.m_146926_(0.0f);
        this.m_146922_(0.0f);
        this.f_20885_ = 0.0f;
        this.f_19859_ = 0.0f;
        this.f_19860_ = 0.0f;
        this.f_20885_ = 0.0f;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SPEWTER_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_SPEWTER_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (flag && amount < this.m_21223_() && !this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)5);
            this.counter = 17;
        }
        return flag;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 1.0f;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean isGrown() {
        return (Boolean)this.f_19804_.m_135370_(GROWN);
    }

    public void setGrown(boolean grown) {
        if (grown) {
            this.spawnCounter = 15;
            this.f_19853_.m_7605_((Entity)this, (byte)6);
        }
        this.f_19804_.m_135381_(GROWN, (Object)grown);
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof StarlitCrusherEntity)) {
            super.m_7324_(entityIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                this.counter = 15;
                break;
            }
            case 5: {
                this.counter = 17;
                break;
            }
            case 6: {
                this.spawnCounter = 30;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn instanceof EntRootEntity) {
            return this.m_7307_((Entity)((EntRootEntity)entityIn).getCaster());
        }
        if (entityIn.m_6095_().m_20609_(SkiesEntityTags.NATURE_ALLIES)) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn) && entityIn != null && entityIn != this;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return super.m_5545_(worldIn, spawnReasonIn) && worldIn.m_45527_(this.m_142538_()) && worldIn.m_8055_(this.m_142538_().m_7495_()).m_60734_() == SkiesBlocks.turquoise_cherry_grass_block;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if ((double)this.m_20270_((Entity)target) >= 8.0) {
            return;
        }
        SeedBombEntity seedBomb = new SeedBombEntity(this.f_19853_, this);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_142469_().f_82289_ + (double)(target.m_20206_() / 3.0f) - seedBomb.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2))) * 1.5f;
        seedBomb.m_6686_(d0, d1 + (double)f, d2, 0.5f, 0.0f);
        this.m_5496_(SkiesSounds.ENTITY_SPEWTER_SPIT, 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
        this.f_19853_.m_7967_((Entity)seedBomb);
        if (this.f_20916_ > 0) {
            return;
        }
        this.counter = 15;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
    }
}

