/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IRarityItem {
    default public void setRarityTag(ItemStack stack, SkiesRarity rarity) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_("Rarity", rarity.id);
    }

    default public SkiesRarity getRarityTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return SkiesRarity.getFromId(nbt.m_128451_("Rarity"));
    }

    default public <T extends Item> void fillItemCategoryWithRarity(CreativeModeTab group, NonNullList<ItemStack> stacks, T item) {
        for (SkiesRarity rarity : SkiesRarity.values()) {
            ItemStack stack = new ItemStack(item);
            ((IRarityItem)item).setRarityTag(stack, rarity);
            stacks.add((Object)stack);
        }
    }

    default public void addRarityText(ItemStack stack, List<Component> lore) {
        MutableComponent rarityLabel = new TranslatableComponent("gui.blue_skies.item.rarity").m_130940_(ChatFormatting.LIGHT_PURPLE);
        TranslatableComponent itemRarity = new TranslatableComponent(String.format("gui.blue_skies.item.rarity.%s", this.getRarityTag(stack).getId()));
        lore.add((Component)new TranslatableComponent("%s: %s", new Object[]{rarityLabel, itemRarity}));
    }

    public static enum SkiesRarity {
        COMMON(0, "common"),
        UNCOMMON(1, "uncommon"),
        RARE(2, "rare");

        private final int id;
        private final String name;

        private SkiesRarity(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }

        public static SkiesRarity getFromId(int id) {
            if (id >= 0 && id < SkiesRarity.values().length) {
                return SkiesRarity.values()[id];
            }
            return COMMON;
        }
    }

    public static class WeightedSkiesRarity
    implements WeightedEntry {
        private final SkiesRarity rarity;
        private final Weight weight;

        public WeightedSkiesRarity(int itemWeight, SkiesRarity rarity) {
            this.weight = Weight.m_146282_((int)itemWeight);
            this.rarity = rarity;
        }

        public SkiesRarity getRarity() {
            return this.rarity;
        }

        public Weight m_142631_() {
            return this.weight;
        }
    }
}

