/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonPieces;
import com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon.PoisonDungeonStructure;
import com.legacy.blue_skies.world.general_features.structures.BlindingDungeonStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class EverdawnBlindingDungeonStructure
extends BlindingDungeonStructure {
    public EverdawnBlindingDungeonStructure(Codec<NoneFeatureConfiguration> config) {
        super(config, EverdawnBlindingDungeonStructure::farFromDungeon, (PieceGenerator<NoneFeatureConfiguration>)((PieceGenerator)EverdawnBlindingDungeonStructure::generatePieces));
    }

    private static boolean farFromDungeon(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        ChunkPos pos = context.f_197355_();
        int range = 7;
        for (int x = pos.f_45578_ - range; x <= pos.f_45578_ + range; ++x) {
            for (int z = pos.f_45579_ - range; z <= pos.f_45579_ + range; ++z) {
                ChunkPos chunkpos = ((PoisonDungeonStructure)SkiesStructures.POISON_DUNGEON.getStructure()).m_191122_(null, context.f_197354_(), x, z);
                if (x != chunkpos.f_45578_ || z != chunkpos.f_45579_) continue;
                return false;
            }
        }
        return true;
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        ChunkPos chunkPos = context.f_192705_();
        Rotation rotation = Rotation.values()[context.f_192708_().nextInt(Rotation.values().length)];
        int y = BlindingDungeonStructure.getHeighestY(context.f_192707_(), context.f_192703_(), chunkPos.f_45578_, chunkPos.f_45579_);
        if (y < 100 && y >= 60) {
            EverdawnBlindingDungeonPieces.assemble(context.f_192704_(), new BlockPos(chunkPos.f_45578_ * 16 + 8, y, chunkPos.f_45579_ * 16 + 8), rotation, builder, (Random)context.f_192708_());
        }
    }

    public int getSpacing() {
        return 45;
    }

    public int getOffset() {
        return this.getSpacing() - 14;
    }

    public float getProbability() {
        return 0.75f;
    }

    public Set<ResourceLocation> getValidDimensions() {
        return ImmutableSet.of((Object)SkiesDimensions.EVERDAWN_ID);
    }
}

