/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.blocks.natural.SkyDripstoneBlock;
import com.legacy.blue_skies.blocks.util.IFluidLoggable;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.Tags;

public class SkyDripstoneFeature
extends AbstractCaveFeature<Config> {
    public SkyDripstoneFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(WorldGenLevel world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        int spread = 15;
        int half = spread / 2;
        for (int i = 0; i < 30; ++i) {
            this.createDripstone(world, chunkGen, rand, pos.m_142082_(rand.nextInt(spread) - spread, rand.nextInt(spread) - half, rand.nextInt(spread) - half), config, SkyDripstoneBlock.Type.STALAGMITE);
            this.createDripstone(world, chunkGen, rand, pos.m_142082_(rand.nextInt(spread) - spread, rand.nextInt(spread) - half, rand.nextInt(spread) - half), config, SkyDripstoneBlock.Type.STALACTITE);
        }
        return true;
    }

    private void createDripstone(WorldGenLevel world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config, SkyDripstoneBlock.Type type) {
        BlockState state = (BlockState)config.dripstone.m_49966_().m_61124_(SkyDripstoneBlock.TYPE, (Comparable)((Object)type));
        BlockState placeOnto = world.m_8055_(pos.m_142300_(type.growthDir.m_122424_()));
        if (this.canReplace(world.m_8055_(pos)) && placeOnto.m_60620_((Tag)Tags.Blocks.STONE)) {
            int y;
            int height = rand.nextInt(config.maxLength);
            for (y = 0; y <= height; ++y) {
                if (this.canReplace(world.m_8055_(pos.m_5484_(type.growthDir, y)))) continue;
                height = y - 1;
                break;
            }
            if (height < 0) {
                return;
            }
            for (y = 0; y <= height; ++y) {
                SkyDripstoneBlock.Section section = SkyDripstoneBlock.Section.MIDDLE;
                if (y == 0 && height > 1) {
                    section = SkyDripstoneBlock.Section.BASE;
                } else if (y == height) {
                    section = SkyDripstoneBlock.Section.TIP;
                }
                BlockPos placePos = pos.m_5484_(type.growthDir, y);
                this.m_5974_((LevelWriter)world, placePos, (BlockState)((BlockState)state.m_61124_(SkyDripstoneBlock.SECTION, (Comparable)((Object)section))).m_61124_(IFluidLoggable.FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.from(world.m_6425_(placePos).m_76152_()))));
            }
        }
    }

    private boolean canReplace(BlockState state) {
        return state.m_60767_() == Material.f_76296_ || state.m_60734_() == Blocks.f_49990_ || state.m_60734_() == Blocks.f_49991_;
    }

    @Override
    public int getMaxHeight(Config config) {
        return 10;
    }

    @Override
    public boolean isValidPos(WorldGenLevel world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        return true;
    }

    public static class Config
    implements FeatureConfiguration {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122824_.m_194605_().fieldOf("dripstone").forGetter(config -> config.dripstone), (App)Codec.INT.fieldOf("maxLength").forGetter(config -> config.maxLength)).apply((Applicative)instance, Config::new));
        public final SkyDripstoneBlock dripstone;
        public final int maxLength;

        public Config(Block dripstone, int maxLength) {
            this.dripstone = dripstone instanceof SkyDripstoneBlock ? (SkyDripstoneBlock)dripstone : SkiesBlocks.lunar_dripstone;
            this.maxLength = maxLength;
        }
    }
}

