/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures.villages;

import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageProfessions;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class SkiesVillagePools {
    private static final JigsawPoolBuilder EMPTY_POOL = new JigsawRegistryHelper("minecraft", "").builder().namesR(new ResourceLocation[]{new ResourceLocation("empty")});
    public static final StructureTemplatePool CALMING_SKIES;
    public static final StructureTemplatePool BRIGHTLANDS;
    public static final StructureTemplatePool SLUSHLANDS;
    public static final StructureTemplatePool SHADED_WOODLANDS;
    public static final StructureTemplatePool SUNSET_MAPLE_FOREST;
    public static final StructureTemplatePool CRYSTAL_DUNES;

    public static void init() {
    }

    private static StructureTemplatePool createVillagePools(String biome, int townCenters, int terminators, int straightStreets, int streetCorners, int streetIntersections, StructureProcessorList streetProcessors, int smallHouses, int medHouses, int largeHouses, List<SkiesVillageProfessions> jobSiteNames) {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("blue_skies", "village/" + biome + "/");
        StructureTemplatePool townCenterPattern = registry.register("town_centers", (List)SkiesVillagePools.makeBuilder(registry, "town_centers/", townCenters).maintainWater(false).build());
        registry.register("terminators", (List)SkiesVillagePools.makeBuilder(registry, "terminators/", terminators).processors(streetProcessors).build(), StructureTemplatePool.Projection.TERRAIN_MATCHING);
        JigsawRegistryHelper streetRegistry = registry.setPrefix(registry.prefix + "streets/");
        JigsawPoolBuilder streets = SkiesVillagePools.makeBuilder(streetRegistry, "straight_", straightStreets).weight(10).processors(streetProcessors);
        JigsawPoolBuilder corners = SkiesVillagePools.makeBuilder(streetRegistry, "corner_", streetCorners).weight(8).processors(streetProcessors);
        JigsawPoolBuilder intersections = SkiesVillagePools.makeBuilder(streetRegistry, "intersection_", streetIntersections).weight(2).processors(streetProcessors);
        registry.register("streets", "terminators", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{streets, corners, intersections}), StructureTemplatePool.Projection.TERRAIN_MATCHING);
        JigsawRegistryHelper houseRegistry = registry.setPrefix(registry.prefix + "houses/");
        JigsawPoolBuilder sHouses = SkiesVillagePools.makeBuilder(houseRegistry, "small_", smallHouses);
        JigsawPoolBuilder mHouses = SkiesVillagePools.makeBuilder(houseRegistry, "medium_", medHouses);
        JigsawPoolBuilder lHouses = SkiesVillagePools.makeBuilder(houseRegistry, "large_", largeHouses);
        JigsawPoolBuilder jobSites = houseRegistry.builder().names((Collection)jobSiteNames.stream().map(SkiesVillageProfessions::toString).collect(Collectors.toList()));
        registry.register("houses", "terminators", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{sHouses, mHouses, lHouses, jobSites}));
        return townCenterPattern;
    }

    private static JigsawPoolBuilder makeBuilder(JigsawRegistryHelper registry, String name, int count) {
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = name + i;
        }
        return registry.builder().names(names);
    }

    static {
        String name = SkiesVillageBiomes.CALMING_SKIES.toString();
        CALMING_SKIES = SkiesVillagePools.createVillagePools(name, 3, 1, 6, 3, 6, SkiesStructures.Processors.CALMING_SKIES_STREET, 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER));
        JigsawRegistryHelper registry = new JigsawRegistryHelper("blue_skies", "village/" + name + "/");
        registry.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registry.setPrefix(registry.prefix + "decor/").builder().names(new String[]{"log_pile", "lamp", "flower_bed", "rock", "shrub"}), EMPTY_POOL.clone()}));
        name = SkiesVillageBiomes.BRIGHTLANDS.toString();
        BRIGHTLANDS = SkiesVillagePools.createVillagePools(name, 3, 1, 6, 3, 6, SkiesStructures.Processors.BRIGHTLANDS_STREET, 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.TOOLSMITH));
        registry = new JigsawRegistryHelper("blue_skies", "village/" + name + "/");
        registry.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registry.setPrefix(registry.prefix + "decor/").builder().names(new String[]{"campfire", "lamp", "tree", "ice_spike"}), EMPTY_POOL.clone()}));
        name = SkiesVillageBiomes.SLUSHLANDS.toString();
        SLUSHLANDS = SkiesVillagePools.createVillagePools(name, 3, 1, 6, 3, 6, SkiesStructures.Processors.SLUSHLANDS_STREET, 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER));
        registry = new JigsawRegistryHelper("blue_skies", "village/" + name + "/");
        registry.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registry.setPrefix(registry.prefix + "decor/").builder().names((Map)ImmutableMap.of((Object)"mushroom_basket", (Object)2, (Object)"lamp", (Object)3, (Object)"small_mushroom", (Object)3, (Object)"oven", (Object)1)), EMPTY_POOL.clone()}));
        name = SkiesVillageBiomes.SHADED_WOODLANDS.toString();
        SHADED_WOODLANDS = SkiesVillagePools.createVillagePools(name, 3, 1, 6, 3, 6, SkiesStructures.Processors.SHADED_WOODLANDS_STREET, 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER, SkiesVillageProfessions.SHEPHERD));
        registry = new JigsawRegistryHelper("blue_skies", "village/" + name + "/");
        registry.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registry.setPrefix(registry.prefix + "decor/").builder().names(new String[]{"lamp", "campfire", "chairs", "farm"}), EMPTY_POOL.clone()}));
        name = SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString();
        SUNSET_MAPLE_FOREST = SkiesVillagePools.createVillagePools(name, 3, 1, 6, 3, 6, SkiesStructures.Processors.SUNSET_MAPLE_FOREST_STREET, 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER, SkiesVillageProfessions.SHEPHERD));
        registry = new JigsawRegistryHelper("blue_skies", "village/" + name + "/");
        registry.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registry.setPrefix(registry.prefix + "decor/").builder().names((Map)ImmutableMap.of((Object)"lamp", (Object)6, (Object)"campfire", (Object)1)), EMPTY_POOL.clone().weight(20)}));
        registry.register("town_centers/well_bottom", (List)registry.builder().names(new String[]{"town_centers/well_bottom"}).build());
        name = SkiesVillageBiomes.CRYSTAL_DUNES.toString();
        CRYSTAL_DUNES = SkiesVillagePools.createVillagePools(name, 3, 1, 6, 3, 6, SkiesStructures.Processors.CRYSTAL_DUNES, 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER, SkiesVillageProfessions.SHEPHERD, SkiesVillageProfessions.FISHER));
        registry = new JigsawRegistryHelper("blue_skies", "village/" + name + "/");
        registry.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registry.setPrefix(registry.prefix + "decor/").builder().names((Map)ImmutableMap.of((Object)"lamp", (Object)5, (Object)"campfire", (Object)1)), EMPTY_POOL.clone().weight(15)}));
        registry.register("town_centers/oasis_bottom", (List)registry.builder().names(new String[]{"town_centers/oasis_bottom"}).build());
    }
}

