/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.curiosities.tools.SandPaperPolishingRecipe;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;

public class BeltDeployerCallbacks {
    public static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerTileEntity deployerTileEntity) {
        ItemStack held;
        if (deployerTileEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (deployerTileEntity.mode == DeployerTileEntity.Mode.PUNCH) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        BlockState blockState = deployerTileEntity.m_58900_();
        if (!blockState.m_61138_((Property)DirectionalKineticBlock.FACING) || blockState.m_61143_((Property)DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (deployerTileEntity.state != DeployerTileEntity.State.WAITING) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (deployerTileEntity.redstoneLocked) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerFakePlayer player = deployerTileEntity.getPlayer();
        ItemStack itemStack = held = player == null ? ItemStack.f_41583_ : player.m_21205_();
        if (held.m_41619_()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (deployerTileEntity.getRecipe(s.stack) == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        deployerTileEntity.start();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerTileEntity deployerTileEntity) {
        ItemStack held;
        if (deployerTileEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        BlockState blockState = deployerTileEntity.m_58900_();
        if (!blockState.m_61138_((Property)DirectionalKineticBlock.FACING) || blockState.m_61143_((Property)DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerFakePlayer player = deployerTileEntity.getPlayer();
        ItemStack itemStack = held = player == null ? ItemStack.f_41583_ : player.m_21205_();
        if (held.m_41619_()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        Recipe<? extends Container> recipe = deployerTileEntity.getRecipe(s.stack);
        if (recipe == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (deployerTileEntity.state == DeployerTileEntity.State.RETRACTING && deployerTileEntity.timer == 1000) {
            BeltDeployerCallbacks.activate(s, i, deployerTileEntity, recipe);
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (deployerTileEntity.state == DeployerTileEntity.State.WAITING) {
            if (deployerTileEntity.redstoneLocked) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            deployerTileEntity.start();
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static void activate(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, DeployerTileEntity deployerTileEntity, Recipe<?> recipe) {
        boolean keepHeld;
        List<TransportedItemStack> collect = InWorldProcessing.applyRecipeOn(ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)1), recipe).stream().map(stack -> {
            TransportedItemStack copy = transported.copy();
            boolean centered = BeltHelper.isItemUpright(stack);
            copy.stack = stack;
            copy.locked = true;
            copy.angle = centered ? 180 : Create.RANDOM.nextInt(360);
            return copy;
        }).map(t -> {
            t.locked = false;
            return t;
        }).collect(Collectors.toList());
        TransportedItemStack left = transported.copy();
        deployerTileEntity.player.spawnedItemEffects = transported.stack.m_41777_();
        left.stack.m_41774_(1);
        if (collect.isEmpty()) {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(left));
        } else {
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(collect, left));
        }
        ItemStack heldItem = deployerTileEntity.player.m_21205_();
        boolean unbreakable = heldItem.m_41782_() && heldItem.m_41783_().m_128471_("Unbreakable");
        boolean bl = keepHeld = recipe instanceof DeployerApplicationRecipe && ((DeployerApplicationRecipe)recipe).shouldKeepHeldItem();
        if (!unbreakable && !keepHeld) {
            if (heldItem.m_41763_()) {
                heldItem.m_41622_(1, (LivingEntity)deployerTileEntity.player, s -> s.m_21190_(InteractionHand.MAIN_HAND));
            } else {
                heldItem.m_41774_(1);
            }
        }
        BlockPos pos = deployerTileEntity.m_58899_();
        Level world = deployerTileEntity.m_58904_();
        if (heldItem.m_41619_()) {
            world.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 0.25f, 1.0f);
        }
        world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.25f, 0.75f);
        if (recipe instanceof SandPaperPolishingRecipe) {
            AllSoundEvents.SANDING_SHORT.playOnServer(world, (Vec3i)pos, 0.35f, 1.0f);
        }
        deployerTileEntity.sendData();
    }
}

