/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.error.GlError;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.GatherContextEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.WorldAttached;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionWorld;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderInfo;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderingWorld;
import com.simibubi.create.content.contraptions.components.structureMovement.render.FlwContraptionManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.SBBContraptionManager;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ContraptionRenderDispatcher {
    private static WorldAttached<ContraptionRenderingWorld<?>> WORLDS = new WorldAttached(SBBContraptionManager::new);

    public static boolean invalidate(Contraption contraption) {
        Level level = contraption.entity.f_19853_;
        return ((ContraptionRenderingWorld)WORLDS.get((LevelAccessor)level)).invalidate(contraption);
    }

    public static void tick(Level world) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        ((ContraptionRenderingWorld)WORLDS.get((LevelAccessor)world)).tick();
    }

    @SubscribeEvent
    public static void beginFrame(BeginFrameEvent event) {
        ((ContraptionRenderingWorld)WORLDS.get((LevelAccessor)event.getWorld())).beginFrame(event);
    }

    @SubscribeEvent
    public static void renderLayer(RenderLayerEvent event) {
        ((ContraptionRenderingWorld)WORLDS.get((LevelAccessor)event.getWorld())).renderLayer(event);
        GlError.pollAndThrow(() -> "contraption layer: " + event.getLayer());
    }

    @SubscribeEvent
    public static void onRendererReload(ReloadRenderersEvent event) {
        ContraptionRenderDispatcher.reset();
    }

    public static void gatherContext(GatherContextEvent e) {
        ContraptionRenderDispatcher.reset();
    }

    public static void renderFromEntity(AbstractContraptionEntity entity, Contraption contraption, MultiBufferSource buffers) {
        Level world = entity.f_19853_;
        Object renderInfo = ((ContraptionRenderingWorld)WORLDS.get((LevelAccessor)world)).getRenderInfo(contraption);
        ContraptionMatrices matrices = ((ContraptionRenderInfo)renderInfo).getMatrices();
        if (!matrices.isReady()) {
            return;
        }
        VirtualRenderWorld renderWorld = ((ContraptionRenderInfo)renderInfo).renderWorld;
        ContraptionRenderDispatcher.renderTileEntities(world, renderWorld, contraption, matrices, buffers);
        if (buffers instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffers).m_109911_();
        }
        ContraptionRenderDispatcher.renderActors(world, renderWorld, contraption, matrices, buffers);
    }

    public static VirtualRenderWorld setupRenderWorld(Level world, Contraption c) {
        ContraptionWorld contraptionWorld = c.getContraptionWorld();
        VirtualRenderWorld renderWorld = new VirtualRenderWorld(world, (Vec3i)c.anchor, contraptionWorld.m_141928_(), contraptionWorld.m_141937_());
        renderWorld.setBlockEntities(c.presentTileEntities.values());
        for (StructureTemplate.StructureBlockInfo info : c.getBlocks().values()) {
            renderWorld.m_7731_(info.f_74675_, info.f_74676_, 128);
        }
        renderWorld.runLightingEngine();
        return renderWorld;
    }

    public static void renderTileEntities(Level world, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, MultiBufferSource buffer) {
        TileEntityRenderHelper.renderTileEntities(world, renderWorld, c.specialRenderedTileEntities, matrices.getModelViewProjection(), matrices.getLight(), buffer);
    }

    protected static void renderActors(Level world, VirtualRenderWorld renderWorld, Contraption c, ContraptionMatrices matrices, MultiBufferSource buffer) {
        PoseStack m = matrices.getModel();
        for (Pair pair : c.getActors()) {
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = world;
            }
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)pair.getLeft();
            MovementBehaviour movementBehaviour = AllMovementBehaviours.of(blockInfo.f_74676_);
            if (movementBehaviour == null) continue;
            m.m_85836_();
            TransformStack.cast((PoseStack)m).translate((Vec3i)blockInfo.f_74675_);
            movementBehaviour.renderInContraption(context, renderWorld, matrices, buffer);
            m.m_85849_();
        }
    }

    public static SuperByteBuffer buildStructureBuffer(VirtualRenderWorld renderWorld, Contraption c, RenderType layer) {
        Collection<StructureTemplate.StructureBlockInfo> values = c.getBlocks().values();
        BufferBuilder builder = ModelUtil.getBufferBuilderFromTemplate((BlockAndTintGetter)renderWorld, (RenderType)layer, values);
        return new SuperByteBuffer(builder);
    }

    public static int getLight(Level world, float lx, float ly, float lz) {
        float offset;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float block = 0.0f;
        float sky = 0.0f;
        for (float zOffset = offset = 0.125f; zOffset >= -offset; zOffset -= 2.0f * offset) {
            for (float yOffset = offset; yOffset >= -offset; yOffset -= 2.0f * offset) {
                for (float xOffset = offset; xOffset >= -offset; xOffset -= 2.0f * offset) {
                    pos.m_122169_((double)(lx + xOffset), (double)(ly + yOffset), (double)(lz + zOffset));
                    block += (float)world.m_45517_(LightLayer.BLOCK, (BlockPos)pos) / 8.0f;
                    sky += (float)world.m_45517_(LightLayer.SKY, (BlockPos)pos) / 8.0f;
                }
            }
        }
        return LightTexture.m_109885_((int)((int)block), (int)((int)sky));
    }

    public static int getContraptionWorldLight(MovementContext context, VirtualRenderWorld renderWorld) {
        return LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos);
    }

    public static void reset() {
        WORLDS.empty(ContraptionRenderingWorld::delete);
        WORLDS = Backend.isOn() ? new WorldAttached(FlwContraptionManager::new) : new WorldAttached(SBBContraptionManager::new);
    }
}

