/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.fluids.tank.CreativeFluidTankTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankConnectivityHandler;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.tileEntity.ComparatorUtil;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTankBlock
extends Block
implements IWrenchable,
ITE<FluidTankTileEntity> {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);
    private boolean creative;
    public static final SoundType SILENCED_METAL = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_12062_, () -> SoundEvents.f_12068_, () -> SoundEvents.f_12065_, () -> SoundEvents.f_12064_, () -> SoundEvents.f_12063_);

    public static FluidTankBlock regular(BlockBehaviour.Properties p_i48440_1_) {
        return new FluidTankBlock(p_i48440_1_, false);
    }

    public static FluidTankBlock creative(BlockBehaviour.Properties p_i48440_1_) {
        return new FluidTankBlock(p_i48440_1_, true);
    }

    protected FluidTankBlock(BlockBehaviour.Properties p_i48440_1_, boolean creative) {
        super(p_i48440_1_);
        this.creative = creative;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW)));
    }

    public static boolean isTank(BlockState state) {
        return state.m_60734_() instanceof FluidTankBlock;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withTileEntityDo((BlockGetter)world, pos, FluidTankTileEntity::updateConnectivity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{TOP, BOTTOM, SHAPE});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        FluidTankTileEntity tankAt = FluidTankConnectivityHandler.anyTankAt(world, pos);
        if (tankAt == null) {
            return 0;
        }
        FluidTankTileEntity controllerTE = tankAt.getControllerTE();
        if (controllerTE == null || !controllerTE.window) {
            return 0;
        }
        return tankAt.luminosity;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withTileEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), FluidTankTileEntity::toggleWindows);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        FluidTankTileEntity controllerTE;
        Fluid fluid;
        ItemStack heldItem = player.m_21120_(hand);
        boolean onClient = world.f_46443_;
        if (heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_7500_() && !this.creative) {
            return InteractionResult.PASS;
        }
        FluidHelper.FluidExchange exchange = null;
        FluidTankTileEntity te = FluidTankConnectivityHandler.anyTankAt((BlockGetter)world, pos);
        if (te == null) {
            return InteractionResult.FAIL;
        }
        LazyOptional tankCapability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        if (!tankCapability.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandler fluidTank = (IFluidHandler)tankCapability.orElse(null);
        FluidStack prevFluidInTank = fluidTank.getFluidInTank(0).copy();
        if (FluidHelper.tryEmptyItemIntoTE(world, player, hand, heldItem, te)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromTE(world, player, hand, heldItem, te)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (EmptyingByBasin.canItemBeEmptied(world, heldItem) || GenericItemFilling.canItemBeFilled(world, heldItem)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        SoundEvent soundevent = null;
        BlockState fluidState = null;
        FluidStack fluidInTank = tankCapability.map(fh -> fh.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            FluidStack fluidInItem;
            if (this.creative && !onClient && !(fluidInItem = EmptyingByBasin.emptyItem(world, heldItem, true).getFirst()).isEmpty() && fluidTank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)fluidTank).setContainedFluid(fluidInItem);
            }
            fluid = fluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            FluidAttributes attributes = fluid.getAttributes();
            soundevent = attributes.getEmptySound();
            if (soundevent == null) {
                SoundEvent soundEvent = soundevent = fluid.m_76108_((Tag)FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
            }
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            if (this.creative && !onClient && fluidTank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)fluidTank).setContainedFluid(FluidStack.EMPTY);
            }
            fluid = prevFluidInTank.getFluid();
            fluidState = fluid.m_76145_().m_76188_();
            soundevent = fluid.getAttributes().getFillSound();
            if (soundevent == null) {
                SoundEvent soundEvent = soundevent = fluid.m_76108_((Tag)FluidTags.f_13132_) ? SoundEvents.f_11783_ : SoundEvents.f_11781_;
            }
        }
        if (soundevent != null && !onClient) {
            float pitch = Mth.m_14036_((float)(1.0f - 1.0f * (float)fluidInTank.getAmount() / (float)(FluidTankTileEntity.getCapacityMultiplier() * 16)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            world.m_5594_(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (world.f_46441_.nextFloat() - 0.5f) / 4.0f);
        }
        if (!fluidInTank.isFluidStackIdentical(prevFluidInTank) && te instanceof FluidTankTileEntity && (controllerTE = te.getControllerTE()) != null) {
            if (fluidState != null && onClient) {
                BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.f_123794_, fluidState);
                float level = (float)fluidInTank.getAmount() / (float)fluidTank.getTankCapacity(0);
                boolean reversed = fluidInTank.getFluid().getAttributes().isLighterThanAir();
                if (reversed) {
                    level = 1.0f - level;
                }
                Vec3 vec = ray.m_82450_();
                vec = new Vec3(vec.f_82479_, (double)((float)controllerTE.m_58899_().m_123342_() + level * ((float)controllerTE.height - 0.5f) + 0.25f), vec.f_82481_);
                Vec3 motion = player.m_20182_().m_82546_(vec).m_82490_((double)0.05f);
                vec = vec.m_82549_(motion);
                world.m_7106_((ParticleOptions)blockParticleData, vec.f_82479_, vec.f_82480_, vec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                return InteractionResult.SUCCESS;
            }
            controllerTE.sendDataImmediately();
            controllerTE.m_6596_();
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof FluidTankTileEntity)) {
                return;
            }
            FluidTankTileEntity tankTE = (FluidTankTileEntity)te;
            world.m_46747_(pos);
            FluidTankConnectivityHandler.splitTank(tankTE);
        }
    }

    @Override
    public Class<FluidTankTileEntity> getTileEntityClass() {
        return FluidTankTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends FluidTankTileEntity> getTileEntityType() {
        return this.creative ? (BlockEntityType)AllTileEntities.CREATIVE_FLUID_TANK.get() : (BlockEntityType)AllTileEntities.FLUID_TANK.get();
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean x = mirror == Mirror.FRONT_BACK;
        switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case WINDOW_NE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NW : Shape.WINDOW_SE)));
            }
            case WINDOW_NW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NE : Shape.WINDOW_SW)));
            }
            case WINDOW_SE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SW : Shape.WINDOW_NE)));
            }
            case WINDOW_SW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SE : Shape.WINDOW_NW)));
            }
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        switch ((Shape)((Object)state.m_61143_(SHAPE))) {
            case WINDOW_NE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_SE));
            }
            case WINDOW_NW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_NE));
            }
            case WINDOW_SE: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_SW));
            }
            case WINDOW_SW: {
                return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)Shape.WINDOW_NW));
            }
        }
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getTileEntityOptional((BlockGetter)worldIn, pos).map(FluidTankTileEntity::getControllerTE).map(te -> ComparatorUtil.fractionToRedstoneLevel(te.getFillState())).orElse(0);
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        WINDOW,
        WINDOW_NW,
        WINDOW_SW,
        WINDOW_NE,
        WINDOW_SE;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

