/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.curiosities.toolbox.ToolboxDisposeAllPacket;
import com.simibubi.create.content.curiosities.toolbox.ToolboxEquipPacket;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandlerClient;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class RadialToolboxMenu
extends AbstractSimiScreen {
    private State state;
    private int ticksOpen;
    private int hoveredSlot;
    private boolean scrollMode;
    private int scrollSlot = 0;
    private List<ToolboxTileEntity> toolboxes;
    private ToolboxTileEntity selectedBox;
    private static final int DEPOSIT = -7;
    private static final int UNEQUIP = -5;

    public RadialToolboxMenu(List<ToolboxTileEntity> toolboxes, State state, @Nullable ToolboxTileEntity selectedBox) {
        this.toolboxes = toolboxes;
        this.state = state;
        this.hoveredSlot = -1;
        if (selectedBox != null) {
            this.selectedBox = selectedBox;
        }
    }

    public void prevSlot(int slot) {
        this.scrollSlot = slot;
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        boolean renderCenterSlot;
        float hoveredY;
        float fade = Mth.m_14036_((float)(((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 10.0f), (float)0.001953125f, (float)1.0f);
        this.hoveredSlot = -1;
        Window window = this.getMinecraft().m_91268_();
        float hoveredX = mouseX - window.m_85445_() / 2;
        float distance = hoveredX * hoveredX + (hoveredY = (float)(mouseY - window.m_85446_() / 2)) * hoveredY;
        if (distance > 25.0f && distance < 10000.0f) {
            this.hoveredSlot = Mth.m_14143_((float)(AngleHelper.deg(Mth.m_14136_((double)hoveredY, (double)hoveredX)) + 360.0f + 180.0f - 22.5f)) % 360 / 45;
        }
        boolean bl = renderCenterSlot = this.state == State.SELECT_ITEM_UNEQUIP;
        if (this.scrollMode && distance > 150.0f) {
            this.scrollMode = false;
        }
        if (renderCenterSlot && distance <= 150.0f) {
            this.hoveredSlot = -5;
        }
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ / 2), 0.0);
        TranslatableComponent tip = null;
        if (this.state == State.DETACH) {
            tip = Lang.translate("toolbox.outOfRange", new Object[0]);
            if (hoveredX > -20.0f && hoveredX < 20.0f && hoveredY > -80.0f && hoveredY < -20.0f) {
                this.hoveredSlot = -5;
            }
            ms.m_85836_();
            AllGuiTextures.TOOLBELT_INACTIVE_SLOT.render(ms, -12, -12, (GuiComponent)this);
            ((RenderElement)GuiGameElement.of(AllBlocks.TOOLBOXES.get(DyeColor.BROWN).asStack()).at(-9.0f, -9.0f)).render(ms);
            ms.m_85837_(0.0, (double)(-40.0f + 10.0f * (1.0f - fade) * (1.0f - fade)), 0.0);
            AllGuiTextures.TOOLBELT_SLOT.render(ms, -12, -12, (GuiComponent)this);
            ms.m_85837_(-0.5, 0.5, 0.0);
            AllIcons.I_DISABLE.render(ms, -9, -9, (GuiComponent)this);
            ms.m_85837_(0.5, -0.5, 0.0);
            if (!this.scrollMode && this.hoveredSlot == -5) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -13, -13, (GuiComponent)this);
                tip = Lang.translate("toolbox.detach", new Object[0]).m_130940_(ChatFormatting.GOLD);
            }
            ms.m_85849_();
        } else {
            if (hoveredX > 60.0f && hoveredX < 100.0f && hoveredY > -20.0f && hoveredY < 20.0f) {
                this.hoveredSlot = -7;
            }
            ms.m_85836_();
            ms.m_85837_((double)(80.0f + -5.0f * (1.0f - fade) * (1.0f - fade)), 0.0, 0.0);
            AllGuiTextures.TOOLBELT_SLOT.render(ms, -12, -12, (GuiComponent)this);
            ms.m_85837_(-0.5, 0.5, 0.0);
            AllIcons.I_TOOLBOX.render(ms, -9, -9, (GuiComponent)this);
            ms.m_85837_(0.5, -0.5, 0.0);
            if (!this.scrollMode && this.hoveredSlot == -7) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -13, -13, (GuiComponent)this);
                tip = Lang.translate(this.state == State.SELECT_BOX ? "toolbox.depositAll" : "toolbox.depositBox", new Object[0]).m_130940_(ChatFormatting.GOLD);
            }
            ms.m_85849_();
            for (int slot = 0; slot < 8; ++slot) {
                ms.m_85836_();
                ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).rotateZ((double)(slot * 45 - 45))).translate(0.0, (double)(-40.0f + 10.0f * (1.0f - fade) * (1.0f - fade)), 0.0)).rotateZ((double)(-slot * 45 + 45));
                ms.m_85837_(-12.0, -12.0, 0.0);
                if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = this.selectedBox.inventory;
                    ItemStack stackInSlot = inv.filters.get(slot);
                    if (!stackInSlot.m_41619_()) {
                        boolean empty = inv.getStackInSlot(slot * 4).m_41619_();
                        (empty ? AllGuiTextures.TOOLBELT_INACTIVE_SLOT : AllGuiTextures.TOOLBELT_SLOT).render(ms, 0, 0, (GuiComponent)this);
                        ((RenderElement)GuiGameElement.of(stackInSlot).at(3.0f, 3.0f)).render(ms);
                        if (slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot) && !empty) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -1, -1, (GuiComponent)this);
                            tip = stackInSlot.m_41786_();
                        }
                    } else {
                        AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(ms, 0, 0, (GuiComponent)this);
                    }
                } else if (this.state == State.SELECT_BOX) {
                    if (slot < this.toolboxes.size()) {
                        AllGuiTextures.TOOLBELT_SLOT.render(ms, 0, 0, (GuiComponent)this);
                        ToolboxTileEntity toolboxTileEntity = this.toolboxes.get(slot);
                        ((RenderElement)GuiGameElement.of(AllBlocks.TOOLBOXES.get(toolboxTileEntity.getColor()).asStack()).at(3.0f, 3.0f)).render(ms);
                        if (slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot)) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -1, -1, (GuiComponent)this);
                            tip = toolboxTileEntity.m_5446_();
                        }
                    } else {
                        AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(ms, 0, 0, (GuiComponent)this);
                    }
                }
                ms.m_85849_();
            }
            if (renderCenterSlot) {
                ms.m_85836_();
                AllGuiTextures.TOOLBELT_SLOT.render(ms, -12, -12, (GuiComponent)this);
                (this.scrollMode ? AllIcons.I_REFRESH : AllIcons.I_FLIP).render(ms, -9, -9, (GuiComponent)this);
                if (!this.scrollMode && -5 == this.hoveredSlot) {
                    AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -13, -13, (GuiComponent)this);
                    tip = Lang.translate("toolbox.unequip", this.f_96541_.f_91074_.m_21205_().m_41786_()).m_130940_(ChatFormatting.GOLD);
                }
                ms.m_85849_();
            }
        }
        ms.m_85849_();
        if (tip != null) {
            int i1 = (int)(fade * 255.0f);
            if (i1 > 255) {
                i1 = 255;
            }
            if (i1 > 8) {
                ms.m_85836_();
                ms.m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ - 68), 0.0);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                int k1 = 0xFFFFFF;
                int k = i1 << 24 & 0xFF000000;
                int l = this.f_96547_.m_92852_((FormattedText)tip);
                this.f_96547_.m_92889_(ms, (Component)tip, (float)(-l / 2), -4.0f, k1 | k);
                RenderSystem.m_69461_();
                ms.m_85849_();
            }
        }
    }

    public void m_96558_(PoseStack p_238651_1_, int p_238651_2_) {
        int a = (int)(80.0f * Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f)) << 24;
        this.m_93179_(p_238651_1_, 0, 0, this.f_96543_, this.f_96544_, 0x101010 | a, 0x101010 | a);
    }

    @Override
    public void m_96624_() {
        ++this.ticksOpen;
        super.m_96624_();
    }

    public void m_7861_() {
        int selected;
        super.m_7861_();
        int n = selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        if (selected == -7) {
            if (this.state == State.DETACH) {
                return;
            }
            if (this.state == State.SELECT_BOX) {
                this.toolboxes.forEach(te -> AllPackets.channel.sendToServer((Object)new ToolboxDisposeAllPacket(te.m_58899_())));
            } else {
                AllPackets.channel.sendToServer((Object)new ToolboxDisposeAllPacket(this.selectedBox.m_58899_()));
            }
            return;
        }
        if (this.state == State.SELECT_BOX) {
            return;
        }
        if (this.state == State.DETACH) {
            if (selected == -5) {
                AllPackets.channel.sendToServer((Object)new ToolboxEquipPacket(null, selected, this.f_96541_.f_91074_.m_150109_().f_35977_));
            }
            return;
        }
        if (selected == -5) {
            AllPackets.channel.sendToServer((Object)new ToolboxEquipPacket(this.selectedBox.m_58899_(), selected, this.f_96541_.f_91074_.m_150109_().f_35977_));
        }
        if (selected < 0) {
            return;
        }
        ToolboxInventory inv = this.selectedBox.inventory;
        ItemStack stackInSlot = inv.filters.get(selected);
        if (stackInSlot.m_41619_()) {
            return;
        }
        if (inv.getStackInSlot(selected * 4).m_41619_()) {
            return;
        }
        AllPackets.channel.sendToServer((Object)new ToolboxEquipPacket(this.selectedBox.m_58899_(), selected, this.f_96541_.f_91074_.m_150109_().f_35977_));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        double hoveredY;
        Window window = this.getMinecraft().m_91268_();
        double hoveredX = mouseX - (double)(window.m_85445_() / 2);
        double distance = hoveredX * hoveredX + (hoveredY = mouseY - (double)(window.m_85446_() / 2)) * hoveredY;
        if (distance <= 150.0) {
            this.scrollMode = true;
            this.scrollSlot = ((int)((double)this.scrollSlot - delta) + 8) % 8;
            for (int i = 0; i < 10; ++i) {
                if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                    ToolboxInventory inv = this.selectedBox.inventory;
                    ItemStack stackInSlot = inv.filters.get(this.scrollSlot);
                    if (!stackInSlot.m_41619_() && !inv.getStackInSlot(this.scrollSlot * 4).m_41619_()) break;
                }
                if (this.state == State.SELECT_BOX && this.scrollSlot < this.toolboxes.size() || this.state == State.DETACH) break;
                this.scrollSlot -= Mth.m_14205_((double)delta);
                this.scrollSlot = (this.scrollSlot + 8) % 8;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double x, double y, int button) {
        int selected;
        int n = selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        if (button == 0) {
            if (selected == -7) {
                this.m_7379_();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
            if (this.state == State.SELECT_BOX && selected >= 0 && selected < this.toolboxes.size()) {
                this.state = State.SELECT_ITEM;
                this.selectedBox = this.toolboxes.get(selected);
                return true;
            }
            if (!(this.state != State.DETACH && this.state != State.SELECT_ITEM && this.state != State.SELECT_ITEM_UNEQUIP || selected != -5 && selected < 0)) {
                this.m_7379_();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
        }
        if (button == 1) {
            if (this.state == State.SELECT_ITEM && this.toolboxes.size() > 1) {
                this.state = State.SELECT_BOX;
                return true;
            }
            if (this.state == State.SELECT_ITEM_UNEQUIP && selected == -5) {
                if (this.toolboxes.size() > 1) {
                    AllPackets.channel.sendToServer((Object)new ToolboxEquipPacket(this.selectedBox.m_58899_(), selected, this.f_96541_.f_91074_.m_150109_().f_35977_));
                    this.state = State.SELECT_BOX;
                    return true;
                }
                this.m_7379_();
                ToolboxHandlerClient.COOLDOWN = 2;
                return true;
            }
        }
        return super.m_6375_(x, y, button);
    }

    @Override
    public boolean m_7933_(int code, int scanCode, int modifiers) {
        KeyMapping[] hotbarBinds = this.f_96541_.f_91066_.f_92056_;
        for (int i = 0; i < hotbarBinds.length && i < 8; ++i) {
            if (!hotbarBinds[i].m_90832_(code, scanCode)) continue;
            if (this.state == State.SELECT_ITEM || this.state == State.SELECT_ITEM_UNEQUIP) {
                ToolboxInventory inv = this.selectedBox.inventory;
                ItemStack stackInSlot = inv.filters.get(i);
                if (stackInSlot.m_41619_() || inv.getStackInSlot(i * 4).m_41619_()) {
                    return false;
                }
            }
            if (this.state == State.SELECT_BOX && i >= this.toolboxes.size()) {
                return false;
            }
            this.scrollMode = true;
            this.scrollSlot = i;
            this.m_6375_(0.0, 0.0, 0);
            return true;
        }
        return super.m_7933_(code, scanCode, modifiers);
    }

    public boolean m_7920_(int code, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)code, (int)scanCode);
        if (AllKeys.TOOLBELT.getKeybind().isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7920_(code, scanCode, modifiers);
    }

    public static enum State {
        SELECT_BOX,
        SELECT_ITEM,
        SELECT_ITEM_UNEQUIP,
        DETACH;

    }
}

