/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.content.curiosities.toolbox.ToolboxBlock;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.ISyncPersistentData;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class ToolboxHandler {
    public static final WorldAttached<WeakHashMap<BlockPos, ToolboxTileEntity>> toolboxes = new WorldAttached(w -> new WeakHashMap());
    static int validationTimer = 20;

    public static void onLoad(ToolboxTileEntity te) {
        toolboxes.get((LevelAccessor)te.m_58904_()).put(te.m_58899_(), te);
    }

    public static void onUnload(ToolboxTileEntity te) {
        toolboxes.get((LevelAccessor)te.m_58904_()).remove(te.m_58899_());
    }

    public static void entityTick(Entity entity, Level world) {
        if (world.f_46443_) {
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        if (entity.f_19797_ % validationTimer != 0) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!player.getPersistentData().m_128441_("CreateToolboxData")) {
            return;
        }
        boolean sendData = false;
        CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
        for (int i = 0; i < 9; ++i) {
            String key = String.valueOf(i);
            if (!compound.m_128441_(key)) continue;
            CompoundTag data = compound.m_128469_(key);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("Pos"));
            int slot = data.m_128451_("Slot");
            if (!world.isAreaLoaded(pos, 0)) continue;
            if (!(world.m_8055_(pos).m_60734_() instanceof ToolboxBlock)) {
                compound.m_128473_(key);
                sendData = true;
                continue;
            }
            BlockEntity prevBlockEntity = world.m_7702_(pos);
            if (!(prevBlockEntity instanceof ToolboxTileEntity)) continue;
            ((ToolboxTileEntity)prevBlockEntity).connectPlayer(slot, (Player)player, i);
        }
        if (sendData) {
            ToolboxHandler.syncData((Player)player);
        }
    }

    public static void playerLogin(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (player.getPersistentData().m_128441_("CreateToolboxData") && !player.getPersistentData().m_128469_("CreateToolboxData").m_128456_()) {
            ToolboxHandler.syncData(player);
        }
    }

    public static void syncData(Player player) {
        AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ISyncPersistentData.PersistentDataPacket((Entity)player));
    }

    public static List<ToolboxTileEntity> getNearest(LevelAccessor world, Player player, int maxAmount) {
        Vec3 location = player.m_20182_();
        double maxRange = ToolboxHandler.getMaxRange(player);
        return toolboxes.get(world).keySet().stream().filter(p -> ToolboxHandler.distance(location, p) < maxRange * maxRange).sorted((p1, p2) -> Double.compare(ToolboxHandler.distance(location, p1), ToolboxHandler.distance(location, p2))).limit(maxAmount).map(toolboxes.get(world)::get).collect(Collectors.toList());
    }

    public static void unequip(Player player, int hotbarSlot, boolean keepItems) {
        CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
        Level world = player.f_19853_;
        String key = String.valueOf(hotbarSlot);
        if (!compound.m_128441_(key)) {
            return;
        }
        CompoundTag prevData = compound.m_128469_(key);
        BlockPos prevPos = NbtUtils.m_129239_((CompoundTag)prevData.m_128469_("Pos"));
        int prevSlot = prevData.m_128451_("Slot");
        BlockEntity prevBlockEntity = world.m_7702_(prevPos);
        if (prevBlockEntity instanceof ToolboxTileEntity) {
            ToolboxTileEntity toolbox = (ToolboxTileEntity)prevBlockEntity;
            toolbox.unequip(prevSlot, player, hotbarSlot, keepItems || !ToolboxHandler.withinRange(player, toolbox));
        }
        compound.m_128473_(key);
    }

    public static boolean withinRange(Player player, ToolboxTileEntity box) {
        if (player.f_19853_ != box.m_58904_()) {
            return false;
        }
        double maxRange = ToolboxHandler.getMaxRange(player);
        return ToolboxHandler.distance(player.m_20182_(), box.m_58899_()) < maxRange * maxRange;
    }

    public static double distance(Vec3 location, BlockPos p) {
        return location.m_82531_((double)((float)p.m_123341_() + 0.5f), (double)p.m_123342_(), (double)((float)p.m_123343_() + 0.5f));
    }

    public static double getMaxRange(Player player) {
        return ((Integer)AllConfigs.SERVER.curiosities.toolboxRange.get()).doubleValue();
    }
}

