/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.components.deployer.DeployerBlock;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmAngleTarget;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class ArmInteractionPoint {
    protected BlockPos pos;
    protected BlockState state;
    protected Mode mode;
    protected LazyOptional<IItemHandler> cachedHandler = LazyOptional.empty();
    protected ArmAngleTarget cachedAngles;
    protected static final HashMap<ArmInteractionPoint, Supplier<ArmInteractionPoint>> POINTS = new HashMap();

    public static void addPoint(ArmInteractionPoint instance, Supplier<ArmInteractionPoint> factory) {
        if (POINTS.containsKey(instance)) {
            Create.LOGGER.warn("Point for " + instance.getClass().getSimpleName() + " was overridden");
        }
        POINTS.put(instance, factory);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void transformFlag(PoseStack stack) {
    }

    protected PartialModel getFlagType() {
        return this.mode == Mode.TAKE ? AllBlockPartials.FLAG_LONG_OUT : AllBlockPartials.FLAG_LONG_IN;
    }

    protected void cycleMode() {
        this.mode = this.mode == Mode.DEPOSIT ? Mode.TAKE : Mode.DEPOSIT;
    }

    protected Vec3 getInteractionPositionVector() {
        return VecHelper.getCenterOf((Vec3i)this.pos);
    }

    protected Direction getInteractionDirection() {
        return Direction.DOWN;
    }

    protected boolean isStillValid(BlockGetter reader) {
        return this.isValid(reader, this.pos, reader.m_8055_(this.pos));
    }

    protected void keepAlive(LevelAccessor world) {
    }

    protected abstract boolean isValid(BlockGetter var1, BlockPos var2, BlockState var3);

    protected static boolean isInteractable(BlockGetter reader, BlockPos pos, BlockState state) {
        for (ArmInteractionPoint armInteractionPoint : POINTS.keySet()) {
            if (!armInteractionPoint.isValid(reader, pos, state)) continue;
            return true;
        }
        return false;
    }

    protected ArmAngleTarget getTargetAngles(BlockPos armPos, boolean ceiling) {
        if (this.cachedAngles == null) {
            this.cachedAngles = new ArmAngleTarget(armPos, this.getInteractionPositionVector(), this.getInteractionDirection(), ceiling);
        }
        return this.cachedAngles;
    }

    @Nullable
    protected IItemHandler getHandler(Level world) {
        if (!this.cachedHandler.isPresent()) {
            BlockEntity te = world.m_7702_(this.pos);
            if (te == null) {
                return null;
            }
            this.cachedHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        }
        return (IItemHandler)this.cachedHandler.orElse(null);
    }

    protected ItemStack insert(Level world, ItemStack stack, boolean simulate) {
        IItemHandler handler = this.getHandler(world);
        if (handler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    protected ItemStack extract(Level world, int slot, int amount, boolean simulate) {
        IItemHandler handler = this.getHandler(world);
        if (handler == null) {
            return ItemStack.f_41583_;
        }
        return handler.extractItem(slot, amount, simulate);
    }

    protected ItemStack extract(Level world, int slot, boolean simulate) {
        return this.extract(world, slot, 64, simulate);
    }

    protected int getSlotCount(Level world) {
        IItemHandler handler = this.getHandler(world);
        if (handler == null) {
            return 0;
        }
        return handler.getSlots();
    }

    @Nullable
    protected static ArmInteractionPoint createAt(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        ArmInteractionPoint point = null;
        for (ArmInteractionPoint armInteractionPoint : POINTS.keySet()) {
            if (!armInteractionPoint.isValid(world, pos, state)) continue;
            point = POINTS.get(armInteractionPoint).get();
        }
        if (point != null) {
            point.state = state;
            point.pos = pos;
            point.mode = Mode.DEPOSIT;
        }
        return point;
    }

    protected CompoundTag serialize(BlockPos anchor) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos.m_141950_((Vec3i)anchor)));
        NBTHelper.writeEnum(nbt, "Mode", this.mode);
        return nbt;
    }

    protected static ArmInteractionPoint deserialize(BlockGetter world, BlockPos anchor, CompoundTag nbt) {
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos"));
        ArmInteractionPoint interactionPoint = ArmInteractionPoint.createAt(world, pos.m_141952_((Vec3i)anchor));
        if (interactionPoint == null) {
            return null;
        }
        interactionPoint.mode = NBTHelper.readEnum(nbt, "Mode", Mode.class);
        return interactionPoint;
    }

    protected static void transformPos(StructureTransform transform, CompoundTag nbt) {
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos"));
        pos = transform.applyWithoutOffset(pos);
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    static {
        ArmInteractionPoint.addPoint(new Saw(), Saw::new);
        ArmInteractionPoint.addPoint(new Belt(), Belt::new);
        ArmInteractionPoint.addPoint(new Depot(), Depot::new);
        ArmInteractionPoint.addPoint(new Chute(), Chute::new);
        ArmInteractionPoint.addPoint(new Basin(), Basin::new);
        ArmInteractionPoint.addPoint(new Funnel(), Funnel::new);
        ArmInteractionPoint.addPoint(new Jukebox(), Jukebox::new);
        ArmInteractionPoint.addPoint(new Crafter(), Crafter::new);
        ArmInteractionPoint.addPoint(new Deployer(), Deployer::new);
        ArmInteractionPoint.addPoint(new Composter(), Composter::new);
        ArmInteractionPoint.addPoint(new Millstone(), Millstone::new);
        ArmInteractionPoint.addPoint(new BlazeBurner(), BlazeBurner::new);
        ArmInteractionPoint.addPoint(new CrushingWheels(), CrushingWheels::new);
    }

    public static enum Mode {
        DEPOSIT,
        TAKE;

    }

    public static class Saw
    extends Depot {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.MECHANICAL_SAW.has(state) && state.m_61143_((Property)SawBlock.FACING) == Direction.UP && ((KineticTileEntity)reader.m_7702_(pos)).getSpeed() != 0.0f;
        }
    }

    public static class Belt
    extends Depot {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.BELT.has(state) && !(reader.m_8055_(pos.m_7494_()).m_60734_() instanceof BeltTunnelBlock);
        }

        @Override
        protected void keepAlive(LevelAccessor world) {
            super.keepAlive(world);
            BeltTileEntity beltTE = BeltHelper.getSegmentTE(world, this.pos);
            if (beltTE == null) {
                return;
            }
            TransportedItemStackHandlerBehaviour transport = beltTE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
            if (transport == null) {
                return;
            }
            MutableBoolean found = new MutableBoolean(false);
            transport.handleProcessingOnAllItems(tis -> {
                if (found.isTrue()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                tis.lockedExternally = true;
                found.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    public static class Depot
    extends ArmInteractionPoint {
        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 0.875, 0.5);
        }

        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state);
        }
    }

    public static class Chute
    extends TopFaceArmInteractionPoint {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AbstractChuteBlock.isChute(state);
        }
    }

    public static class Basin
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.BASIN.has(state);
        }
    }

    public static class Funnel
    extends ArmInteractionPoint {
        @Override
        protected Vec3 getInteractionPositionVector() {
            return VecHelper.getCenterOf((Vec3i)this.pos).m_82549_(Vec3.m_82528_((Vec3i)FunnelBlock.getFunnelFacing(this.state).m_122436_()).m_82490_((double)-0.15f));
        }

        @Override
        protected int getSlotCount(Level world) {
            return 0;
        }

        @Override
        protected ItemStack extract(Level world, int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        @Override
        protected Direction getInteractionDirection() {
            return FunnelBlock.getFunnelFacing(this.state).m_122424_();
        }

        @Override
        protected ItemStack insert(Level world, ItemStack stack, boolean simulate) {
            BlockEntity tileEntity;
            FilteringBehaviour filtering = TileEntityBehaviour.get((BlockGetter)world, this.pos, FilteringBehaviour.TYPE);
            InvManipulationBehaviour inserter = TileEntityBehaviour.get((BlockGetter)world, this.pos, InvManipulationBehaviour.TYPE);
            BlockState state = world.m_8055_(this.pos);
            if (state.m_61145_((Property)BlockStateProperties.f_61448_).orElse(false).booleanValue()) {
                return stack;
            }
            if (inserter == null) {
                return stack;
            }
            if (filtering != null && !filtering.test(stack)) {
                return stack;
            }
            if (simulate) {
                inserter.simulate();
            }
            ItemStack insert = inserter.insert(stack);
            if (!simulate && insert.m_41613_() != stack.m_41613_() && (tileEntity = world.m_7702_(this.pos)) instanceof FunnelTileEntity) {
                FunnelTileEntity funnelTileEntity = (FunnelTileEntity)tileEntity;
                funnelTileEntity.onTransfer(stack);
                if (funnelTileEntity.hasFlap()) {
                    funnelTileEntity.flap(true);
                }
            }
            return insert;
        }

        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return !(!(state.m_60734_() instanceof AbstractFunnelBlock) || state.m_61138_((Property)FunnelBlock.EXTRACTING) && (Boolean)state.m_61143_((Property)FunnelBlock.EXTRACTING) != false || state.m_61138_(BeltFunnelBlock.SHAPE) && state.m_61143_(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PUSHING);
        }

        @Override
        protected void cycleMode() {
        }
    }

    public static class Jukebox
    extends TopFaceArmInteractionPoint {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return state.m_60734_() instanceof JukeboxBlock;
        }

        @Override
        protected int getSlotCount(Level world) {
            return 1;
        }

        @Override
        protected ItemStack insert(Level world, ItemStack stack, boolean simulate) {
            BlockEntity tileEntity = world.m_7702_(this.pos);
            if (!(tileEntity instanceof JukeboxBlockEntity)) {
                return stack;
            }
            if (!(this.state.m_60734_() instanceof JukeboxBlock)) {
                return stack;
            }
            JukeboxBlock jukeboxBlock = (JukeboxBlock)this.state.m_60734_();
            JukeboxBlockEntity jukeboxTE = (JukeboxBlockEntity)tileEntity;
            if (!jukeboxTE.m_59524_().m_41619_()) {
                return stack;
            }
            if (!(stack.m_41720_() instanceof RecordItem)) {
                return stack;
            }
            ItemStack remainder = stack.m_41777_();
            ItemStack toInsert = remainder.m_41620_(1);
            if (!simulate && !world.f_46443_) {
                jukeboxBlock.m_54269_((LevelAccessor)world, this.pos, this.state, toInsert);
                world.m_5898_(null, 1010, this.pos, Item.m_41393_((Item)toInsert.m_41720_()));
                AllTriggers.triggerForNearbyPlayers(AllTriggers.MUSICAL_ARM, (LevelAccessor)world, this.pos, 10);
            }
            return remainder;
        }

        @Override
        protected ItemStack extract(Level world, int slot, int amount, boolean simulate) {
            BlockEntity tileEntity = world.m_7702_(this.pos);
            if (!(tileEntity instanceof JukeboxBlockEntity)) {
                return ItemStack.f_41583_;
            }
            if (!(this.state.m_60734_() instanceof JukeboxBlock)) {
                return ItemStack.f_41583_;
            }
            JukeboxBlockEntity jukeboxTE = (JukeboxBlockEntity)tileEntity;
            ItemStack itemstack = jukeboxTE.m_59524_();
            if (itemstack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!simulate && !world.f_46443_) {
                world.m_46796_(1010, this.pos, 0);
                jukeboxTE.m_6211_();
                world.m_7731_(this.pos, (BlockState)this.state.m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(false)), 2);
            }
            return itemstack;
        }
    }

    public static class Crafter
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.MECHANICAL_CRAFTER.has(state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return ((Direction)this.state.m_61143_(MechanicalCrafterBlock.HORIZONTAL_FACING)).m_122424_();
        }

        @Override
        protected ItemStack extract(Level world, int slot, int amount, boolean simulate) {
            BlockEntity te = world.m_7702_(this.pos);
            if (!(te instanceof MechanicalCrafterTileEntity)) {
                return ItemStack.f_41583_;
            }
            MechanicalCrafterTileEntity crafter = (MechanicalCrafterTileEntity)te;
            MechanicalCrafterTileEntity.Inventory inventory = crafter.getInventory();
            inventory.allowExtraction();
            ItemStack extract = super.extract(world, slot, amount, simulate);
            inventory.forbidExtraction();
            return extract;
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return super.getInteractionPositionVector().m_82549_(Vec3.m_82528_((Vec3i)this.getInteractionDirection().m_122436_()).m_82490_(0.5));
        }
    }

    public static class Deployer
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.DEPLOYER.has(state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return ((Direction)this.state.m_61143_((Property)DeployerBlock.FACING)).m_122424_();
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return super.getInteractionPositionVector().m_82549_(Vec3.m_82528_((Vec3i)this.getInteractionDirection().m_122436_()).m_82490_((double)0.65f));
        }
    }

    public static class Composter
    extends TopFaceArmInteractionPoint {
        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 0.8125, 0.5);
        }

        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return Blocks.f_50715_.equals(state.m_60734_());
        }

        @Override
        @Nullable
        protected IItemHandler getHandler(Level world) {
            return new InvWrapper((Container)((ComposterBlock)Blocks.f_50715_).m_5840_(world.m_8055_(this.pos), (LevelAccessor)world, this.pos));
        }
    }

    public static class Millstone
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.MILLSTONE.has(state);
        }
    }

    public static class BlazeBurner
    extends ArmInteractionPoint {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.BLAZE_BURNER.has(state);
        }

        @Override
        protected ItemStack extract(Level world, int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        @Override
        protected ItemStack insert(Level world, ItemStack stack, boolean simulate) {
            ItemStack input = stack.m_41777_();
            if (!((ItemStack)BlazeBurnerBlock.tryInsert(this.state, world, this.pos, input, false, false, true).m_19095_()).m_41619_()) {
                return stack;
            }
            InteractionResultHolder<ItemStack> res = BlazeBurnerBlock.tryInsert(this.state, world, this.pos, input, false, false, simulate);
            return res.m_19089_() == InteractionResult.SUCCESS ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1)) : stack;
        }

        @Override
        protected void cycleMode() {
        }
    }

    public static class CrushingWheels
    extends TopFaceArmInteractionPoint {
        @Override
        protected boolean isValid(BlockGetter reader, BlockPos pos, BlockState state) {
            return AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(state);
        }
    }

    public static abstract class TopFaceArmInteractionPoint
    extends ArmInteractionPoint {
        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 1.0, 0.5);
        }
    }
}

