/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.palettes;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.palettes.PaletteBlockPartial;
import com.simibubi.create.content.palettes.PaletteBlockPattern;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import com.simibubi.create.repack.registrate.util.entry.RegistryEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class PalettesVariantEntry {
    public final ImmutableList<BlockEntry<? extends Block>> registeredBlocks;
    public final ImmutableList<BlockEntry<? extends Block>> registeredPartials;

    public PalettesVariantEntry(String name, AllPaletteStoneTypes paletteStoneVariants) {
        ImmutableList.Builder registeredBlocks = ImmutableList.builder();
        ImmutableList.Builder registeredPartials = ImmutableList.builder();
        CreateRegistrate registrate = Create.registrate();
        NonNullSupplier<Block> baseBlock = paletteStoneVariants.baseBlock;
        for (PaletteBlockPattern pattern : paletteStoneVariants.variantTypes) {
            Tag.Named<Item>[] itemTags;
            BlockBuilder builder = registrate.block(pattern.createName(name), pattern.getBlockFactory()).initialProperties(baseBlock::get).transform(AllTags.pickaxeOnly()).blockstate(((PaletteBlockPattern.IBlockStateProvider)((Function)pattern.getBlockStateGenerator().apply(pattern)).apply(name))::accept);
            ItemBuilder itemBuilder = builder.item();
            Tag.Named<Block>[] blockTags = pattern.getBlockTags();
            if (blockTags != null) {
                builder.tag(blockTags);
            }
            if ((itemTags = pattern.getItemTags()) != null) {
                itemBuilder.tag(itemTags);
            }
            itemBuilder.tag(paletteStoneVariants.materialTag);
            if (pattern.isTranslucent()) {
                builder.addLayer(() -> RenderType::m_110466_);
            }
            pattern.createCTBehaviour(name).ifPresent(b -> builder.onRegister(CreateRegistrate.connectedTextures(b)));
            builder.recipe((c, p) -> {
                p.stonecutting(DataIngredient.tag(paletteStoneVariants.materialTag), c::get);
                pattern.addRecipes(baseBlock, (DataGenContext<Block, ? extends Block>)c, (RegistrateRecipeProvider)p);
            });
            itemBuilder.register();
            RegistryEntry block = builder.register();
            registeredBlocks.add((Object)block);
            for (PaletteBlockPartial<? extends Block> partialBlock : pattern.getPartials()) {
                registeredPartials.add((Object)partialBlock.create(name, pattern, (BlockEntry<Block>)block, paletteStoneVariants).register());
            }
        }
        this.registeredBlocks = registeredBlocks.build();
        this.registeredPartials = registeredPartials.build();
    }
}

