/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.ClientSchematicLoader;
import com.simibubi.create.content.schematics.block.SchematicTableContainer;
import com.simibubi.create.content.schematics.block.SchematicTableTileEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class SchematicTableScreen
extends AbstractSimiContainerScreen<SchematicTableContainer> {
    private final Component uploading = Lang.translate("gui.schematicTable.uploading", new Object[0]);
    private final Component finished = Lang.translate("gui.schematicTable.finished", new Object[0]);
    private final Component refresh = Lang.translate("gui.schematicTable.refresh", new Object[0]);
    private final Component folder = Lang.translate("gui.schematicTable.open_folder", new Object[0]);
    private final Component noSchematics = Lang.translate("gui.schematicTable.noSchematics", new Object[0]);
    private final Component availableSchematicsTitle = Lang.translate("gui.schematicTable.availableSchematics", new Object[0]);
    protected AllGuiTextures background;
    private ScrollInput schematicsArea;
    private IconButton confirmButton;
    private IconButton folderButton;
    private IconButton refreshButton;
    private Label schematicsLabel;
    private float progress;
    private float chasingProgress;
    private float lastChasingProgress;
    private final ItemStack renderedItem = AllBlocks.SCHEMATIC_TABLE.asStack();
    private List<Rect2i> extraAreas = Collections.emptyList();

    public SchematicTableScreen(SchematicTableContainer container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.background = AllGuiTextures.SCHEMATIC_TABLE;
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(-11, 8);
        super.m_7856_();
        CreateClient.SCHEMATIC_SENDER.refresh();
        List<Component> availableSchematics = CreateClient.SCHEMATIC_SENDER.getAvailableSchematics();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.schematicsLabel = new Label(x + 49, y + 26, TextComponent.f_131282_).withShadow();
        this.schematicsLabel.text = TextComponent.f_131282_;
        if (!availableSchematics.isEmpty()) {
            this.schematicsArea = new SelectionScrollInput(x + 45, y + 21, 139, 18).forOptions(availableSchematics).titled(this.availableSchematicsTitle.m_6879_()).writingTo(this.schematicsLabel);
            this.m_142416_(this.schematicsArea);
            this.m_142416_(this.schematicsLabel);
        }
        this.confirmButton = new IconButton(x + 44, y + 56, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> {
            if (((SchematicTableContainer)this.f_97732_).canWrite() && this.schematicsArea != null) {
                ClientSchematicLoader schematicSender = CreateClient.SCHEMATIC_SENDER;
                this.progress = 0.0f;
                this.chasingProgress = 0.0f;
                this.lastChasingProgress = 0.0f;
                List<Component> availableSchematics1 = schematicSender.getAvailableSchematics();
                Component schematic = availableSchematics1.get(this.schematicsArea.getState());
                schematicSender.startNewUpload(schematic.m_6111_());
            }
        });
        this.folderButton = new IconButton(x + 21, y + 21, AllIcons.I_OPEN_FOLDER);
        this.folderButton.withCallback(() -> Util.m_137581_().m_137644_(Paths.get("schematics/", new String[0]).toFile()));
        this.folderButton.setToolTip(this.folder);
        this.refreshButton = new IconButton(x + 207, y + 21, AllIcons.I_REFRESH);
        this.refreshButton.withCallback(() -> {
            ClientSchematicLoader schematicSender = CreateClient.SCHEMATIC_SENDER;
            schematicSender.refresh();
            List<Component> availableSchematics1 = schematicSender.getAvailableSchematics();
            this.m_169411_(this.schematicsArea);
            if (!availableSchematics1.isEmpty()) {
                this.schematicsArea = new SelectionScrollInput(this.f_97735_ + 45, this.f_97736_ + 21, 139, 18).forOptions(availableSchematics1).titled(this.availableSchematicsTitle.m_6879_()).writingTo(this.schematicsLabel);
                this.schematicsArea.onChanged();
                this.m_142416_(this.schematicsArea);
            } else {
                this.schematicsArea = null;
                this.schematicsLabel.text = TextComponent.f_131282_;
            }
        });
        this.refreshButton.setToolTip(this.refresh);
        this.m_142416_(this.confirmButton);
        this.m_142416_(this.folderButton);
        this.m_142416_(this.refreshButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width, y + this.background.height - 40, 48, 48), (Object)new Rect2i(this.refreshButton.f_93620_, this.refreshButton.f_93621_, this.refreshButton.m_5711_(), this.refreshButton.m_93694_()));
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.f_97736_ + this.background.height + 4;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.background.render(ms, x, y, (GuiComponent)this);
        Component titleText = ((SchematicTableTileEntity)((SchematicTableContainer)this.f_97732_).contentHolder).isUploading ? this.uploading : (((SchematicTableContainer)this.f_97732_).m_38853_(1).m_6657_() ? this.finished : this.f_96539_);
        SchematicTableScreen.m_93215_((PoseStack)ms, (Font)this.f_96547_, (Component)titleText, (int)(x + (this.background.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        if (this.schematicsArea == null) {
            this.f_96547_.m_92763_(ms, this.noSchematics, (float)(x + 54), (float)(y + 26), 0xD3D3D3);
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + this.background.width, y + this.background.height - 40, -200.0f)).scale(3.0).render(ms);
        AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.bind();
        int width = (int)((float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.width * Mth.m_14179_((float)partialTicks, (float)this.lastChasingProgress, (float)this.chasingProgress));
        int height = AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.height;
        this.m_93228_(ms, x + 70, y + 57, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.startX, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.startY, width, height);
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        boolean finished = ((SchematicTableContainer)this.f_97732_).m_38853_(1).m_6657_();
        if (((SchematicTableTileEntity)((SchematicTableContainer)this.f_97732_).contentHolder).isUploading || finished) {
            if (finished) {
                this.progress = 1.0f;
                this.lastChasingProgress = 1.0f;
                this.chasingProgress = 1.0f;
            } else {
                this.lastChasingProgress = this.chasingProgress;
                this.progress = ((SchematicTableTileEntity)((SchematicTableContainer)this.f_97732_).contentHolder).uploadingProgress;
                this.chasingProgress += (this.progress - this.chasingProgress) * 0.5f;
            }
            this.confirmButton.f_93623_ = false;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(0xCCDDFF);
                String uploadingSchematic = ((SchematicTableTileEntity)((SchematicTableContainer)this.f_97732_).contentHolder).uploadingSchematic;
                TextComponent textComponent = this.schematicsLabel.text = uploadingSchematic == null ? null : new TextComponent(uploadingSchematic);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.f_93624_ = false;
            }
        } else {
            this.progress = 0.0f;
            this.lastChasingProgress = 0.0f;
            this.chasingProgress = 0.0f;
            this.confirmButton.f_93623_ = true;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(0xFFFFFF);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.writingTo(this.schematicsLabel);
                this.schematicsArea.f_93624_ = true;
            }
        }
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

