/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widget;

import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class SelectionScrollInput
extends ScrollInput {
    private final MutableComponent scrollToSelect = Lang.translate("gui.scrollInput.scrollToSelect", new Object[0]);
    protected List<Component> options = new ArrayList<Component>();

    public SelectionScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
    }

    public ScrollInput forOptions(List<Component> options) {
        this.options = options;
        this.max = options.size();
        this.updateTooltip();
        return this;
    }

    @Override
    protected void writeToLabel() {
        this.displayLabel.text = this.options.get(this.state);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, -delta);
    }

    @Override
    protected void updateTooltip() {
        this.toolTip.clear();
        this.toolTip.add(this.title.m_6879_().m_130940_(ChatFormatting.BLUE));
        int min = Math.min(this.max - 16, this.state - 7);
        int max = Math.max(this.min + 16, this.state + 8);
        min = Math.max(min, this.min);
        max = Math.min(max, this.max);
        if (this.min + 1 == min) {
            --min;
        }
        if (min > this.min) {
            this.toolTip.add(new TextComponent("> ...").m_130940_(ChatFormatting.GRAY));
        }
        if (this.max - 1 == max) {
            ++max;
        }
        for (int i = min; i < max; ++i) {
            if (i == this.state) {
                this.toolTip.add(TextComponent.f_131282_.m_6879_().m_130946_("-> ").m_7220_(this.options.get(i)).m_130940_(ChatFormatting.WHITE));
                continue;
            }
            this.toolTip.add(TextComponent.f_131282_.m_6879_().m_130946_("> ").m_7220_(this.options.get(i)).m_130940_(ChatFormatting.GRAY));
        }
        if (max < this.max) {
            this.toolTip.add(new TextComponent("> ...").m_130940_(ChatFormatting.GRAY));
        }
        this.toolTip.add(this.scrollToSelect.m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }
}

