/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.outliner.Outline;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class LineOutline
extends Outline {
    protected Vec3 start = Vec3.f_82478_;
    protected Vec3 end = Vec3.f_82478_;

    public LineOutline set(Vec3 start, Vec3 end) {
        this.start = start;
        this.end = end;
        return this;
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, float pt) {
        this.renderCuboidLine(ms, buffer, this.start, this.end);
    }

    public static class EndChasingLineOutline
    extends LineOutline {
        float prevProgress = 0.0f;
        float progress = 0.0f;

        @Override
        public void tick() {
        }

        public EndChasingLineOutline setProgress(float progress) {
            this.prevProgress = this.progress;
            this.progress = progress;
            return this;
        }

        @Override
        public LineOutline set(Vec3 start, Vec3 end) {
            if (!end.equals((Object)this.end)) {
                super.set(start, end);
            }
            return this;
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, float pt) {
            float distanceToTarget = 1.0f - Mth.m_14179_((float)pt, (float)this.prevProgress, (float)this.progress);
            Vec3 start = this.end.m_82549_(this.start.m_82546_(this.end).m_82490_((double)distanceToTarget));
            this.renderCuboidLine(ms, buffer, start, this.end);
        }
    }
}

