/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaksplayer.player.PlayerSimulationDistance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class SimulationDistanceCommand
extends CustomCommand {
    private static final SimulationDistanceCommand command = new SimulationDistanceCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"setSimulationDistance").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int simulationDistance = IntegerArgumentType.getInteger(context, (String)"distance");
        if (simulationDistance > PlayerSimulationDistance.getMaxSimulationDistance() || simulationDistance < PlayerSimulationDistance.getMinSimulationDistance()) {
            SimulationDistanceCommand.sendFeedback(context, (String)("\u26a0 Simulation distance needs to be between " + PlayerSimulationDistance.getMinSimulationDistance() + " and " + PlayerSimulationDistance.getMaxSimulationDistance() + " !"));
        } else {
            SimulationDistanceCommand.sendFeedback(context, (String)("\u25ba Try to change simulation distance from " + PlayerSimulationDistance.getSimulationDistance() + " to " + simulationDistance + "..."));
            PlayerSimulationDistance.setSimulationDistance(simulationDistance);
        }
        return 0;
    }
}

