/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaksplayer.player.PlayerViewDistance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class ViewDistanceCommand
extends CustomCommand {
    private static final ViewDistanceCommand command = new ViewDistanceCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"setViewDistance").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)2, (int)32)).executes((Command)command));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int viewDistance = IntegerArgumentType.getInteger(context, (String)"distance");
        if (viewDistance > PlayerViewDistance.getMaxViewDistance() || viewDistance < PlayerViewDistance.getMinViewDistance()) {
            ViewDistanceCommand.sendFeedback(context, (String)("\u26a0 View distance needs to be between " + PlayerViewDistance.getMinViewDistance() + " and " + PlayerViewDistance.getMaxViewDistance() + " !"));
        } else {
            ViewDistanceCommand.sendFeedback(context, (String)("\u25ba Try to change view distance from " + PlayerViewDistance.getViewDistance() + " to " + viewDistance + "..."));
            PlayerViewDistance.setViewDistance(viewDistance);
        }
        return 0;
    }
}

