/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonConfig {
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Player)");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;

    private CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} common config ...", (Object)"Adaptive Performance Tweaks: Player");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue optimizePlayerLogin;
        public final ForgeConfigSpec.IntValue playerLoginValidationTimeout;
        public final ForgeConfigSpec.BooleanValue protectPlayerDuringLogin;
        public final ForgeConfigSpec.BooleanValue protectPlayerDuringLoginLogging;
        public final ForgeConfigSpec.BooleanValue enableChildPlayerProtection;
        public final ForgeConfigSpec.ConfigValue<List<String>> childPlayerProtectionList;
        public final ForgeConfigSpec.BooleanValue optimizeSimulationDistance;
        public final ForgeConfigSpec.IntValue simulationDistanceMin;
        public final ForgeConfigSpec.IntValue simulationDistanceMax;
        public final ForgeConfigSpec.IntValue simulationDistanceDefault;
        public final ForgeConfigSpec.IntValue simulationDistanceTimeBetweenUpdates;
        public final ForgeConfigSpec.BooleanValue optimizeViewDistance;
        public final ForgeConfigSpec.IntValue viewDistanceMin;
        public final ForgeConfigSpec.IntValue viewDistanceMax;
        public final ForgeConfigSpec.IntValue viewDistanceDefault;
        public final ForgeConfigSpec.IntValue viewDistanceTimeBetweenUpdates;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Player");
            builder.push("Player Login");
            this.optimizePlayerLogin = builder.comment("Enable/Disable optimization which are happening during player login.").define("optimizePlayerLogin", true);
            this.playerLoginValidationTimeout = builder.comment("Timeout in seconds for the player validation.").defineInRange("playerLoginValidationTimeout", 90, 16, 300);
            builder.pop();
            builder.push("Player Protection");
            this.protectPlayerDuringLogin = builder.comment("Protect player during login within the validation timeout.").define("protectPlayerDuringLogin", true);
            this.protectPlayerDuringLoginLogging = builder.comment("Enable/Disable player protection logging with login time.").define("protectPlayerDuringLoginLogging", true);
            builder.pop();
            builder.push("Child Player Protection");
            this.enableChildPlayerProtection = builder.comment("Protect child player and give them a more enjoyable play experience.").define("enableChildPlayerProtection", true);
            this.childPlayerProtectionList = builder.comment("List of child player username for the child player protection.").define("childPlayerProtectionList", new ArrayList<String>(Arrays.asList("")));
            builder.pop();
            builder.push("Simulation Distance");
            this.optimizeSimulationDistance = builder.comment("Enable/Disable simulation distance optimization depending on the server load.").define("optimizeSimulationDistance", true);
            this.simulationDistanceMax = builder.defineInRange("simulationDistanceMax", 10, 6, 32);
            this.simulationDistanceMin = builder.defineInRange("simulationDistanceMin", 2, 2, 16);
            this.simulationDistanceDefault = builder.defineInRange("simulationDistanceDefault", 5, 5, 16);
            this.simulationDistanceTimeBetweenUpdates = builder.comment("The time after a high to low load change is considered as valid. High loads are always considered immediately.").defineInRange("simulationDistanceTimeBetweenUpdates", 30, 1, 90);
            builder.pop();
            builder.push("View Distance");
            this.optimizeViewDistance = builder.comment("Enable/Disable view distance optimization depending on the server load.").define("optimizeViewDistance", true);
            this.viewDistanceMax = builder.defineInRange("viewDistanceMax", 16, 4, 32);
            this.viewDistanceMin = builder.defineInRange("viewDistanceMin", 5, 2, 16);
            this.viewDistanceDefault = builder.defineInRange("viewDistanceDefault", 8, 2, 16);
            this.viewDistanceTimeBetweenUpdates = builder.comment("The time after a high to low load change is considered as valid. High loads are always considered immediately.").defineInRange("viewDistanceTimeBetweenUpdates", 60, 1, 90);
            builder.pop();
        }
    }
}

