/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.player;

import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoad;
import de.markusbordihn.adaptiveperformancetweaksplayer.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaksplayer.player.PlayerSimulationDistance;
import de.markusbordihn.adaptiveperformancetweaksplayer.player.PlayerViewDistance;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerLogin {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Player)");
    private static boolean optimizePlayerLogin = (Boolean)PlayerLogin.COMMON.optimizePlayerLogin.get();
    private static boolean optimizeSimulationDistance = (Boolean)PlayerLogin.COMMON.optimizeSimulationDistance.get();
    private static boolean optimizeViewDistance = (Boolean)PlayerLogin.COMMON.optimizeViewDistance.get();

    protected PlayerLogin() {
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        optimizePlayerLogin = (Boolean)PlayerLogin.COMMON.optimizePlayerLogin.get();
        optimizeSimulationDistance = (Boolean)PlayerLogin.COMMON.optimizeSimulationDistance.get();
        optimizeViewDistance = (Boolean)PlayerLogin.COMMON.optimizeViewDistance.get();
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        String username = event.getPlayer().m_7755_().getString();
        if (!optimizePlayerLogin || username.isEmpty()) {
            return;
        }
        int numOfPlayers = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11309_();
        if (numOfPlayers == 0 && ServerLoad.hasLowServerLoad()) {
            return;
        }
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(username);
        log.debug("Optimize Player Login for {} {} and {} players", (Object)username, (Object)player, (Object)numOfPlayers);
        if (optimizeSimulationDistance) {
            PlayerSimulationDistance.decreaseSimulationDistance();
        }
        if (optimizeViewDistance) {
            PlayerViewDistance.defaultViewDistance();
        }
    }
}

