/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.player;

import de.markusbordihn.adaptiveperformancetweaksplayer.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaksplayer.player.PlayerValidation;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerProtection {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Player)");
    private static Set<PlayerValidation> playerValidationList = ConcurrentHashMap.newKeySet();
    private static short ticker = 0;
    private static List<String> childPlayerProtectionList = (List)PlayerProtection.COMMON.childPlayerProtectionList.get();
    private static boolean enableChildPlayerProtection = (Boolean)PlayerProtection.COMMON.enableChildPlayerProtection.get();
    private static boolean protectPlayerDuringLogin = (Boolean)PlayerProtection.COMMON.protectPlayerDuringLogin.get();
    private static boolean protectPlayerDuringLoginLogging = (Boolean)PlayerProtection.COMMON.protectPlayerDuringLoginLogging.get();
    private static int playerLoginValidationTimeout = (Integer)PlayerProtection.COMMON.playerLoginValidationTimeout.get();
    private static long playerLoginValidationTimeoutMilli = TimeUnit.SECONDS.toMillis(playerLoginValidationTimeout);

    protected PlayerProtection() {
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        playerValidationList = ConcurrentHashMap.newKeySet();
        childPlayerProtectionList = (List)PlayerProtection.COMMON.childPlayerProtectionList.get();
        enableChildPlayerProtection = (Boolean)PlayerProtection.COMMON.enableChildPlayerProtection.get();
        playerLoginValidationTimeout = (Integer)PlayerProtection.COMMON.playerLoginValidationTimeout.get();
        protectPlayerDuringLogin = (Boolean)PlayerProtection.COMMON.protectPlayerDuringLogin.get();
        protectPlayerDuringLoginLogging = (Boolean)PlayerProtection.COMMON.protectPlayerDuringLoginLogging.get();
        playerLoginValidationTimeoutMilli = TimeUnit.SECONDS.toMillis(playerLoginValidationTimeout);
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(ServerStartingEvent event) {
        if (protectPlayerDuringLogin) {
            log.info("Player will be protected during login for max. of {} secs.", (Object)playerLoginValidationTimeout);
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!protectPlayerDuringLogin) {
            return;
        }
        String username = event.getPlayer().m_7755_().getString();
        if (!username.isEmpty()) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(username);
            if (protectPlayerDuringLoginLogging) {
                log.info("Player {} {} logged in and will be protected for {} secs.", (Object)username, (Object)event.getEntity(), (Object)playerLoginValidationTimeout);
                player.m_6842_(true);
                player.m_20331_(true);
                player.m_5634_(1.0f);
            } else {
                log.debug("Player {} {} logged in.", (Object)username, (Object)event.getEntity());
            }
            if (enableChildPlayerProtection && childPlayerProtectionList.contains(username)) {
                log.info("Child Player {} logged-in and game settings adjusted for a better player experience.", (Object)username);
                if (player.f_36078_ < 50) {
                    player.m_9174_(++player.f_36078_);
                }
                player.m_5634_(10.0f);
                player.m_6842_(true);
                player.m_20331_(true);
            }
            playerValidationList.add(new PlayerValidation(player));
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!protectPlayerDuringLogin) {
            return;
        }
        String username = event.getPlayer().m_7755_().getString();
        if (!username.isEmpty()) {
            log.debug("Player {} logged out.", (Object)event.getEntity());
            PlayerProtection.removePlayer(username);
        }
    }

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        block9: {
            block8: {
                if (event.phase == TickEvent.Phase.END) break block8;
                short s = ticker;
                ticker = (short)(s + 1);
                if (s >= 40) break block9;
            }
            return;
        }
        if (!playerValidationList.isEmpty()) {
            try {
                for (PlayerValidation playerValidation : playerValidationList) {
                    String username = playerValidation.getUsername();
                    if (playerValidation.hasPlayerMoved()) {
                        long validationTimeInSecs = TimeUnit.MILLISECONDS.toSeconds(playerValidation.getValidationTimeElapsed());
                        log.info("{} {} was successful validated after {} secs.", (Object)(protectPlayerDuringLoginLogging ? "Protected Player" : "Player"), (Object)username, (Object)validationTimeInSecs);
                        PlayerProtection.addPlayer(username);
                        continue;
                    }
                    if (playerValidation.getValidationTimeElapsed() < playerLoginValidationTimeoutMilli) continue;
                    log.warn("User validation for {} timed out after {} secs.", (Object)username, (Object)playerLoginValidationTimeout);
                    PlayerProtection.addPlayer(username);
                }
            }
            catch (ConcurrentModificationException error) {
                log.error("Unexpected error during user validation. Please report the following error under {} .\n{}", (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues", (Object)error);
            }
        }
        ticker = 0;
    }

    private static void addPlayer(String username) {
        try {
            for (PlayerValidation playerValidation : playerValidationList) {
                boolean isChildPlayerAccount;
                if (!username.equals(playerValidation.getUsername())) continue;
                ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(username);
                log.debug("Found player {} with player validation {}", (Object)player, (Object)playerValidation);
                boolean bl = isChildPlayerAccount = enableChildPlayerProtection && childPlayerProtectionList.contains(username);
                if (protectPlayerDuringLoginLogging && (player.m_20145_() || player.m_20147_())) {
                    log.info("Removing player protection from player {}!", (Object)username);
                    if (player.m_20145_() && !isChildPlayerAccount) {
                        player.m_6842_(false);
                    }
                    if (player.m_20147_() && !isChildPlayerAccount) {
                        player.m_20331_(false);
                    }
                }
                playerValidationList.remove(playerValidation);
                break;
            }
        }
        catch (ConcurrentModificationException error) {
            log.error("Unexpected error during adding player. Please report the following error under {} .\n{}", (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues", (Object)error);
        }
        log.debug("Added player {}", (Object)username);
    }

    private static void removePlayer(String username) {
        try {
            for (PlayerValidation playerValidation : playerValidationList) {
                if (!username.equals(playerValidation.getUsername())) continue;
                playerValidationList.remove(playerValidation);
                break;
            }
        }
        catch (ConcurrentModificationException error) {
            log.error("Unexpected error during removing player. Please report the following error under {} .\n{}", (Object)"https://github.com/MarkusBordihn/BOs-Adaptive-Performance-Tweaks/issues", (Object)error);
        }
        log.debug("Remove player {}", (Object)username);
    }
}

