/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.player;

import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoadEvent;
import de.markusbordihn.adaptiveperformancetweaksplayer.config.CommonConfig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerSimulationDistance {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Player)");
    private static boolean optimizeSimulationDistance = (Boolean)PlayerSimulationDistance.COMMON.optimizeSimulationDistance.get();
    private static int simulationDistanceDefault = (Integer)PlayerSimulationDistance.COMMON.simulationDistanceDefault.get();
    private static int simulationDistanceMax = (Integer)PlayerSimulationDistance.COMMON.simulationDistanceMax.get();
    private static int simulationDistanceMin = (Integer)PlayerSimulationDistance.COMMON.simulationDistanceMin.get();
    private static int simulationDistanceTimeBetweenUpdates = (Integer)PlayerSimulationDistance.COMMON.simulationDistanceTimeBetweenUpdates.get();
    private static long lastUpdateTime = System.currentTimeMillis();
    private static int timeBetweenUpdates = 10000;

    protected PlayerSimulationDistance() {
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        optimizeSimulationDistance = (Boolean)PlayerSimulationDistance.COMMON.optimizeSimulationDistance.get();
        simulationDistanceDefault = (Integer)PlayerSimulationDistance.COMMON.simulationDistanceDefault.get();
        simulationDistanceMin = (Integer)PlayerSimulationDistance.COMMON.simulationDistanceMin.get();
        simulationDistanceMax = (Integer)PlayerSimulationDistance.COMMON.simulationDistanceMax.get();
        simulationDistanceTimeBetweenUpdates = (Integer)PlayerSimulationDistance.COMMON.simulationDistanceTimeBetweenUpdates.get();
        timeBetweenUpdates = simulationDistanceTimeBetweenUpdates * 1000;
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        if (!optimizeSimulationDistance) {
            return;
        }
        log.info("Simulation distance will be optimized between {} and {} with {} as default and {} sec delay between updates.", (Object)simulationDistanceMin, (Object)simulationDistanceMax, (Object)simulationDistanceDefault, (Object)simulationDistanceTimeBetweenUpdates);
        PlayerSimulationDistance.setSimulationDistance(simulationDistanceMin);
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        if (!optimizeSimulationDistance) {
            return;
        }
        boolean shouldOptimizeViewDistance = System.currentTimeMillis() - lastUpdateTime >= (long)timeBetweenUpdates;
        boolean hasUpdated = false;
        int numOfPlayers = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11309_();
        if (event.hasHighServerLoad()) {
            hasUpdated = PlayerSimulationDistance.decreaseSimulationDistance();
        } else if (event.hasNormalServerLoad() && numOfPlayers >= 1) {
            hasUpdated = PlayerSimulationDistance.decreaseSimulationDistance();
        } else if (shouldOptimizeViewDistance && event.hasNormalServerLoad() && numOfPlayers == 1) {
            hasUpdated = PlayerSimulationDistance.increaseSimulationDistance();
        } else if (shouldOptimizeViewDistance && event.hasLowServerLoad() && numOfPlayers >= 1) {
            hasUpdated = PlayerSimulationDistance.increaseSimulationDistance();
        }
        if (hasUpdated) {
            lastUpdateTime = System.currentTimeMillis();
        }
    }

    public static boolean setSimulationDistance(int simulationDistance) {
        if (simulationDistance > simulationDistanceMax) {
            simulationDistance = simulationDistanceMax;
        } else if (simulationDistance < simulationDistanceMin) {
            simulationDistance = simulationDistanceMin;
        }
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        PlayerList playerList = minecraftServer.m_6846_();
        if (!playerList.m_11314_().isEmpty() && playerList.m_184213_() != simulationDistance) {
            log.debug("Changing server simulation distance from {} to {} for {} players.", (Object)playerList.m_184213_(), (Object)simulationDistance, (Object)playerList.m_11314_().size());
            playerList.m_184211_(simulationDistance);
            return true;
        }
        return false;
    }

    public static boolean increaseSimulationDistance(int factor) {
        return PlayerSimulationDistance.setSimulationDistance(PlayerSimulationDistance.getSimulationDistance() + factor);
    }

    public static boolean decreaseSimulationDistance(int factor) {
        return PlayerSimulationDistance.setSimulationDistance(PlayerSimulationDistance.getSimulationDistance() - factor);
    }

    public static boolean increaseSimulationDistance() {
        return PlayerSimulationDistance.increaseSimulationDistance(1);
    }

    public static boolean decreaseSimulationDistance() {
        return PlayerSimulationDistance.decreaseSimulationDistance(1);
    }

    public static int getSimulationDistance() {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        PlayerList playerList = minecraftServer.m_6846_();
        return playerList.m_184213_() > 0 ? playerList.m_184213_() : simulationDistanceDefault;
    }

    public static int getMaxSimulationDistance() {
        return simulationDistanceMax;
    }

    public static int getMinSimulationDistance() {
        return simulationDistanceMin;
    }
}

