/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksplayer.player;

import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoadEvent;
import de.markusbordihn.adaptiveperformancetweaksplayer.config.CommonConfig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerViewDistance {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Logger log = LogManager.getLogger((String)"APTweaks(Player)");
    private static boolean optimizeViewDistance = (Boolean)PlayerViewDistance.COMMON.optimizeViewDistance.get();
    private static int viewDistanceDefault = (Integer)PlayerViewDistance.COMMON.viewDistanceDefault.get();
    private static int viewDistanceMax = (Integer)PlayerViewDistance.COMMON.viewDistanceMax.get();
    private static int viewDistanceMin = (Integer)PlayerViewDistance.COMMON.viewDistanceMin.get();
    private static int viewDistanceTimeBetweenUpdates = (Integer)PlayerViewDistance.COMMON.viewDistanceTimeBetweenUpdates.get();
    private static long lastUpdateTime = System.currentTimeMillis();
    private static int timeBetweenUpdates = 20000;

    protected PlayerViewDistance() {
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        optimizeViewDistance = (Boolean)PlayerViewDistance.COMMON.optimizeViewDistance.get();
        viewDistanceDefault = (Integer)PlayerViewDistance.COMMON.viewDistanceDefault.get();
        viewDistanceMin = (Integer)PlayerViewDistance.COMMON.viewDistanceMin.get();
        viewDistanceMax = (Integer)PlayerViewDistance.COMMON.viewDistanceMax.get();
        viewDistanceTimeBetweenUpdates = (Integer)PlayerViewDistance.COMMON.viewDistanceTimeBetweenUpdates.get();
        timeBetweenUpdates = viewDistanceTimeBetweenUpdates * 1000;
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        if (!optimizeViewDistance) {
            return;
        }
        log.info("View distance will be optimized between {} and {} with {} as default and {} sec delay between updates.", (Object)viewDistanceMin, (Object)viewDistanceMax, (Object)viewDistanceDefault, (Object)viewDistanceTimeBetweenUpdates);
        if (event.getServer().m_6982_()) {
            PlayerViewDistance.setViewDistance(viewDistanceMin);
        }
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        if (event.isClient() || !optimizeViewDistance) {
            return;
        }
        boolean shouldOptimizeViewDistance = System.currentTimeMillis() - lastUpdateTime >= (long)timeBetweenUpdates;
        boolean hasUpdated = false;
        int numOfPlayers = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11309_();
        if (event.hasHighServerLoad()) {
            hasUpdated = PlayerViewDistance.decreaseViewDistance();
        } else if (event.hasNormalServerLoad() && numOfPlayers >= 1) {
            hasUpdated = PlayerViewDistance.decreaseViewDistance();
        } else if (shouldOptimizeViewDistance && event.hasNormalServerLoad() && numOfPlayers == 1) {
            hasUpdated = PlayerViewDistance.increaseViewDistance();
        } else if (shouldOptimizeViewDistance && event.hasLowServerLoad() && numOfPlayers >= 1) {
            hasUpdated = PlayerViewDistance.increaseViewDistance();
        }
        if (hasUpdated) {
            lastUpdateTime = System.currentTimeMillis();
        }
    }

    public static boolean setViewDistance(int viewDistance) {
        if (viewDistance > viewDistanceMax) {
            viewDistance = viewDistanceMax;
        } else if (viewDistance < viewDistanceMin) {
            viewDistance = viewDistanceMin;
        }
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        PlayerList playerList = minecraftServer.m_6846_();
        if (!playerList.m_11314_().isEmpty() && playerList.m_11312_() != viewDistance) {
            log.debug("Changing server view distance from {} to {} for {} players.", (Object)playerList.m_11312_(), (Object)viewDistance, (Object)playerList.m_11314_().size());
            playerList.m_11217_(viewDistance);
            return true;
        }
        return false;
    }

    public static boolean defaultViewDistance() {
        return PlayerViewDistance.setViewDistance(viewDistanceDefault);
    }

    public static boolean increaseViewDistance(int factor) {
        return PlayerViewDistance.setViewDistance(PlayerViewDistance.getViewDistance() + factor);
    }

    public static boolean decreaseViewDistance(int factor) {
        return PlayerViewDistance.setViewDistance(PlayerViewDistance.getViewDistance() - factor);
    }

    public static boolean increaseViewDistance() {
        return PlayerViewDistance.increaseViewDistance(1);
    }

    public static boolean decreaseViewDistance() {
        return PlayerViewDistance.decreaseViewDistance(1);
    }

    public static int getViewDistance() {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        PlayerList playerList = minecraftServer.m_6846_();
        return playerList.m_11312_() > 0 ? playerList.m_11312_() : viewDistanceDefault;
    }

    public static int getMaxViewDistance() {
        return viewDistanceMax;
    }

    public static int getMinViewDistance() {
        return viewDistanceMin;
    }
}

