/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.worldgen.BOPBiomeProvider;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.BiomeProviders;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;

public final class BOPOverworldBiomeBuilder {
    private static final float VALLEY_SIZE = 0.05f;
    private static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    private static final float HIGH_END = 0.93333334f;
    private static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    private static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = -0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private final Climate.Parameter DEFAULT_DEPTH_RANGE = Climate.Parameter.m_186822_((float)0.2f, (float)0.9f);
    private final Climate.Parameter vanillaUniqueness = BiomeProviderUtils.getUniquenessParameter((int)BiomeProviders.getIndex((ResourceLocation)BiomeProviders.DEFAULT_PROVIDER_LOCATION));
    private final Climate.Parameter bopUniqueness = BiomeProviderUtils.getUniquenessParameter((int)BiomeProviders.getIndex((ResourceLocation)BOPBiomeProvider.LOCATION));
    private final Climate.Parameter rareUniqueness = BiomeProviderUtils.getUniquenessParameter((int)BiomeProviders.getIndex((ResourceLocation)BOPBiomeProvider.RARE_LOCATION));
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private static final Climate.Parameter COMMON_RARENESS_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)0.35f);
    private static final Climate.Parameter RARE_RARENESS_RANGE = Climate.Parameter.m_186822_((float)0.35f, (float)1.0f);
    private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
    private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
    private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
    private final ResourceKey<Biome>[][] OCEANS = new ResourceKey[][]{{Biomes.f_48172_, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_, Biomes.f_48166_}, {Biomes.f_48211_, Biomes.f_48168_, Biomes.f_48174_, Biomes.f_48167_, Biomes.f_48166_}};
    private final ResourceKey<Biome>[][] ISLAND_BIOMES_BOP = new ResourceKey[][]{{BOPBiomes.RAINBOW_HILLS, BOPBiomes.RAINBOW_HILLS, BOPBiomes.RAINBOW_HILLS, BOPBiomes.RAINBOW_HILLS, BOPBiomes.RAINBOW_HILLS}, {null, null, null, null, null}, {BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY}, {BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS}, {BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48206_}, {Biomes.f_48202_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_48179_, Biomes.f_48202_, Biomes.f_48205_, Biomes.f_48149_, Biomes.f_48151_}, {Biomes.f_48157_, Biomes.f_48157_, Biomes.f_48205_, Biomes.f_48222_, Biomes.f_48222_}, {Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_, Biomes.f_48203_}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48182_, null, Biomes.f_48152_, null, null}, {null, null, null, null, Biomes.f_186763_}, {Biomes.f_48176_, null, null, Biomes.f_186762_, null}, {null, null, Biomes.f_48202_, Biomes.f_186769_, Biomes.f_48197_}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_BOP = new ResourceKey[][]{{BOPBiomes.COLD_DESERT, BOPBiomes.TUNDRA, BOPBiomes.SNOWY_CONIFEROUS_FOREST, BOPBiomes.MAPLE_WOODS, BOPBiomes.DEAD_FOREST}, {BOPBiomes.SEASONAL_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.FIELD, BOPBiomes.FIELD}, {BOPBiomes.PRAIRIE, BOPBiomes.SHRUBLAND, BOPBiomes.SHRUBLAND, BOPBiomes.GRASSLAND, BOPBiomes.GRASSLAND}, {BOPBiomes.SCRUBLAND, BOPBiomes.MEDITERRANEAN_FOREST, BOPBiomes.WOODLAND, BOPBiomes.RAINFOREST, BOPBiomes.RAINFOREST}, {BOPBiomes.WASTELAND, BOPBiomes.WASTELAND, BOPBiomes.DRYLAND, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT_BOP = new ResourceKey[][]{{null, null, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_MAPLE_WOODS, BOPBiomes.OLD_GROWTH_DEAD_FOREST}, {BOPBiomes.PUMPKIN_PATCH, BOPBiomes.FIR_CLEARING, null, null, BOPBiomes.FORESTED_FIELD}, {BOPBiomes.PASTURE, BOPBiomes.LAVENDER_FIELD, BOPBiomes.REDWOOD_FOREST, BOPBiomes.CLOVER_PATCH, BOPBiomes.CHERRY_BLOSSOM_GROVE}, {null, null, BOPBiomes.OLD_GROWTH_WOODLAND, null, BOPBiomes.ROCKY_RAINFOREST}, {null, BOPBiomes.WOODED_WASTELAND, null, BOPBiomes.LUSH_SAVANNA, BOPBiomes.VOLCANIC_PLAINS}};
    private final ResourceKey<Biome>[][] SWAMP_BIOMES_BOP = new ResourceKey[][]{{null, null, null, null, null}, {BOPBiomes.BOG, BOPBiomes.BOG, BOPBiomes.WETLAND, BOPBiomes.WETLAND, BOPBiomes.WETLAND}, {BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH}, {BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] RARE_BIOMES_BOP = new ResourceKey[][]{{null, null, null, BOPBiomes.MUSKEG, null}, {null, null, BOPBiomes.OMINOUS_WOODS, null, null}, {null, null, null, null, BOPBiomes.MYSTIC_GROVE}, {null, null, null, BOPBiomes.FUNGAL_JUNGLE, null}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{Biomes.f_186761_, Biomes.f_186761_, Biomes.f_186761_, Biomes.f_48152_, Biomes.f_48152_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48205_, Biomes.f_48206_, Biomes.f_186764_}, {Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_48151_}, {Biomes.f_48158_, Biomes.f_48158_, Biomes.f_48205_, Biomes.f_48205_, Biomes.f_48222_}, {Biomes.f_48159_, Biomes.f_48159_, Biomes.f_48159_, Biomes.f_186753_, Biomes.f_186753_}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.f_48182_, null, null, null, null}, {null, null, Biomes.f_186754_, Biomes.f_186754_, Biomes.f_186763_}, {null, null, Biomes.f_48205_, Biomes.f_48149_, null}, {null, null, null, null, null}, {Biomes.f_48194_, Biomes.f_48194_, null, null, null}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES_BOP = new ResourceKey[][]{{BOPBiomes.COLD_DESERT, BOPBiomes.TUNDRA, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.MAPLE_WOODS, BOPBiomes.DEAD_FOREST}, {BOPBiomes.SEASONAL_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.FIELD}, {BOPBiomes.ORCHARD, BOPBiomes.ROCKY_SHRUBLAND, BOPBiomes.ROCKY_SHRUBLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND}, {BOPBiomes.WOODED_SCRUBLAND, BOPBiomes.MEDITERRANEAN_FOREST, BOPBiomes.WOODLAND, BOPBiomes.RAINFOREST, BOPBiomes.ROCKY_RAINFOREST}, {BOPBiomes.WASTELAND, BOPBiomes.WASTELAND, BOPBiomes.DRYLAND, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT_BOP = new ResourceKey[][]{{null, null, null, BOPBiomes.SNOWY_MAPLE_WOODS, null}, {BOPBiomes.BOREAL_FOREST, null, null, null, null}, {null, BOPBiomes.LAVENDER_FOREST, null, BOPBiomes.HIGHLAND_MOOR, BOPBiomes.BAMBOO_GROVE}, {null, null, null, BOPBiomes.ROCKY_RAINFOREST, null}, {null, null, null, BOPBiomes.LUSH_SAVANNA, BOPBiomes.VOLCANO}};
    private final ResourceKey<Biome>[][] EXTREME_HILLS = new ResourceKey[][]{{Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186766_, Biomes.f_186766_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186765_, Biomes.f_186767_, Biomes.f_186767_}, {null, null, null, null, null}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] EXTREME_HILLS_BOP = new ResourceKey[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, BOPBiomes.ROCKY_RAINFOREST}, {null, null, null, null, BOPBiomes.VOLCANO}};

    public List<TBClimate.ParameterPoint> spawnTarget() {
        Climate.Parameter climate$parameter = Climate.Parameter.m_186820_((float)0.0f);
        float f = 0.16f;
        return List.of(new TBClimate.ParameterPoint(this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.FULL_RANGE), this.FULL_RANGE, climate$parameter, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.16f), this.FULL_RANGE, 0L), new TBClimate.ParameterPoint(this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.FULL_RANGE), this.FULL_RANGE, climate$parameter, Climate.Parameter.m_186822_((float)0.16f, (float)1.0f), this.FULL_RANGE, 0L));
    }

    public void addBiomes(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        if (!SharedConstants.f_183698_) {
            this.addOffCoastBiomes(biomeRegistry, mapper);
            this.addInlandBiomes(biomeRegistry, mapper);
            this.addUndergroundBiomeVanilla(biomeRegistry, mapper);
        }
    }

    private void addOffCoastBiomes(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> islandBiomeBOP = this.pickIslandBiomeBOP(biomeRegistry, i, j);
                this.addSurfaceBiomeGlobal(mapper, temperature, humidity, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, islandBiomeBOP);
            }
            this.addSurfaceBiomeGlobal(mapper, temperature, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[0][i]);
            this.addSurfaceBiomeGlobal(mapper, temperature, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[1][i]);
        }
    }

    private void addInlandBiomes(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addMidSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.addValleys(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.addLowSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.addMidSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.addHighSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.addPeaks(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(biomeRegistry, mapper, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> middleOrBadlandsBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> rareBiomeBOP = this.pickRareBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiome = this.pickExtremeHillsBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(i, j, weirdness, extremeHillsBiome);
                ResourceKey<Biome> peakBiome = this.pickPeakBiome(i, j, weirdness);
                ResourceKey<Biome> peakBiomeBOP = this.pickPeakBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiome, peakBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeVanilla, middleBadlandsOrSlopeBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, peakBiome, peakBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome, plateauBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleOrBadlandsBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome, plateauBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiome, extremeHillsBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
            }
        }
    }

    private void addHighSlice(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> middleOrBadlandsBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> rareBiomeBOP = this.pickRareBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiome = this.pickExtremeHillsBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> slopeBiomeVanilla = this.pickSlopeBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> slopeBiomeBOP = this.pickSlopeBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> peakBiome = this.pickPeakBiome(i, j, weirdness);
                ResourceKey<Biome> peakBiomeBOP = this.pickPeakBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, slopeBiomeVanilla, slopeBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiome, peakBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeVanilla, middleBadlandsOrSlopeBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, slopeBiomeVanilla, slopeBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome, plateauBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleOrBadlandsBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome, plateauBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiome, extremeHillsBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
            }
        }
    }

    private void addMidSlice(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        this.addSurfaceBiome(mapper, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_186760_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> middleOrBadlandsBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiome = this.pickExtremeHillsBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> plateauBiomeVanilla = this.pickPlateauBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> beachBiome = this.pickBeachBiome(biomeRegistry, i, j);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> slopeBiomeVanilla = this.pickSlopeBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> slopeBiomeBOP = this.pickSlopeBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> rareBiomeBOP = this.pickRareBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, slopeBiomeVanilla, slopeBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeVanilla, middleBadlandsOrSlopeBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? slopeBiomeVanilla : plateauBiomeVanilla, i == 0 ? slopeBiomeBOP : plateauBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleOrBadlandsBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, plateauBiomeVanilla, plateauBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleOrBadlandsBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                if (weirdness.f_186814_() < 0L) {
                    this.addSurfaceBiomeGlobal(mapper, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, beachBiome);
                    this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                } else {
                    this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                }
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiome, extremeHillsBiomeBOP);
                if (weirdness.f_186814_() < 0L) {
                    this.addSurfaceBiomeGlobal(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                } else {
                    this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                }
                if (i == 0) {
                    this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.MUSKEG, rareBiomeBOP));
                    continue;
                }
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48207_, swampBiomeBOP);
            }
        }
    }

    private void addLowSlice(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        this.addSurfaceBiome(mapper, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_186760_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> middleOrBadlandsBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> beachBiome = this.pickBeachBiome(biomeRegistry, i, j);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> rareBiomeBOP = this.pickRareBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleOrBadlandsBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBadlandsOrSlopeBiomeVanilla, middleBadlandsOrSlopeBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleOrBadlandsBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addSurfaceBiomeGlobal(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), weirdness, 0.0f, beachBiome);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                this.addSurfaceBiomeGlobal(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                if (i == 0) {
                    this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeVanilla, middleBiomeBOP, BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.MUSKEG, rareBiomeBOP));
                    continue;
                }
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48207_, swampBiomeBOP);
            }
        }
    }

    private void addValleys(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        this.addSurfaceBiome(mapper, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.f_186814_() < 0L ? Biomes.f_186760_ : Biomes.f_48212_));
        this.addSurfaceBiome(mapper, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, (ResourceKey<Biome>)(weirdness.f_186814_() < 0L ? Biomes.f_186760_ : Biomes.f_48208_));
        this.addSurfaceBiome(mapper, this.FROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(mapper, this.UNFROZEN_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.addSurfaceBiome(mapper, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(mapper, this.UNFROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.addSurfaceBiome(mapper, this.FROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        this.addSurfaceBiome(mapper, this.UNFROZEN_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48208_);
        this.addSurfaceBiome(mapper, this.FROZEN_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48212_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleOrBadlandsBiomeVanilla = this.pickMiddleBiomeOrBadlandsIfHotVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> rareBiomeBOP = this.pickRareBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleOrBadlandsBiomeVanilla, middleBiomeBOP, rareBiomeBOP);
                if (i == 0) continue;
                this.addParallelSurfaceBiomes(mapper, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, (ResourceKey<Biome>)Biomes.f_48207_, swampBiomeBOP);
            }
        }
    }

    private void addUndergroundBiomeVanilla(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addUndergroundBiomeVanilla(mapper, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.DEFAULT_DEPTH_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.f_151784_);
        this.addUndergroundBiomeVanilla(mapper, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, this.DEFAULT_DEPTH_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.f_151785_);
        this.addUndergroundBiomeBOP(biomeRegistry, mapper, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.DEFAULT_DEPTH_RANGE, 0.0f, BOPBiomes.SPIDER_NEST);
        this.addUndergroundBiomeBOP(biomeRegistry, mapper, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, this.DEFAULT_DEPTH_RANGE, 0.0f, BOPBiomes.GLOWING_GROTTO);
    }

    private ResourceKey<Biome> pickIslandBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.ISLAND_BIOMES_BOP[temperatureIndex][humidityIndex], Biomes.f_48215_);
    }

    private ResourceKey<Biome> pickMiddleBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            return this.MIDDLE_BIOMES[temperatureIndex][humidityIndex];
        }
        ResourceKey<Biome> variantBiome = this.MIDDLE_BIOMES_VARIANT[temperatureIndex][humidityIndex];
        return variantBiome == null ? this.MIDDLE_BIOMES[temperatureIndex][humidityIndex] : variantBiome;
    }

    private ResourceKey<Biome> pickMiddleBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> middleBiome = BiomeUtil.biomeOrFallback(biomeRegistry, this.MIDDLE_BIOMES_BOP[temperatureIndex][humidityIndex], this.MIDDLE_BIOMES[temperatureIndex][humidityIndex]);
        if (weirdness.f_186814_() < 0L) {
            return middleBiome;
        }
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.MIDDLE_BIOMES_VARIANT_BOP[temperatureIndex][humidityIndex], middleBiome);
    }

    private ResourceKey<Biome> pickRareBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> middleBiome = this.pickMiddleBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness);
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.RARE_BIOMES_BOP[temperatureIndex][humidityIndex], middleBiome);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return temperatureIndex == 4 ? this.pickBadlandsBiome(humidityIndex, weirdness) : this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return temperatureIndex == 0 ? this.pickSlopeBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : this.pickMiddleBiomeOrBadlandsIfHotVanilla(temperatureIndex, humidityIndex, weirdness);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return temperatureIndex == 0 ? this.pickSlopeBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness) : this.pickMiddleBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness);
    }

    private ResourceKey<Biome> pickSwampBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.SWAMP_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickMiddleBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness), Biomes.f_48207_);
    }

    private ResourceKey<Biome> maybePickShatteredBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness, ResourceKey<Biome> extremeHillsBiome) {
        return temperatureIndex > 1 && humidityIndex < 4 && weirdness.f_186814_() >= 0L ? Biomes.f_186768_ : extremeHillsBiome;
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourcekey = weirdness.f_186814_() >= 0L ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : this.pickBeachBiome(biomeRegistry, temperatureIndex, humidityIndex);
        return this.maybePickShatteredBiome(temperatureIndex, humidityIndex, weirdness, resourcekey);
    }

    private ResourceKey<Biome> pickBeachBiome(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex) {
        if (temperatureIndex == 0) {
            return Biomes.f_48148_;
        }
        if (temperatureIndex == 2 && humidityIndex < 2) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.DUNE_BEACH, Biomes.f_48217_);
        }
        return temperatureIndex == 4 ? Biomes.f_48203_ : Biomes.f_48217_;
    }

    private ResourceKey<Biome> pickBadlandsBiome(int humidityIndex, Climate.Parameter weirdness) {
        if (humidityIndex < 2) {
            return weirdness.f_186814_() < 0L ? Biomes.f_48194_ : Biomes.f_48159_;
        }
        return humidityIndex < 3 ? Biomes.f_48159_ : Biomes.f_186753_;
    }

    private ResourceKey<Biome> pickPlateauBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            return this.PLATEAU_BIOMES[temperatureIndex][humidityIndex];
        }
        ResourceKey<Biome> resourcekey = this.PLATEAU_BIOMES_VARIANT[temperatureIndex][humidityIndex];
        return resourcekey == null ? this.PLATEAU_BIOMES[temperatureIndex][humidityIndex] : resourcekey;
    }

    private ResourceKey<Biome> pickPlateauBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, this.PLATEAU_BIOMES_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
        }
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.PLATEAU_BIOMES_VARIANT_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
    }

    private ResourceKey<Biome> pickPeakBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (temperatureIndex <= 2) {
            return weirdness.f_186814_() < 0L ? Biomes.f_186758_ : Biomes.f_186757_;
        }
        return temperatureIndex == 3 ? Biomes.f_186759_ : this.pickBadlandsBiome(humidityIndex, weirdness);
    }

    private ResourceKey<Biome> pickPeakBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> peakBiome = this.pickPeakBiome(temperatureIndex, humidityIndex, weirdness);
        if (temperatureIndex == 1) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.CRAG, peakBiome);
        }
        if (temperatureIndex == 2) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.JADE_CLIFFS, peakBiome);
        }
        if (temperatureIndex == 3 && humidityIndex >= 3) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.ROCKY_RAINFOREST, peakBiome);
        }
        if (temperatureIndex == 4 && humidityIndex == 4) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.VOLCANO, peakBiome);
        }
        return peakBiome;
    }

    private ResourceKey<Biome> pickSlopeBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (temperatureIndex >= 3) {
            return this.pickPlateauBiomeVanilla(temperatureIndex, humidityIndex, weirdness);
        }
        return humidityIndex <= 1 ? Biomes.f_186756_ : Biomes.f_186755_;
    }

    private ResourceKey<Biome> pickSlopeBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> plateauBiome = this.pickPlateauBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness);
        if (temperatureIndex == 1) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.CRAG, plateauBiome);
        }
        if (temperatureIndex == 2) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.JADE_CLIFFS, plateauBiome);
        }
        if (temperatureIndex == 3 && humidityIndex >= 3) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.ROCKY_RAINFOREST, plateauBiome);
        }
        if (temperatureIndex == 4 && humidityIndex == 4) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.VOLCANO, plateauBiome);
        }
        return plateauBiome;
    }

    private ResourceKey<Biome> pickExtremeHillsBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourcekey = this.EXTREME_HILLS[temperatureIndex][humidityIndex];
        return resourcekey == null ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : resourcekey;
    }

    private ResourceKey<Biome> pickExtremeHillsBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.EXTREME_HILLS_BOP[temperatureIndex][humidityIndex], this.pickExtremeHillsBiomeVanilla(temperatureIndex, humidityIndex, weirdness));
    }

    private void addParallelSurfaceBiomes(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> vanillaBiome, ResourceKey<Biome> bopBiome) {
        this.addParallelSurfaceBiomes(mapper, temperature, humidity, continentalness, erosion, weirdness, offset, vanillaBiome, bopBiome, bopBiome);
    }

    private void addParallelSurfaceBiomes(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> vanillaBiome, ResourceKey<Biome> bopBiome, ResourceKey<Biome> rareBiome) {
        this.addSurfaceBiome(mapper, temperature, humidity, continentalness, erosion, weirdness, this.vanillaUniqueness, offset, vanillaBiome);
        this.addSurfaceBiome(mapper, temperature, humidity, continentalness, erosion, weirdness, this.bopUniqueness, offset, bopBiome);
        this.addSurfaceBiome(mapper, temperature, humidity, continentalness, erosion, weirdness, this.rareUniqueness, offset, rareBiome);
    }

    private void addSurfaceBiome(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        this.addSurfaceBiome(mapper, temperature, humidity, continentalness, erosion, weirdness, this.vanillaUniqueness, offset, biome);
    }

    private void addSurfaceBiomeGlobal(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        this.addSurfaceBiome(mapper, temperature, humidity, continentalness, erosion, weirdness, this.FULL_RANGE, offset, biome);
    }

    private void addSurfaceBiome(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, Climate.Parameter uniqueness, float offset, ResourceKey<Biome> biome) {
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)weirdness, (Climate.Parameter)uniqueness, (float)offset), biome));
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)weirdness, (Climate.Parameter)uniqueness, (float)offset), biome));
    }

    private void addUndergroundBiomeVanilla(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, Climate.Parameter depth, float offset, ResourceKey<Biome> biome) {
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (Climate.Parameter)this.vanillaUniqueness, (float)offset), biome));
    }

    private void addUndergroundBiomeBOP(Registry<Biome> biomeRegistry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, Climate.Parameter depth, float offset, ResourceKey<Biome> biome) {
        if (!BiomeUtil.isKeyRegistered(biomeRegistry, biome)) {
            return;
        }
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (Climate.Parameter)this.bopUniqueness, (float)offset), biome));
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (Climate.Parameter)this.rareUniqueness, (float)offset), biome));
    }
}

