/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.data;

import biomesoplenty.common.util.config.JsonUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.fml.loading.FMLPaths;
import terrablender.api.WorldPresetUtils;

public class DataGenerator {
    private static final Path DATA_PATH = FMLPaths.GAMEDIR.get().resolve("bop_worldgen/data");
    private static Map<Integer, ResourceLocation> locationSubstitions = Maps.newHashMap();

    public static void generateData(RegistryAccess registryAccess) {
        RegistryAccess.RegistryHolder newRegistryAccess = RegistryAccess.m_123086_();
        Registry dimensionTypeRegistry = registryAccess.m_175515_(Registry.f_122818_);
        long seed = 0L;
        WorldGenSettings settings = WorldPresetUtils.settings((RegistryAccess)registryAccess, (long)seed, (boolean)true, (boolean)false, (MappedRegistry)WorldPresetUtils.dimensions((RegistryAccess)registryAccess, (long)seed), (ChunkGenerator)WorldPresetUtils.amplifiedChunkGenerator((RegistryAccess)registryAccess, (long)seed));
        ImmutableSet registryCodecs = ImmutableSet.builder().add((Object)Pair.of((Object)settings.m_64663_(), (Object)LevelStem.f_63970_)).add((Object)Pair.of((Object)dimensionTypeRegistry, (Object)DimensionType.f_63853_)).add((Object)Pair.of((Object)BuiltinRegistries.f_123865_, (Object)Biome.f_47431_)).add((Object)Pair.of((Object)BuiltinRegistries.f_123860_, (Object)ConfiguredWorldCarver.f_64847_)).add((Object)Pair.of((Object)BuiltinRegistries.f_123861_, (Object)ConfiguredFeature.f_65374_)).add((Object)Pair.of((Object)BuiltinRegistries.f_123862_, (Object)ConfiguredStructureFeature.f_65401_)).add((Object)Pair.of((Object)BuiltinRegistries.f_194654_, (Object)NormalNoise.NoiseParameters.f_192852_)).add((Object)Pair.of((Object)BuiltinRegistries.f_123866_, (Object)NoiseGeneratorSettings.f_64431_)).add((Object)Pair.of((Object)BuiltinRegistries.f_194653_, (Object)PlacedFeature.f_191773_)).add((Object)Pair.of((Object)BuiltinRegistries.f_123863_, (Object)StructureProcessorType.f_74468_)).add((Object)Pair.of((Object)BuiltinRegistries.f_123864_, (Object)StructureTemplatePool.f_69246_)).build();
        DataGenerator.addRegistrySubstitutions(registryAccess.m_175515_(Registry.f_122885_), Biome.f_47431_);
        for (Pair registryCodecPair : registryCodecs) {
            DataGenerator.addRegistrySubstitutions((Registry)registryCodecPair.getFirst(), (Codec)registryCodecPair.getSecond());
        }
        for (Pair registryCodecPair : registryCodecs) {
            DataGenerator.generateRegistryJsons((Registry)registryCodecPair.getFirst(), (Codec)registryCodecPair.getSecond());
        }
    }

    private static <T> void addRegistrySubstitutions(Registry<T> registry, Codec<Supplier<T>> codec) {
        for (Map.Entry entry : registry.m_6579_()) {
            DataGenerator.encodeJson(entry.getValue(), codec).ifPresent(element -> locationSubstitions.put(element.hashCode(), ((ResourceKey)entry.getKey()).m_135782_()));
        }
    }

    private static <T> void generateRegistryJsons(Registry<T> registry, Codec codec) {
        for (Map.Entry entry : registry.m_6579_()) {
            DataGenerator.generateJson(registry, (ResourceKey)entry.getKey(), codec);
        }
    }

    private static <T> void generateJson(Registry<T> registry, ResourceKey<T> key, Codec codec) {
        Object type = registry.m_6246_(key);
        Optional<JsonElement> encodedResult = DataGenerator.encodeJson(type, codec);
        Path path = DATA_PATH.resolve(key.m_135782_().m_135827_() + "/" + key.getRegistryName().m_135815_());
        if (encodedResult.isPresent()) {
            JsonElement element = encodedResult.get();
            DataGenerator.substituteWithLocations(element);
            JsonUtil.writeFile(path.resolve(key.m_135782_().m_135815_() + ".json").toFile(), element);
        }
    }

    private static void substituteWithLocations(JsonElement element) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            Iterator it = array.iterator();
            ArrayList elementsToInsert = Lists.newArrayList();
            while (it.hasNext()) {
                JsonElement arrayElement = (JsonElement)it.next();
                int hash = arrayElement.hashCode();
                if (locationSubstitions.containsKey(hash)) {
                    it.remove();
                    elementsToInsert.add(new JsonPrimitive(locationSubstitions.get(hash).toString()));
                    continue;
                }
                DataGenerator.substituteWithLocations(arrayElement);
            }
            elementsToInsert.forEach(elementToInsert -> array.add(elementToInsert));
            return;
        }
        if (!element.isJsonObject()) {
            return;
        }
        JsonObject obj = element.getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            String fieldName = (String)entry.getKey();
            int hash = ((JsonElement)entry.getValue()).hashCode();
            if (locationSubstitions.containsKey(hash)) {
                obj.add(fieldName, (JsonElement)new JsonPrimitive(locationSubstitions.get(hash).toString()));
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonObject() && !((JsonElement)entry.getValue()).isJsonArray()) continue;
            DataGenerator.substituteWithLocations((JsonElement)entry.getValue());
        }
    }

    private static <T> Optional<JsonElement> encodeJson(T type, Codec codec) {
        try {
            return codec.encodeStart((DynamicOps)JsonOps.INSTANCE, () -> type).result();
        }
        catch (ClassCastException e) {
            return codec.encodeStart((DynamicOps)JsonOps.INSTANCE, type).result();
        }
    }
}

