/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.biome.BOPOverworldBiomeBuilder;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.worldgen.BOPSurfaceRuleData;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.api.BiomeProvider;
import terrablender.api.BiomeProviders;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;

public class BOPBiomeProvider
extends BiomeProvider {
    public static final ResourceLocation LOCATION = new ResourceLocation("biomesoplenty", "biome_provider");
    public static final ResourceLocation RARE_LOCATION = new ResourceLocation("biomesoplenty", "rare_biome_provider");

    public BOPBiomeProvider(int overworldWeight, int netherWeight) {
        super(LOCATION, overworldWeight, netherWeight);
    }

    public void addOverworldBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        new BOPOverworldBiomeBuilder().addBiomes(registry, mapper);
    }

    public void addNetherBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addVanillaBiome(mapper, Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.0f, (ResourceKey<Biome>)Biomes.f_48209_);
        this.addVanillaBiome(mapper, Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)-0.5f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.0f, (ResourceKey<Biome>)Biomes.f_48199_);
        this.addVanillaBiome(mapper, Climate.Parameter.m_186820_((float)0.4f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.0f, (ResourceKey<Biome>)Biomes.f_48200_);
        this.addVanillaBiome(mapper, Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.5f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.375f, (ResourceKey<Biome>)Biomes.f_48201_);
        this.addVanillaBiome(mapper, Climate.Parameter.m_186820_((float)-0.5f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.175f, (ResourceKey<Biome>)Biomes.f_48175_);
        this.addBiomeRare(mapper, Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.0f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.WITHERED_ABYSS, Biomes.f_48209_));
        this.addBiomeRareAndCommon(mapper, Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)-0.5f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.0f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.CRYSTALLINE_CHASM, Biomes.f_48199_));
        this.addBiomeRareAndCommon(mapper, Climate.Parameter.m_186820_((float)0.4f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.0f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.UNDERGROWTH, Biomes.f_48200_));
        this.addBiomeRareAndCommon(mapper, Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.5f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.375f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.VISCERAL_HEAP, Biomes.f_48201_));
        this.addBiomeRareAndCommon(mapper, Climate.Parameter.m_186820_((float)-0.5f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), Climate.Parameter.m_186820_((float)0.0f), 0.175f, BiomeUtil.biomeOrFallback(registry, BOPBiomes.ERUPTING_INFERNO, Biomes.f_48175_));
    }

    public Optional<SurfaceRules.RuleSource> getOverworldSurfaceRules() {
        return Optional.of(BOPSurfaceRuleData.overworld());
    }

    public Optional<SurfaceRules.RuleSource> getNetherSurfaceRules() {
        return Optional.of(BOPSurfaceRuleData.nether());
    }

    public List<TBClimate.ParameterPoint> getSpawnTargets() {
        return new BOPOverworldBiomeBuilder().spawnTarget();
    }

    protected final void addBiomeRare(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, Climate.Parameter depth, float offset, ResourceKey<Biome> biome) {
        Climate.Parameter rareUniqueness = BiomeProviderUtils.getUniquenessParameter((int)BiomeProviders.getIndex((ResourceLocation)RARE_LOCATION));
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (Climate.Parameter)rareUniqueness, (float)offset), biome));
    }

    protected final void addBiomeRareAndCommon(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, Climate.Parameter depth, float offset, ResourceKey<Biome> biome) {
        Climate.Parameter bopUniqueness = BiomeProviderUtils.getUniquenessParameter((int)BiomeProviders.getIndex((ResourceLocation)LOCATION));
        Climate.Parameter rareUniqueness = BiomeProviderUtils.getUniquenessParameter((int)BiomeProviders.getIndex((ResourceLocation)RARE_LOCATION));
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (Climate.Parameter)bopUniqueness, (float)offset), biome));
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (Climate.Parameter)rareUniqueness, (float)offset), biome));
    }

    private final void addVanillaBiome(Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, Climate.Parameter depth, float offset, ResourceKey<Biome> biome) {
        Climate.Parameter vanillaUniqueness = BiomeProviderUtils.getUniquenessParameter((int)BiomeProviders.getIndex((ResourceLocation)BiomeProviders.DEFAULT_PROVIDER_LOCATION));
        mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)TBClimate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (Climate.Parameter)vanillaUniqueness, (float)offset), biome));
    }
}

