/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TransferState;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TesseractTile
extends BaseTileEntity {
    private TesseractReference reference;
    private final EnumMap<EnumChannelType, Integer> channels = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, TransferState> transferState = new EnumMap(EnumChannelType.class);
    private RedstoneState redstoneState = RedstoneState.DISABLED;
    private boolean redstone;
    public int recurrentCalls = 0;
    private final Map<Direction, Map<Capability<?>, Object>> capabilities = new HashMap();

    public TesseractTile(BlockPos pos, BlockState state) {
        super(Tesseract.tesseract_tile, pos, state);
        for (EnumChannelType enumChannelType : EnumChannelType.values()) {
            this.channels.put(enumChannelType, -1);
            this.transferState.put(enumChannelType, TransferState.BOTH);
        }
        for (EnumChannelType enumChannelType : Direction.values()) {
            this.capabilities.put((Direction)enumChannelType, new HashMap());
        }
    }

    public void setChannel(EnumChannelType type, int channel) {
        Channel newChannel;
        if (channel == this.channels.get((Object)type)) {
            return;
        }
        Channel oldChannel = this.getChannel(type);
        this.channels.put(type, channel);
        if (oldChannel != null) {
            oldChannel.removeTesseract(this.reference);
        }
        if ((newChannel = this.getChannel(type)) != null) {
            newChannel.addTesseract(this.reference);
        }
        this.updateReference();
        this.dataChanged();
    }

    public boolean renderOn() {
        return this.redstoneState == RedstoneState.DISABLED || this.redstoneState == (this.redstone ? RedstoneState.HIGH : RedstoneState.LOW);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.getChannel(EnumChannelType.ITEMS) == null) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> this.getChannel(EnumChannelType.ITEMS).getItemHandler(this)).cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.getChannel(EnumChannelType.FLUID) == null) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> this.getChannel(EnumChannelType.FLUID).getFluidHandler(this)).cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.getChannel(EnumChannelType.ENERGY) == null) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> this.getChannel(EnumChannelType.ENERGY).getEnergyStorage(this)).cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public <T> List<T> getSurroundingCapabilities(Capability<T> capability) {
        if (this.f_58857_ == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Direction facing : Direction.values()) {
            if (!this.capabilities.get(facing).containsKey(capability)) {
                BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
                if (tile == null || tile instanceof TesseractTile) continue;
                tile.getCapability(capability, facing.m_122424_()).ifPresent(object -> {
                    this.capabilities.get(facing).put(capability, object);
                    list.add(object);
                });
                continue;
            }
            list.add(this.capabilities.get(facing).get(capability));
        }
        return list;
    }

    public boolean canSend(EnumChannelType type) {
        return this.transferState.get((Object)type).canSend() && (this.redstoneState == RedstoneState.DISABLED || this.redstoneState == (this.redstone ? RedstoneState.HIGH : RedstoneState.LOW));
    }

    public boolean canReceive(EnumChannelType type) {
        return this.transferState.get((Object)type).canReceive() && (this.redstoneState == RedstoneState.DISABLED || this.redstoneState == (this.redstone ? RedstoneState.HIGH : RedstoneState.LOW));
    }

    public int getChannelId(EnumChannelType type) {
        return this.channels.get((Object)type);
    }

    public TransferState getTransferState(EnumChannelType type) {
        return this.transferState.get((Object)type);
    }

    public void cycleTransferState(EnumChannelType type) {
        TransferState transferState = this.transferState.get((Object)type);
        this.transferState.put(type, transferState == TransferState.BOTH ? TransferState.SEND : (transferState == TransferState.SEND ? TransferState.RECEIVE : TransferState.BOTH));
        this.updateReference();
        this.dataChanged();
    }

    public RedstoneState getRedstoneState() {
        return this.redstoneState;
    }

    public void cycleRedstoneState() {
        this.redstoneState = this.redstoneState == RedstoneState.DISABLED ? RedstoneState.HIGH : (this.redstoneState == RedstoneState.HIGH ? RedstoneState.LOW : RedstoneState.DISABLED);
        this.updateReference();
        this.dataChanged();
    }

    public void setPowered(boolean powered) {
        if (this.redstone != powered) {
            this.redstone = powered;
            this.updateReference();
            this.dataChanged();
        }
    }

    public void onLoad() {
        if (!this.f_58857_.f_46443_) {
            this.reference = TesseractTracker.SERVER.add(this);
        }
    }

    public void m_6339_() {
        if (!this.f_58857_.f_46443_) {
            this.reference = TesseractTracker.SERVER.add(this);
        }
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.m_128405_(type.name(), this.channels.get((Object)type).intValue());
            compound.m_128359_("transferState" + type.name(), this.transferState.get((Object)type).name());
        }
        compound.m_128359_("redstoneState", this.redstoneState.name());
        compound.m_128379_("powered", this.redstone);
        return compound;
    }

    protected void readData(CompoundTag compound) {
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, compound.m_128451_(type.name()));
            if (!compound.m_128441_("transferState" + type.name())) continue;
            this.transferState.put(type, TransferState.valueOf(compound.m_128461_("transferState" + type.name())));
        }
        if (compound.m_128441_("redstoneState")) {
            this.redstoneState = RedstoneState.valueOf(compound.m_128461_("redstoneState"));
        }
        if (compound.m_128441_("powered")) {
            this.redstone = compound.m_128471_("powered");
        }
    }

    private Channel getChannel(EnumChannelType type) {
        if (this.channels.get((Object)type) < 0 || this.f_58857_ == null) {
            return null;
        }
        Channel channel = TesseractChannelManager.getInstance(this.f_58857_).getChannelById(type, this.channels.get((Object)type));
        if (channel == null && !this.f_58857_.f_46443_) {
            this.channels.put(type, -1);
            this.updateReference();
            this.dataChanged();
        }
        return channel;
    }

    public void onNeighborChanged(BlockPos neighbor) {
        Direction facing = Direction.m_122372_((float)(neighbor.m_123341_() - this.f_58858_.m_123341_()), (float)(neighbor.m_123342_() - this.f_58858_.m_123342_()), (float)(neighbor.m_123343_() - this.f_58858_.m_123343_()));
        this.capabilities.get(facing).clear();
    }

    public void dataChanged() {
        super.dataChanged();
        this.f_58857_.m_6289_(this.f_58858_, this.m_58900_().m_60734_());
    }

    private void updateReference() {
        if (this.reference != null) {
            this.reference.update(this);
        }
    }

    public void onReplaced() {
        if (this.f_58857_.f_46443_) {
            for (EnumChannelType type : EnumChannelType.values()) {
                Channel channel = this.getChannel(type);
                if (channel == null) continue;
                channel.removeTesseract(this.reference);
            }
            TesseractTracker.SERVER.remove(this.f_58857_, this.f_58858_);
        }
    }
}

