/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.TileEntityBaseScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.ClientProxy;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.packets.PacketScreenRemoveChannel;
import com.supermartijn642.tesseract.packets.PacketScreenSetChannel;
import com.supermartijn642.tesseract.screen.InfoButton;
import com.supermartijn642.tesseract.screen.PlayerRenderer;
import com.supermartijn642.tesseract.screen.RedstoneButton;
import com.supermartijn642.tesseract.screen.TesseractAddChannelScreen;
import com.supermartijn642.tesseract.screen.TesseractButton;
import com.supermartijn642.tesseract.screen.TransferButton;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TesseractScreen
extends TileEntityBaseScreen<TesseractTile> {
    private static final int MAX_DISPLAYED_CHANNELS = 12;
    private static final int CHANNEL_CUTOFF_LENGTH = 100;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tesseract", "textures/gui/new_gui.png");
    private static final int BACKGROUND_WIDTH = 249;
    private static final int BACKGROUND_HEIGHT = 211;
    private static final ResourceLocation CHANNEL_BACKGROUND = new ResourceLocation("tesseract", "textures/gui/background.png");
    private static final ResourceLocation TAB_ON = new ResourceLocation("tesseract", "textures/gui/tab_new.png");
    private static final ResourceLocation TAB_OFF = new ResourceLocation("tesseract", "textures/gui/tab_off_new.png");
    private static final ResourceLocation ITEM_ICON = new ResourceLocation("tesseract", "textures/gui/item_tab_icon.png");
    private static final ResourceLocation ENERGY_ICON = new ResourceLocation("tesseract", "textures/gui/energy_tab_icon.png");
    private static final ResourceLocation FLUID_ICON = new ResourceLocation("tesseract", "textures/gui/fluid_tab_icon.png");
    private static final ResourceLocation SCROLL_BUTTONS = new ResourceLocation("minecraft", "textures/gui/server_selection.png");
    private static final ResourceLocation LOCK_ON = new ResourceLocation("tesseract", "textures/gui/lock_on.png");
    private static final ResourceLocation LOCK_OFF = new ResourceLocation("tesseract", "textures/gui/lock_off.png");
    private static final ResourceLocation REDSTONE_TAB = new ResourceLocation("tesseract", "textures/gui/redstone_tab.png");
    private static final ResourceLocation SIDE_TAB = new ResourceLocation("tesseract", "textures/gui/side_tab_new.png");
    private static final ResourceLocation CHECKMARK = new ResourceLocation("tesseract", "textures/gui/checkmark_icon.png");
    private static EnumChannelType type = EnumChannelType.ITEMS;
    private TesseractButton setButton;
    private TesseractButton removeButton;
    private TransferButton transferButton;
    private RedstoneButton redstoneButton;
    private int selectedChannel = -1;
    private int scrollOffset = 0;

    protected float sizeX(TesseractTile tile) {
        return 249.0f;
    }

    protected float sizeY(TesseractTile tile) {
        return 211.0f;
    }

    public TesseractScreen(BlockPos pos) {
        super((Component)new TranslatableComponent("gui.tesseract.title"), pos);
    }

    protected void addWidgets(TesseractTile tile) {
        this.setButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(113, 185, 61, 18, (Component)new TranslatableComponent("gui.tesseract.set"), () -> {
            TesseractTile tile2 = (TesseractTile)((Object)((Object)this.getObjectOrClose()));
            if (tile2 != null) {
                if (tile2.getChannelId(type) == this.selectedChannel) {
                    Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenSetChannel(type, -1, this.tilePos));
                    this.setButton.setText((Component)new TranslatableComponent("gui.tesseract.set"));
                } else {
                    Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenSetChannel(type, this.selectedChannel, this.tilePos));
                    this.setButton.setText((Component)new TranslatableComponent("gui.tesseract.unset"));
                }
            }
        }));
        this.setButton.active = false;
        this.removeButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(180, 185, 61, 18, (Component)new TranslatableComponent("gui.tesseract.remove"), () -> {
            Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenRemoveChannel(type, this.selectedChannel));
            this.selectedChannel = -1;
            this.setButton.active = false;
            this.setButton.setText((Component)new TranslatableComponent("gui.tesseract.set"));
            this.removeButton.active = false;
        }));
        this.removeButton.setRedBackground();
        this.removeButton.active = false;
        this.addWidget((Widget)new TesseractButton(29, 190, 50, 10, (Component)new TranslatableComponent("gui.tesseract.add"), () -> ClientUtils.displayScreen((Screen)new TesseractAddChannelScreen(this.tilePos, type))));
        this.transferButton = (TransferButton)this.addWidget((Widget)new TransferButton(-21, 156));
        this.transferButton.update(tile, type);
        this.redstoneButton = (RedstoneButton)this.addWidget((Widget)new RedstoneButton(-25, 59));
        this.redstoneButton.update(tile);
        this.addWidget((Widget)new InfoButton(-25, 37, () -> ClientProxy.openInfoScreen(this.tilePos)));
    }

    protected void tick(TesseractTile tile) {
        this.transferButton.update(tile, type);
        this.redstoneButton.update(tile);
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, TesseractTile tile) {
        GlStateManager.m_84525_();
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.sizeX(), (float)this.sizeY());
        TranslatableComponent s = new TranslatableComponent("gui.tesseract." + type.name().toLowerCase(Locale.ROOT));
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)s, (float)177.0f, (float)14.0f, (int)-1);
        this.drawTabs(matrixStack);
        this.drawChannels(matrixStack, mouseX, mouseY, tile);
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, this.selectedChannel);
        if (channel != null) {
            this.drawSelectedChannelInfo(matrixStack, channel);
        }
    }

    protected void renderTooltips(PoseStack matrixStack, int mouseX, int mouseY, TesseractTile tile) {
        List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
        for (int i = 0; i < 12 && i + this.scrollOffset < channels.size(); ++i) {
            String creatorName;
            Channel channel = channels.get(i + this.scrollOffset);
            int x = tile.getChannelId(type) == channel.id ? 17 : 5;
            int y = 31 + i * 13;
            if (mouseX < x || mouseX >= x + 9 || mouseY < y + 2 || mouseY >= y + 11 || (creatorName = PlayerRenderer.getPlayerUsername(channel.creator)) == null) continue;
            this.m_96602_(matrixStack, (Component)new TextComponent(creatorName), mouseX, mouseY);
        }
        if (mouseX >= 9 && mouseX < 31 && mouseY >= (type == EnumChannelType.ITEMS ? 2 : 4) && mouseY < 28) {
            this.m_96602_(matrixStack, EnumChannelType.ITEMS.getTranslation(), mouseX, mouseY);
        } else if (mouseX >= 38 && mouseX < 60 && mouseY >= (type == EnumChannelType.ENERGY ? 2 : 4) && mouseY < 28) {
            this.m_96602_(matrixStack, EnumChannelType.ENERGY.getTranslation(), mouseX, mouseY);
        } else if (mouseX >= 67 && mouseX < 89 && mouseY >= (type == EnumChannelType.FLUID ? 2 : 4) && mouseY < 28) {
            this.m_96602_(matrixStack, EnumChannelType.FLUID.getTranslation(), mouseX, mouseY);
        }
    }

    private void drawTabs(PoseStack matrixStack) {
        this.drawTab(matrixStack, EnumChannelType.ITEMS, 6, ITEM_ICON);
        this.drawTab(matrixStack, EnumChannelType.ENERGY, 35, ENERGY_ICON);
        this.drawTab(matrixStack, EnumChannelType.FLUID, 64, FLUID_ICON);
        ScreenUtils.bindTexture((ResourceLocation)SIDE_TAB);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)-27.0f, (float)150.0f, (float)30.0f, (float)32.0f);
        ScreenUtils.bindTexture((ResourceLocation)REDSTONE_TAB);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)-30.0f, (float)32.0f, (float)30.0f, (float)52.0f);
    }

    private void drawTab(PoseStack matrixStack, EnumChannelType type, int x, ResourceLocation icon) {
        ScreenUtils.bindTexture((ResourceLocation)(type == TesseractScreen.type ? TAB_ON : TAB_OFF));
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)x, (float)(type == TesseractScreen.type ? 0.0f : 2.0f), (float)28.0f, (float)(type == TesseractScreen.type ? 31.0f : 26.0f));
        float width = 16.0f;
        float height = 16.0f;
        float iconX = (float)x + (28.0f - width) / 2.0f;
        float iconY = (float)(TesseractScreen.type == type ? 0 : 2) + (29.0f - height) / 2.0f;
        this.f_96542_.m_115123_(new ItemStack((ItemLike)type.item.get()), (int)(this.left() + iconX), (int)(this.top() + iconY));
    }

    private void drawChannels(PoseStack matrixStack, int mouseX, int mouseY, TesseractTile tile) {
        ScreenUtils.bindTexture((ResourceLocation)CHANNEL_BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)3.0f, (float)31.0f, (float)102.0f, (float)156.0f, (float)0.0f, (float)0.0f, (float)0.3984375f, (float)0.61328125f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)26.0f, (float)187.0f, (float)56.0f, (float)16.0f, (float)0.0f, (float)0.0f, (float)0.21875f, (float)0.0625f);
        List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
        int channelHeight = 13;
        for (int i = 0; i < 12 && i + this.scrollOffset < channels.size(); ++i) {
            int x = 3;
            int y = 31 + i * channelHeight;
            Channel channel = channels.get(i + this.scrollOffset);
            if (tile.getChannelId(type) == channel.id) {
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)y, (float)102.0f, (float)channelHeight, (int)1761636432);
            }
            if (this.selectedChannel == channel.id) {
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)y, (float)102.0f, (float)1.0f, (int)-1);
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)(y + 12), (float)102.0f, (float)1.0f, (int)-1);
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)y, (float)1.0f, (float)channelHeight, (int)-1);
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)(x + 101), (float)y, (float)1.0f, (float)channelHeight, (int)-1);
            } else if (mouseX >= x && mouseX < 105 && mouseY >= y && mouseY < y + channelHeight) {
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)y, (float)102.0f, (float)1.0f, (int)-10066330);
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)(y + 12), (float)102.0f, (float)1.0f, (int)-10066330);
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)y, (float)1.0f, (float)channelHeight, (int)-10066330);
                ScreenUtils.fillRect((PoseStack)matrixStack, (float)(x + 101), (float)y, (float)1.0f, (float)channelHeight, (int)-10066330);
            }
            x += 2;
            if (tile.getChannelId(type) == channel.id) {
                ScreenUtils.bindTexture((ResourceLocation)CHECKMARK);
                ScreenUtils.drawTexture((PoseStack)matrixStack, (float)x, (float)(y + 2), (float)9.0f, (float)9.0f);
                x += 12;
            }
            PlayerRenderer.renderPlayerHead(channel.creator, matrixStack, x, y + 2, 9, 9);
            boolean isOwnedChannel = channel.creator.equals(ClientUtils.getPlayer().m_142081_());
            int availableWidth = 100 - (x += 12) - (isOwnedChannel ? 9 : 0);
            Object name = channel.name;
            if (this.f_96547_.m_92895_((String)name) > availableWidth) {
                name = this.f_96547_.m_92865_().m_92410_((String)name, availableWidth - this.f_96547_.m_92895_("..."), Style.f_131099_) + "...";
            }
            ScreenUtils.drawString((PoseStack)matrixStack, (String)name, (float)x, (float)(y + 3), (int)-1);
            x += this.f_96547_.m_92895_((String)name) + 3;
            if (!isOwnedChannel) continue;
            ScreenUtils.bindTexture((ResourceLocation)(channel.isPrivate ? LOCK_ON : LOCK_OFF));
            ScreenUtils.drawTexture((PoseStack)matrixStack, (float)x, (float)(y + 2), (float)9.0f, (float)9.0f);
        }
    }

    private void drawSelectedChannelInfo(PoseStack matrixStack, Channel channel) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(177.0, 35.0, 0.0);
        matrixStack.m_85841_(1.2f, 1.2f, 1.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (String)channel.name, (float)0.0f, (float)0.0f, (int)0xE0E0E0);
        matrixStack.m_85849_();
        ScreenUtils.drawString((PoseStack)matrixStack, (Component)new TextComponent("Creator:").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true))), (float)117.0f, (float)55.0f, (int)-10066330);
        PlayerRenderer.renderPlayerHead(channel.creator, matrixStack, 117, 65, 9, 9);
        String creatorName = PlayerRenderer.getPlayerUsername(channel.creator);
        if (creatorName != null) {
            ScreenUtils.drawString((PoseStack)matrixStack, (String)creatorName, (float)129.0f, (float)66.0f, (int)0xE0E0E0);
        }
        ScreenUtils.drawString((PoseStack)matrixStack, (Component)new TextComponent("Category:").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true))), (float)117.0f, (float)80.0f, (int)-10066330);
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85837_((double)(this.left() + 115.0f), (double)(this.top() + 88.0f), 0.0);
        RenderSystem.m_157191_().m_85841_(0.8f, 0.8f, 1.0f);
        this.f_96542_.m_115123_(new ItemStack((ItemLike)TesseractScreen.type.item.get()), 0, 0);
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
        ScreenUtils.drawString((PoseStack)matrixStack, (Component)channel.type.getTranslation(), (float)129.0f, (float)91.0f, (int)0xE0E0E0);
        ScreenUtils.drawString((PoseStack)matrixStack, (Component)new TextComponent("Accessibility:").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true))), (float)117.0f, (float)105.0f, (int)-10066330);
        ScreenUtils.bindTexture((ResourceLocation)(channel.isPrivate ? LOCK_ON : LOCK_OFF));
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)116.0f, (float)114.0f, (float)11.0f, (float)11.0f);
        ScreenUtils.drawString((PoseStack)matrixStack, (Component)new TranslatableComponent("gui.tesseract.channel." + (channel.isPrivate ? "private" : "public")), (float)129.0f, (float)116.0f, (int)0xE0E0E0);
    }

    private void setChannelType(EnumChannelType type) {
        TesseractScreen.type = type;
        this.scrollOffset = 0;
        this.selectedChannel = -1;
        this.setButton.active = false;
        this.setButton.setText((Component)new TranslatableComponent("gui.tesseract.set"));
        this.removeButton.active = false;
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
        if (button == 0) {
            if (mouseY >= 2 && mouseY < 28) {
                if (mouseX >= 6 && mouseX < 34 && type != EnumChannelType.ITEMS) {
                    this.setChannelType(EnumChannelType.ITEMS);
                } else if (mouseX >= 35 && mouseX < 63 && type != EnumChannelType.ENERGY) {
                    this.setChannelType(EnumChannelType.ENERGY);
                } else if (mouseX >= 64 && mouseX < 92 && type != EnumChannelType.FLUID) {
                    this.setChannelType(EnumChannelType.FLUID);
                }
            } else if (mouseX >= 3 && mouseX < 105 && mouseY >= 31 && mouseY < 187) {
                int index = (mouseY - 31) / 13 + this.scrollOffset;
                List<Channel> channels = TesseractChannelManager.CLIENT.getChannels(type);
                if (index < channels.size()) {
                    TesseractTile tile = (TesseractTile)((Object)this.getObjectOrClose());
                    if (tile != null) {
                        this.selectedChannel = channels.get((int)index).id;
                        this.setButton.setText((Component)new TranslatableComponent("gui.tesseract." + (tile.getChannelId(type) == this.selectedChannel ? "unset" : "set")));
                        this.setButton.active = true;
                        this.removeButton.active = channels.get((int)index).creator.equals(Minecraft.m_91087_().f_91074_.m_142081_());
                    }
                } else {
                    this.selectedChannel = -1;
                    this.setButton.active = false;
                    this.setButton.setText((Component)new TranslatableComponent("gui.tesseract.set"));
                    this.removeButton.active = false;
                }
            }
        }
    }

    private void scroll(int amount) {
        if (TesseractChannelManager.CLIENT.getChannels(type).size() > 12) {
            this.scrollOffset = Math.max(this.scrollOffset + amount, 0);
            this.scrollOffset = Math.min(this.scrollOffset, TesseractChannelManager.CLIENT.getChannels(type).size() - 12);
        } else {
            this.scrollOffset = 0;
        }
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
        if (mouseX >= 15 && mouseX < 135 && mouseY >= 53 && mouseY < 196) {
            this.scroll(-((int)scroll));
        }
    }
}

