/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.TransferState;
import com.supermartijn642.tesseract.packets.PacketScreenCycleTransferState;
import com.supermartijn642.tesseract.screen.CycleButton;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class TransferButton
extends CycleButton
implements IHoverTextWidget {
    public TransferState state;
    private BlockPos pos;
    private EnumChannelType type;

    public TransferButton(int x, int y) {
        super(x, y, 0);
    }

    public void update(TesseractTile tile, EnumChannelType type) {
        this.state = tile.getTransferState(type);
        this.pos = tile.m_58899_();
        this.type = type;
    }

    @Override
    protected int getCycleIndex() {
        return this.state == TransferState.RECEIVE ? 0 : (this.state == TransferState.SEND ? 1 : 2);
    }

    public void onPress() {
        super.onPress();
        if (this.pos != null) {
            Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenCycleTransferState(this.pos, this.type));
        }
    }

    protected Component getNarrationMessage() {
        return this.getHoverText();
    }

    public Component getHoverText() {
        return new TranslatableComponent("gui.tesseract.transfer.speech", new Object[]{this.state.translate()});
    }
}

