/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.modifier.filters;

import com.builtbroken.ai.improvements.modifier.filters.FilterNode;
import com.builtbroken.ai.improvements.modifier.filters.FilterResult;
import com.builtbroken.ai.improvements.modifier.filters.IFilterNode;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.world.entity.Entity;

public class FilterLayer
extends FilterNode {
    private FilterNode[] nodes = new FilterNode[5];
    private int size = 0;

    public FilterLayer(IFilterNode filter) {
        super(filter);
    }

    public void add(IFilterNode modifier) {
        if (modifier != null) {
            if (this.size == this.nodes.length) {
                this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + 5);
            }
            this.nodes[this.size++] = new FilterNode(modifier);
        }
    }

    @Override
    public FilterResult handle(Entity entity) {
        FilterResult filterResult;
        FilterResult filterResult2 = filterResult = this.action != null ? this.action.handle(entity) : FilterResult.FILTERED;
        if (filterResult != FilterResult.DID_NOTHING && this.nodes != null) {
            for (int i = 0; i < this.nodes.length; ++i) {
                FilterNode modifier = this.nodes[i];
                if (modifier == null || (filterResult = modifier.handle(entity)) != FilterResult.FILTERED) continue;
                ++modifier.callCount;
                if (modifier.callCount >= 0x3FFFFFFF) {
                    Arrays.sort(this.nodes, Comparator.comparingInt(m -> m.callCount));
                    int sum = Arrays.stream(this.nodes).mapToInt(m -> m.callCount).sum();
                    Arrays.stream(this.nodes).forEach(m -> {
                        m.callCount = (int)Math.floor((double)m.callCount / (double)sum);
                    });
                } else if (i != 0 && modifier.callCount > this.nodes[i - 1].callCount) {
                    FilterNode m2 = this.nodes[i];
                    this.nodes[i] = this.nodes[i - 1];
                    this.nodes[i - 1] = m2;
                }
                return filterResult;
            }
        }
        return filterResult;
    }
}

