/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.dungeons_arise;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.aurelj.dungeons_arise.WDAConfiguredStructures;
import net.aurelj.dungeons_arise.WDAStructures;
import net.aurelj.dungeons_arise.config.ConfigHelper;
import net.aurelj.dungeons_arise.config.WDAConfig;
import net.aurelj.dungeons_arise.structures.aquatic.IllagerCorsairStructure;
import net.aurelj.dungeons_arise.structures.aquatic.IllagerGalleyStructure;
import net.aurelj.dungeons_arise.structures.aquatic.TyphonStructure;
import net.aurelj.dungeons_arise.structures.aquatic.UndeadPirateShipStructure;
import net.aurelj.dungeons_arise.structures.bandit.BanditTowersStructure;
import net.aurelj.dungeons_arise.structures.bandit.BanditVillageStructure;
import net.aurelj.dungeons_arise.structures.campsites.IllagerCampsiteStructure;
import net.aurelj.dungeons_arise.structures.campsites.MerchantCampsiteStructure;
import net.aurelj.dungeons_arise.structures.desertic.CeryneianHindStructure;
import net.aurelj.dungeons_arise.structures.desertic.ShirazPalaceStructure;
import net.aurelj.dungeons_arise.structures.eerie.AviaryStructure;
import net.aurelj.dungeons_arise.structures.eerie.HeavenlyChallengerStructure;
import net.aurelj.dungeons_arise.structures.eerie.HeavenlyConquerorStructure;
import net.aurelj.dungeons_arise.structures.eerie.HeavenlyRiderStructure;
import net.aurelj.dungeons_arise.structures.enigmatic.LighthouseStructure;
import net.aurelj.dungeons_arise.structures.enigmatic.SmallBlimpStructure;
import net.aurelj.dungeons_arise.structures.fortified.AbandonedTempleStructure;
import net.aurelj.dungeons_arise.structures.fortified.IllagerFortStructure;
import net.aurelj.dungeons_arise.structures.fortified.MonasteryStructure;
import net.aurelj.dungeons_arise.structures.fortified.ThornbornTowersStructure;
import net.aurelj.dungeons_arise.structures.fungi.GiantMushroomStructure;
import net.aurelj.dungeons_arise.structures.fungi.MushroomHouseStructure;
import net.aurelj.dungeons_arise.structures.fungi.MushroomMinesStructure;
import net.aurelj.dungeons_arise.structures.fungi.MushroomVillageStructure;
import net.aurelj.dungeons_arise.structures.haunted.InfestedTempleStructure;
import net.aurelj.dungeons_arise.structures.haunted.PlagueAsylumStructure;
import net.aurelj.dungeons_arise.structures.jungle.JungleTreeHouseStructure;
import net.aurelj.dungeons_arise.structures.prairie.ColiseumStructure;
import net.aurelj.dungeons_arise.structures.prairie.FishingHutStructure;
import net.aurelj.dungeons_arise.structures.prairie.IllagerWindmillStructure;
import net.aurelj.dungeons_arise.structures.prairie.SmallPrairieHouseStructure;
import net.aurelj.dungeons_arise.structures.prairie.WishingWellStructure;
import net.aurelj.dungeons_arise.structures.underworld.FoundryStructure;
import net.aurelj.dungeons_arise.structures.underworld.MiningSystemStructure;
import net.aurelj.dungeons_arise.structures.underworld.ScorchedMinesStructure;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dungeons_arise")
public class DungeonsAriseMain {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "dungeons_arise";
    public static WDAConfig.WDAConfigValues WDAConfig = null;
    private static Method GETCODEC_METHOD;

    public DungeonsAriseMain() {
        WDAConfig = ConfigHelper.register(ModConfig.Type.COMMON, WDAConfig.WDAConfigValues::new, "when-dungeons-arise-common.toml");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        WDAStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.NORMAL, IllagerCorsairStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, IllagerGalleyStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, TyphonStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, UndeadPirateShipStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, BanditTowersStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, BanditVillageStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, IllagerCampsiteStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, MerchantCampsiteStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, CeryneianHindStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, ShirazPalaceStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, AviaryStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, HeavenlyChallengerStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, HeavenlyConquerorStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, HeavenlyRiderStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, LighthouseStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, SmallBlimpStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, AbandonedTempleStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, IllagerFortStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, MonasteryStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, ThornbornTowersStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, GiantMushroomStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, MushroomHouseStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, MushroomMinesStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, MushroomVillageStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, InfestedTempleStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, PlagueAsylumStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, JungleTreeHouseStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, ColiseumStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, FishingHutStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, IllagerWindmillStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, SmallPrairieHouseStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, WishingWellStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, FoundryStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, ScorchedMinesStructure::setupStructureSpawns);
        forgeBus.addListener(EventPriority.NORMAL, MiningSystemStructure::setupStructureSpawns);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            WDAStructures.setupStructures();
            WDAConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            Biome.BiomeCategory biomeCategory;
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap WDAStructureToMultiMap = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.illagerCorsairGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.OCEAN) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_ILLAGER_CORSAIR, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.illagerGalleyGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.OCEAN) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_ILLAGER_GALLEY, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.typhonGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.OCEAN) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_TYPHON, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.undeadPirateShipGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.OCEAN) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_UNDEAD_PIRATE_SHIP, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.banditTowersGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.MESA) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_BANDIT_TOWERS, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.banditVillageGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.MESA) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_BANDIT_VILLAGE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.illagerCampsiteGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.MOUNTAIN && biomeCategory != Biome.BiomeCategory.PLAINS) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_ILLAGER_CAMPSITE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.merchantCampsiteGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.MOUNTAIN && biomeCategory != Biome.BiomeCategory.PLAINS) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_MERCHANT_CAMPSITE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.ceryneianHindGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.DESERT) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_CERYNEIAN_HIND, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.shirazPalaceGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.DESERT) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_SHIRAZ_PALACE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.aviaryGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.THEEND) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_AVIARY, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory != Biome.BiomeCategory.THEEND && (biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.heavenlyChallengerGenerates.get().booleanValue())) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_HEAVENLY_CHALLENGER, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory != Biome.BiomeCategory.THEEND && (biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.heavenlyConquerorGenerates.get().booleanValue())) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_HEAVENLY_CONQUEROR, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory != Biome.BiomeCategory.THEEND && (biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.heavenlyRiderGenerates.get().booleanValue())) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_HEAVENLY_RIDER, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.smallBlimpGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.PLAINS && biomeCategory != Biome.BiomeCategory.TAIGA) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_SMALL_BLIMP, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.lighthouseGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.BEACH) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_LIGHTHOUSE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.abandonedTempleGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.MOUNTAIN && biomeCategory != Biome.BiomeCategory.TAIGA) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_ABANDONED_TEMPLE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.illagerFortGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.ICY && biomeCategory != Biome.BiomeCategory.TAIGA) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_ILLAGER_FORT, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.monasteryGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.MOUNTAIN && biomeCategory != Biome.BiomeCategory.TAIGA) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_MONASTERY, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.thornbornTowersGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.FOREST) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_THORNBORN_TOWERS, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.giantMushroomGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.FOREST && biomeCategory != Biome.BiomeCategory.MUSHROOM) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_GIANT_MUSHROOM, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.mushroomHouseGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.PLAINS && biomeCategory != Biome.BiomeCategory.FOREST) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_MUSHROOM_HOUSE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.mushroomMinesGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.SWAMP && biomeCategory != Biome.BiomeCategory.FOREST) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_MUSHROOM_MINES, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.mushroomVillageGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.SWAMP && biomeCategory != Biome.BiomeCategory.FOREST) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_MUSHROOM_VILLAGE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.infestedTempleGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.TAIGA) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_INFESTED_TEMPLE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.plagueAsylumGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.JUNGLE && biomeCategory != Biome.BiomeCategory.FOREST) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_PLAGUE_ASYLUM, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.jungleTreeHouseGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.JUNGLE) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_JUNGLE_TREE_HOUSE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.coliseumGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.PLAINS) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_COLISEUM, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.fishingHutGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.BEACH) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_FISHING_HUT, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.illagerWindmillGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.PLAINS) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_ILLAGER_WINDMILL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.smallPrairieHouseGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.PLAINS) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_SMALL_PRAIRIE_HOUSE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.wishingWellGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.PLAINS) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_WISHING_WELL, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.foundryGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.MOUNTAIN && biomeCategory != Biome.BiomeCategory.DESERT) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_FOUNDRY, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.miningSystemGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.FOREST && biomeCategory != Biome.BiomeCategory.PLAINS) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_MINING_SYSTEM, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory == Biome.BiomeCategory.THEEND || biomeCategory == Biome.BiomeCategory.NETHER || biomeCategory == Biome.BiomeCategory.NONE || !DungeonsAriseMain.WDAConfig.scorchedMinesGenerates.get().booleanValue() || biomeCategory != Biome.BiomeCategory.DESERT && biomeCategory != Biome.BiomeCategory.FOREST) continue;
                DungeonsAriseMain.associateBiomeToConfiguredStructure(WDAStructureToMultiMap, WDAConfiguredStructures.CONFIGURED_SCORCHED_MINES, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !WDAStructureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            WDAStructureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)WDAStructures.MONASTERY.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.MONASTERY.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.ILLAGER_CAMPSITE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.ILLAGER_CAMPSITE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.ABANDONED_TEMPLE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.ABANDONED_TEMPLE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.LIGHTHOUSE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.LIGHTHOUSE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.MUSHROOM_VILLAGE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.MUSHROOM_VILLAGE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.SMALL_PRAIRIE_HOUSE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.SMALL_PRAIRIE_HOUSE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.FISHING_HUT.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.FISHING_HUT.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.MUSHROOM_MINES.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.MUSHROOM_MINES.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.COLISEUM.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.COLISEUM.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.MERCHANT_CAMPSITE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.MERCHANT_CAMPSITE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.WISHING_WELL.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.WISHING_WELL.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.ILLAGER_FORT.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.ILLAGER_FORT.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.INFESTED_TEMPLE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.INFESTED_TEMPLE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.HEAVENLY_RIDER.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.HEAVENLY_RIDER.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.MINING_SYSTEM.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.MINING_SYSTEM.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.HEAVENLY_CONQUEROR.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.HEAVENLY_CONQUEROR.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.SCORCHED_MINES.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.SCORCHED_MINES.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.UNDEAD_PIRATE_SHIP.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.UNDEAD_PIRATE_SHIP.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.FOUNDRY.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.FOUNDRY.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.SMALL_BLIMP.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.SMALL_BLIMP.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.BANDIT_VILLAGE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.BANDIT_VILLAGE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.TYPHON.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.TYPHON.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.CERYNEIAN_HIND.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.CERYNEIAN_HIND.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.HEAVENLY_CHALLENGER.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.HEAVENLY_CHALLENGER.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.ILLAGER_CORSAIR.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.ILLAGER_CORSAIR.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.ILLAGER_GALLEY.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.ILLAGER_GALLEY.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.MUSHROOM_HOUSE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.MUSHROOM_HOUSE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.GIANT_MUSHROOM.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.GIANT_MUSHROOM.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.SHIRAZ_PALACE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.SHIRAZ_PALACE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.PLAGUE_ASYLUM.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.PLAGUE_ASYLUM.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.BANDIT_TOWERS.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.BANDIT_TOWERS.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.THORNBORN_TOWERS.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.THORNBORN_TOWERS.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.JUNGLE_TREE_HOUSE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.JUNGLE_TREE_HOUSE.get()));
            tempMap.putIfAbsent((StructureFeature)WDAStructures.AVIARY.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)WDAStructures.AVIARY.get()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }
}

