/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.dungeons_arise.structures.haunted;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.aurelj.dungeons_arise.DungeonsAriseMain;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public class PlagueAsylumStructure
extends StructureFeature<JigsawConfiguration> {
    public PlagueAsylumStructure(Codec<JigsawConfiguration> codec) {
        super(codec, context -> {
            if (!PlagueAsylumStructure.isFeatureChunk((PieceGeneratorSupplier.Context<JigsawConfiguration>)context)) {
                return Optional.empty();
            }
            return PlagueAsylumStructure.createPiecesGenerator((PieceGeneratorSupplier.Context<JigsawConfiguration>)context);
        }, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockPos = context.f_197355_().m_45615_();
        int landHeight = context.f_197352_().m_156179_(blockPos.m_123341_(), blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(blockPos.m_123341_(), blockPos.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
        return !(!topBlock.m_60819_().m_76178_() || context.f_197355_().f_45578_ <= DungeonsAriseMain.WDAConfig.plagueAsylumSpawnpointSeparation.get() && context.f_197355_().f_45578_ >= -DungeonsAriseMain.WDAConfig.plagueAsylumSpawnpointSeparation.get().intValue() || context.f_197355_().f_45579_ <= DungeonsAriseMain.WDAConfig.plagueAsylumSpawnpointSeparation.get() && context.f_197355_().f_45579_ >= -DungeonsAriseMain.WDAConfig.plagueAsylumSpawnpointSeparation.get().intValue());
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        int heightmapY = context.f_197352_().m_156179_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        JigsawConfiguration newConfig = new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175512_(Registry.f_122884_).m_7745_(new ResourceLocation("dungeons_arise", "haunted/plague_asylum/plague_asylum_start")), DungeonsAriseMain.WDAConfig.plagueAsylumSize.get().intValue());
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        Optional structurePiecesGenerator = JigsawPlacement.m_197210_((PieceGeneratorSupplier.Context)newContext, PoolElementStructurePiece::new, (BlockPos)new BlockPos(blockpos.m_123341_(), 45, blockpos.m_123343_()), (boolean)false, (boolean)false);
        return structurePiecesGenerator;
    }
}

