/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.AbstractMRContainerScreen;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.widgets.WidgetEnergy;
import me.desht.modularrouters.client.gui.widgets.button.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.container.ContainerModularRouter;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.RouterSettingsMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;

public class ModularRouterScreen
extends AbstractMRContainerScreen<ContainerModularRouter>
implements ISendToServer,
MenuAccess<ContainerModularRouter> {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/router.png");
    private static final int LABEL_YPOS = 5;
    private static final int MODULE_LABEL_YPOS = 60;
    private static final int BUFFER_LABEL_YPOS = 28;
    private static final int UPGRADES_LABEL_YPOS = 28;
    private static final int GUI_HEIGHT = 186;
    private static final int GUI_WIDTH = 176;
    private static final int BUTTON_HEIGHT = 16;
    private static final int BUTTON_WIDTH = 16;
    private static final int MODULE_START = 37;
    private static final int MODULE_END = 45;
    private RedstoneBehaviourButton redstoneBehaviourButton;
    private EcoButton ecoButton;
    private EnergyDirectionButton energyDirButton;
    private WidgetEnergy energyWidget;
    private EnergyWarningButton energyWarning;
    private int energyUsage;

    public ModularRouterScreen(ContainerModularRouter container, Inventory inventoryPlayer, Component displayName) {
        super(container, inventoryPlayer, displayName);
        this.f_97726_ = 176;
        this.f_97727_ = 186;
        this.f_96546_ = true;
    }

    public void m_7856_() {
        super.m_7856_();
        ModularRouterBlockEntity router = ((ContainerModularRouter)this.f_97732_).getRouter();
        this.redstoneBehaviourButton = new RedstoneBehaviourButton(this.f_97735_ + 152, this.f_97736_ + 10, 16, 16, router.getRedstoneBehaviour(), (ISendToServer)this);
        this.m_142416_((GuiEventListener)this.redstoneBehaviourButton);
        this.ecoButton = new EcoButton(this.f_97735_ + 132, this.f_97736_ + 10, 16, 16, router.getEcoMode());
        this.m_142416_((GuiEventListener)this.ecoButton);
        this.energyDirButton = new EnergyDirectionButton(this.f_97735_ - 8, this.f_97736_ + 40, router.getEnergyDirection());
        this.m_142416_((GuiEventListener)this.energyDirButton);
        this.energyWidget = new WidgetEnergy(this.f_97735_ - 22, this.f_97736_ + 15, router.getEnergyStorage());
        this.m_142416_((GuiEventListener)this.energyWidget);
        this.energyWarning = new EnergyWarningButton(this.f_97735_ + 4, this.f_97736_ + 4);
        this.m_142416_((GuiEventListener)this.energyWarning);
        this.energyDirButton.f_93624_ = router.getEnergyCapacity() > 0;
        this.energyWidget.f_93624_ = this.energyDirButton.f_93624_;
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        MutableComponent title = ClientUtil.xlate("block.modularrouters.modular_router", new Object[0]);
        this.f_96547_.m_92889_(matrixStack, (Component)title, (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)title) / 2.0f, 5.0f, -12566464);
        this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.label.buffer", new Object[0]), 8.0f, 28.0f, -12566464);
        this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.label.upgrades", new Object[0]), 80.0f, 28.0f, -12566464);
        this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("modularrouters.guiText.label.modules", new Object[0]), 8.0f, 60.0f, -12566464);
        this.f_96547_.m_92889_(matrixStack, (Component)ClientUtil.xlate("container.inventory", new Object[0]), 8.0f, (float)(this.f_97727_ - 96 + 4), -12566464);
    }

    protected void m_7286_(PoseStack matrixStack, float v, int i, int i1) {
        GuiUtil.bindTexture(TEXTURE_LOCATION);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((ContainerModularRouter)this.f_97732_).getRouter().getEnergyCapacity() > 0) {
            this.m_93228_(matrixStack, this.f_97735_ - 27, this.f_97736_, 180, 0, 32, 100);
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return ClientSetup.keybindConfigure.getKey().m_84873_() == keyCode ? this.handleModuleConfig() : super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_6375_(double x, double y, int btn) {
        return btn == 2 ? this.handleModuleConfig() : super.m_6375_(x, y, btn);
    }

    @Override
    public void m_181908_() {
        boolean hasEnergyUpgrade;
        super.m_181908_();
        this.energyUsage = 0;
        for (int i = 37; i < 45; ++i) {
            ItemStack stack = ((ContainerModularRouter)this.f_97732_).m_38853_(i).m_7993_();
            Item item = stack.m_41720_();
            if (!(item instanceof ModuleItem)) continue;
            ModuleItem moduleItem = (ModuleItem)item;
            this.energyUsage += moduleItem.getEnergyCost(stack);
        }
        this.energyWidget.f_93624_ = hasEnergyUpgrade = ((ContainerModularRouter)this.f_97732_).getRouter().getEnergyCapacity() > 0;
        this.energyDirButton.f_93624_ = hasEnergyUpgrade && ((ContainerModularRouter)this.m_6262_()).m_38853_(36).m_7993_().getCapability(CapabilityEnergy.ENERGY).isPresent();
        this.energyWarning.f_93620_ = hasEnergyUpgrade ? this.f_97735_ - 22 : this.f_97735_ + 4;
    }

    private boolean handleModuleConfig() {
        Slot slot = this.getSlotUnderMouse();
        if (slot == null || !(slot.m_7993_().m_41720_() instanceof ModuleItem) || slot.f_40219_ < 37 || slot.f_40219_ > 45) {
            return false;
        }
        MFLocator locator = MFLocator.moduleInRouter(((ContainerModularRouter)this.f_97732_).getRouter().m_58899_(), slot.f_40219_ - 37);
        PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openModuleInRouter(locator));
        return true;
    }

    @Override
    public void sendToServer() {
        ModularRouterBlockEntity router = ((ContainerModularRouter)this.f_97732_).getRouter();
        router.setRedstoneBehaviour((RouterRedstoneBehaviour)this.redstoneBehaviourButton.getState());
        router.setEcoMode(this.ecoButton.isToggled());
        router.setEnergyDirection((ModularRouterBlockEntity.EnergyDirection)this.energyDirButton.getState());
        PacketHandler.NETWORK.sendToServer((Object)new RouterSettingsMessage(router));
    }

    public List<Rect2i> getExtraArea() {
        return ((ContainerModularRouter)this.f_97732_).getRouter().getEnergyCapacity() > 0 ? Collections.singletonList(new Rect2i(this.f_97735_ - 27, this.f_97736_, 32, 100)) : Collections.emptyList();
    }

    private class EcoButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(80, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(96, 16);

        EcoButton(int x, int y, int width, int height, boolean initialVal) {
            super(x, y, width, height, initialVal, ModularRouterScreen.this);
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }

        @Override
        public List<Component> getTooltip() {
            return GuiUtil.xlateAndSplit("modularrouters.guiText.tooltip.eco." + this.isToggled(), Float.valueOf((float)MRConfig.Common.Router.ecoTimeout / 20.0f), Float.valueOf((float)MRConfig.Common.Router.lowPowerTickRate / 20.0f));
        }
    }

    private class EnergyDirectionButton
    extends TexturedCyclerButton<ModularRouterBlockEntity.EnergyDirection> {
        public EnergyDirectionButton(int x, int y, ModularRouterBlockEntity.EnergyDirection initialVal) {
            super(x, y, 14, 14, initialVal, ModularRouterScreen.this);
        }

        @Override
        protected XYPoint getTextureXY() {
            int x = switch ((ModularRouterBlockEntity.EnergyDirection)this.getState()) {
                default -> throw new IncompatibleClassChangeError();
                case ModularRouterBlockEntity.EnergyDirection.TO_ROUTER -> 224;
                case ModularRouterBlockEntity.EnergyDirection.FROM_ROUTER -> 144;
                case ModularRouterBlockEntity.EnergyDirection.NONE -> 176;
            };
            return new XYPoint(x, 0);
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        public List<Component> getTooltip() {
            return ImmutableList.of((Object)ClientUtil.xlate(((ModularRouterBlockEntity.EnergyDirection)this.getState()).getTranslationKey(), new Object[0]), (Object)ClientUtil.xlate("modularrouters.guiText.tooltip.energy.rate", MiscUtil.commify(((ContainerModularRouter)ModularRouterScreen.this.f_97732_).getRouter().getEnergyXferRate())).m_130940_(ChatFormatting.GRAY));
        }
    }

    private class EnergyWarningButton
    extends TexturedButton {
        public EnergyWarningButton(int x, int y) {
            super(x, y, 16, 16, b -> {});
        }

        @Override
        public List<Component> getTooltip() {
            if (ModularRouterScreen.this.energyUsage <= ((ContainerModularRouter)ModularRouterScreen.this.f_97732_).getRouter().getEnergyStorage().getEnergyStored()) {
                return Collections.emptyList();
            }
            return ((ContainerModularRouter)ModularRouterScreen.this.f_97732_).getRouter().getEnergyCapacity() > 0 ? GuiUtil.xlateAndSplit("modularrouters.itemText.misc.energyWarning", new Object[0]) : GuiUtil.xlateAndSplit("modularrouters.itemText.misc.energyWarning.noBuffer", new Object[0]);
        }

        public void m_7435_(SoundManager p_230988_1_) {
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        protected XYPoint getTextureXY() {
            boolean lowEnergy = ((ContainerModularRouter)ModularRouterScreen.this.f_97732_).getRouter().getEnergyStorage().getEnergyStored() < ModularRouterScreen.this.energyUsage;
            return new XYPoint(240, lowEnergy && ClientUtil.theClientWorld().m_46467_() % 40L < 35L ? 0 : 240);
        }
    }
}

