/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.upgrade;

import com.mojang.blaze3d.vertex.PoseStack;
import me.desht.modularrouters.client.gui.AbstractMRScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackButton;
import me.desht.modularrouters.client.gui.widgets.textfield.IntegerTextField;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.item.upgrade.SyncUpgrade;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.SyncUpgradeSettingsMessage;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.Range;

public class SyncUpgradeScreen
extends AbstractMRScreen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("modularrouters", "textures/gui/sync_upgrade.png");
    private static final ItemStack clockStack = new ItemStack((ItemLike)Items.f_42524_);
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 48;
    private final String title;
    private int xPos;
    private int yPos;
    private int tunedValue;
    private final InteractionHand hand;

    public SyncUpgradeScreen(ItemStack upgradeStack, InteractionHand hand) {
        super(upgradeStack.m_41786_());
        this.title = upgradeStack.m_41786_().getString();
        this.tunedValue = SyncUpgrade.getTunedValue(upgradeStack);
        this.hand = hand;
    }

    public static void openSyncGui(ItemStack stack, InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)new SyncUpgradeScreen(stack, hand));
    }

    public void m_7856_() {
        this.xPos = (this.f_96543_ - 176) / 2;
        this.yPos = (this.f_96544_ - 48) / 2;
        TextFieldManager manager = this.getOrCreateTextFieldManager().clear();
        IntegerTextField intField = new IntegerTextField(manager, this.f_96547_, this.xPos + 77, this.yPos + 27, 25, 16, (Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(MRConfig.Common.Router.baseTickRate - 1)));
        intField.m_94151_(str -> {
            this.tunedValue = str.isEmpty() ? 0 : Integer.parseInt(str);
            this.sendSettingsDelayed(5);
        });
        intField.setValue(this.tunedValue);
        intField.useGuiTextBackground();
        intField.m_94178_(true);
        this.m_7522_((GuiEventListener)intField);
        this.m_142416_((GuiEventListener)new TooltipButton(this.xPos + 55, this.yPos + 24, 16, 16));
        super.m_7856_();
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        GuiUtil.bindTexture(TEXTURE_LOCATION);
        this.m_93228_(matrixStack, this.xPos, this.yPos, 0, 0, 176, 48);
        this.f_96547_.m_92883_(matrixStack, this.title, (float)this.xPos + 88.0f - (float)this.f_96547_.m_92895_(this.title) / 2.0f, (float)(this.yPos + 6), 0x404040);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    protected void sendSettingsToServer() {
        PacketHandler.NETWORK.sendToServer((Object)new SyncUpgradeSettingsMessage(this.tunedValue, this.hand));
    }

    private static class TooltipButton
    extends ItemStackButton {
        TooltipButton(int x, int y, int width, int height) {
            super(x, y, width, height, clockStack, true, p -> {});
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.tunedValue", 0, MRConfig.Common.Router.baseTickRate - 1);
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.numberFieldTooltip", new Object[0]);
        }

        public void m_7435_(SoundManager soundHandlerIn) {
        }
    }
}

