/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.IHasTranslationKey;
import me.desht.modularrouters.item.module.PlayerModule;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CompiledPlayerModule
extends CompiledModule {
    public static final String NBT_OPERATION = "Operation";
    public static final String NBT_SECTION = "Section";
    private final Operation operation;
    private final Section section;
    private final UUID playerId;
    private final String playerName;
    private WeakReference<Player> playerRef;

    public CompiledPlayerModule(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        CompoundTag compound = stack.m_41737_("modularrouters");
        if (compound != null) {
            this.playerName = ((PlayerModule)stack.m_41720_()).getOwnerName(stack);
            this.playerId = ((PlayerModule)stack.m_41720_()).getOwnerID(stack);
            this.operation = Operation.values()[compound.m_128451_(NBT_OPERATION)];
            this.section = Section.values()[compound.m_128451_(NBT_SECTION)];
            if (router != null && !router.m_58904_().f_46443_) {
                ServerPlayer player = this.playerId == null ? null : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.playerId);
                this.playerRef = new WeakReference<ServerPlayer>(player);
            } else {
                this.playerRef = new WeakReference<Object>(null);
            }
        } else {
            this.operation = Operation.EXTRACT;
            this.section = Section.MAIN;
            this.playerId = null;
            this.playerName = null;
        }
    }

    @Override
    public boolean hasTarget() {
        return this.getPlayer() != null;
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        Player player = this.getPlayer();
        IItemHandler itemHandler = this.getHandler(player);
        if (itemHandler == null) {
            return false;
        }
        ItemStack bufferStack = router.getBufferItemStack();
        switch (this.operation) {
            case EXTRACT: {
                if (bufferStack.m_41613_() >= bufferStack.m_41741_()) break;
                ItemStack taken = this.transferToRouter(itemHandler, null, router);
                return !taken.m_41619_();
            }
            case INSERT: {
                int sent;
                if (!this.getFilter().test(bufferStack)) break;
                if (this.getSection() == Section.ARMOR) {
                    return this.insertArmor(router, itemHandler, bufferStack);
                }
                int nToSend = this.getItemsPerTick(router);
                if (this.getRegulationAmount() > 0) {
                    int existing = InventoryUtils.countItems(bufferStack, itemHandler, this.getRegulationAmount(), !this.getFilter().getFlags().isIgnoreDamage());
                    if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                        return false;
                    }
                }
                return (sent = InventoryUtils.transferItems(router.getBuffer(), itemHandler, 0, nToSend)) > 0;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private Player getPlayer() {
        return (Player)this.playerRef.get();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().m_142081_().equals(this.playerId)) {
            this.playerRef = new WeakReference<Player>(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer().m_142081_().equals(this.playerId)) {
            this.playerRef = new WeakReference<Object>(null);
        }
    }

    @Override
    public void onCompiled(ModularRouterBlockEntity router) {
        super.onCompiled(router);
        if (!router.m_58904_().f_46443_) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void cleanup(ModularRouterBlockEntity router) {
        super.cleanup(router);
        if (!router.m_58904_().f_46443_) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Section getSection() {
        return this.section;
    }

    private boolean insertArmor(ModularRouterBlockEntity router, IItemHandler itemHandler, ItemStack armorStack) {
        int slot = this.getSlotForArmorItem(armorStack);
        if (slot >= 0 && itemHandler.getStackInSlot(slot).m_41619_()) {
            ItemStack extracted = router.getBuffer().extractItem(0, 1, false);
            if (extracted.m_41619_()) {
                return false;
            }
            ItemStack res = itemHandler.insertItem(slot, extracted, false);
            return res.m_41619_();
        }
        return false;
    }

    private int getSlotForArmorItem(ItemStack stack) {
        return switch (Mob.m_147233_((ItemStack)stack)) {
            case EquipmentSlot.HEAD -> 3;
            case EquipmentSlot.CHEST -> 2;
            case EquipmentSlot.LEGS -> 1;
            case EquipmentSlot.FEET -> 0;
            default -> -1;
        };
    }

    private IItemHandler getHandler(Player player) {
        return switch (this.section) {
            default -> throw new IncompatibleClassChangeError();
            case Section.MAIN -> new PlayerMainInvWrapper(player.m_150109_());
            case Section.MAIN_NO_HOTBAR -> new PlayerMainInvNoHotbarWrapper(player.m_150109_());
            case Section.ARMOR -> new PlayerArmorInvWrapper(player.m_150109_());
            case Section.OFFHAND -> new PlayerOffhandInvWrapper(player.m_150109_());
            case Section.ENDER -> new InvWrapper((Container)player.m_36327_());
        };
    }

    public static enum Operation implements IHasTranslationKey
    {
        EXTRACT,
        INSERT;


        public String getSymbol() {
            return this == INSERT ? "\u27f9" : "\u27f8";
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.playerOp." + this;
        }
    }

    public static enum Section implements IHasTranslationKey
    {
        MAIN,
        MAIN_NO_HOTBAR,
        ARMOR,
        OFFHAND,
        ENDER;


        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.playerSect." + this;
        }
    }

    public static class PlayerMainInvNoHotbarWrapper
    extends RangedWrapper {
        PlayerMainInvNoHotbarWrapper(Inventory inv) {
            super((IItemHandlerModifiable)new InvWrapper((Container)inv), Inventory.m_36059_(), inv.f_35974_.size());
        }
    }
}

