/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import team.chisel.ctm.CTM;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.model.ModelCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;

public enum TextureMetadataHandler {
    INSTANCE;

    private final Set<ResourceLocation> registeredTextures = new HashSet<ResourceLocation>();
    private final Object2BooleanMap<ResourceLocation> wrappedModels = new Object2BooleanLinkedOpenHashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        HashSet sprites = new HashSet((Collection)ObfuscationReflectionHelper.getPrivateValue(TextureStitchEvent.Pre.class, (Object)event, (String)"sprites"));
        for (ResourceLocation rel : sprites) {
            try {
                IMetadataSectionCTM metadata = ResourceUtil.getMetadata(rel = new ResourceLocation(rel.m_135827_(), "textures/" + rel.m_135815_() + ".png"));
                if (metadata == null) continue;
                if (metadata.getProxy() != null) {
                    ResourceLocation proxysprite = new ResourceLocation(metadata.getProxy());
                    IMetadataSectionCTM proxymeta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(proxysprite));
                    event.addSprite(proxysprite);
                    if (proxymeta != null) {
                        for (ResourceLocation r : proxymeta.getAdditionalTextures()) {
                            if (!this.registeredTextures.add(r)) continue;
                            event.addSprite(r);
                        }
                    }
                }
                for (ResourceLocation r : metadata.getAdditionalTextures()) {
                    if (!this.registeredTextures.add(r)) continue;
                    event.addSprite(r);
                }
            }
            catch (FileNotFoundException metadata) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelBakeEvent event) {
        Map stateModels = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)event.getModelLoader(), (String)"f_119212_");
        for (ResourceLocation rl : event.getModelRegistry().keySet()) {
            BakedModel baked;
            UnbakedModel rootModel = (UnbakedModel)stateModels.get(rl);
            if (rootModel == null || (baked = (BakedModel)event.getModelRegistry().get(rl)) instanceof AbstractCTMBakedModel || baked.m_7521_()) continue;
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            dependencies.push(rl);
            seenModels.add(rl);
            boolean shouldWrap = this.wrappedModels.getOrDefault((Object)rl, false);
            while (!shouldWrap && !dependencies.isEmpty()) {
                UnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == rl ? rootModel : event.getModelLoader().m_119341_(dep);
                }
                catch (Exception e) {
                    continue;
                }
                HashSet textures = Sets.newHashSet((Iterable)model.m_5500_(arg_0 -> ((ForgeModelBakery)event.getModelLoader()).m_119341_(arg_0), (Set)Sets.newHashSet()));
                HashSet newDependencies = Sets.newHashSet((Iterable)model.m_7970_());
                for (Material tex : textures) {
                    IMetadataSectionCTM meta = null;
                    try {
                        meta = ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(tex.m_119203_()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (meta == null) continue;
                    shouldWrap = true;
                }
                for (ResourceLocation newDep : newDependencies) {
                    if (!seenModels.add(newDep)) continue;
                    dependencies.push(newDep);
                }
            }
            this.wrappedModels.put((Object)rl, shouldWrap);
            if (!shouldWrap) continue;
            try {
                event.getModelRegistry().put(rl, this.wrap(rl, rootModel, baked, event.getModelLoader()));
                dependencies.clear();
            }
            catch (IOException e) {
                CTM.logger.error("Could not wrap model " + rl + ". Aborting...", (Throwable)e);
            }
        }
    }

    @Nonnull
    private BakedModel wrap(ResourceLocation loc, UnbakedModel model, BakedModel object, ForgeModelBakery loader) throws IOException {
        ModelCTM modelchisel = new ModelCTM(model);
        modelchisel.initializeTextures((ModelBakery)loader, m -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(m.m_119193_()).apply(m.m_119203_()));
        return new ModelBakedCTM(modelchisel, object);
    }

    public void invalidateCaches() {
        this.registeredTextures.clear();
        this.wrappedModels.clear();
    }
}

