/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.RFCraftingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketGridSync {
    protected BlockPos pos;
    protected ResourceKey<Level> type;
    private List<ItemStack[]> recipes;

    public void convertFromBytes(FriendlyByteBuf buf) {
        this.pos = buf.readBoolean() ? buf.m_130135_() : null;
        this.type = LevelTools.getId((ResourceLocation)buf.m_130281_());
        int s = buf.readInt();
        this.recipes = new ArrayList<ItemStack[]>(s);
        for (int i = 0; i < s; ++i) {
            int ss = buf.readInt();
            ItemStack[] stacks = new ItemStack[ss];
            for (int j = 0; j < ss; ++j) {
                stacks[j] = buf.m_130267_();
            }
            this.recipes.add(stacks);
        }
    }

    public void convertToBytes(FriendlyByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130085_(this.type.m_135782_());
        buf.writeInt(this.recipes.size());
        for (ItemStack[] recipe : this.recipes) {
            buf.writeInt(recipe.length);
            for (ItemStack stack : recipe) {
                buf.m_130055_(stack);
            }
        }
    }

    protected void init(BlockPos pos, ResourceKey<Level> type, CraftingGrid grid) {
        this.pos = pos;
        this.type = type;
        this.recipes = new ArrayList<ItemStack[]>();
        for (int i = 0; i < 6; ++i) {
            RFCraftingRecipe recipe = grid.getRecipe(i);
            CraftingContainer inventory = recipe.getInventory();
            ItemStack[] stacks = new ItemStack[10];
            stacks[0] = recipe.getResult();
            for (int j = 0; j < 9; ++j) {
                stacks[j + 1] = inventory.m_8020_(j);
            }
            this.recipes.add(stacks);
        }
    }

    protected CraftingGridProvider handleMessage(Level world, Player player) {
        BlockEntity te;
        CraftingGridProvider provider = null;
        if (this.pos == null) {
            GenericContainer container = PacketGridSync.getOpenContainer();
            if (container == null) {
                Logging.log((String)"Container is missing!");
                return null;
            }
            te = container.getTe();
        } else {
            te = world.m_7702_(this.pos);
        }
        if (te instanceof CraftingGridProvider) {
            provider = (CraftingGridProvider)te;
        }
        if (provider != null) {
            for (int i = 0; i < this.recipes.size(); ++i) {
                provider.setRecipe(i, this.recipes.get(i));
            }
        }
        return provider;
    }

    private static GenericContainer getOpenContainer() {
        AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
        if (container instanceof GenericContainer) {
            return (GenericContainer)container;
        }
        return null;
    }
}

