/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import shadows.click.block.AutoClickerTile;
import shadows.click.block.gui.AutoClickContainer;
import shadows.placebo.block_entity.TickingEntityBlock;
import shadows.placebo.container.ContainerUtil;

public class AutoClickerBlock
extends Block
implements TickingEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public AutoClickerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(5.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new AutoClickerTile(pPos, pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ACTIVE});
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity te = world.m_7702_(pos);
        if (!world.f_46443_ && te instanceof AutoClickerTile && placer instanceof Player) {
            ((AutoClickerTile)te).setPlayer((Player)placer);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Player placer = context.m_43723_();
        Direction face = placer.m_6350_().m_122424_();
        if (placer.m_146909_() > 50.0f) {
            face = Direction.UP;
        } else if (placer.m_146909_() < -50.0f) {
            face = Direction.DOWN;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return ContainerUtil.openGui((Player)player, (BlockPos)pos, AutoClickContainer::new);
    }

    @Deprecated
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == this && newState.m_60734_() == this) {
            return;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof AutoClickerTile) {
            AutoClickerBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)((AutoClickerTile)te).held.getStackInSlot(0));
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    @Deprecated
    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        BlockEntity te = pLevel.m_7702_(pPos);
        if (te instanceof AutoClickerTile) {
            ItemStack i = ((AutoClickerTile)te).held.getStackInSlot(0);
            if (i.m_41619_()) {
                return 0;
            }
            if (i.m_41741_() == 1 && i.m_41763_()) {
                return Mth.m_14143_((float)(15.0f * (float)(i.m_41776_() - i.m_41773_()) / (float)i.m_41776_()));
            }
            return Mth.m_14143_((float)(15.0f * (float)i.m_41613_() / (float)i.m_41741_()));
        }
        return 0;
    }
}

