/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import javax.annotation.Nonnull;
import mcjty.deepresonance.api.fluid.ILiquidCrystalData;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.PurifierConfig;
import mcjty.deepresonance.modules.tank.util.DualTankHook;
import mcjty.deepresonance.util.DeepResonanceFluidHelper;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.InventoryLocator;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PurifierTileEntity
extends TickingTileEntity {
    public static final int SLOT = 0;
    private final DualTankHook tankHook = new DualTankHook((BlockEntity)this, Direction.UP, Direction.DOWN).allowDuplicates().setTimeout(10);
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific((Item[])new Item[]{(Item)CoreModule.FILTER_MATERIAL_ITEM.get()}).in().out(), 0, 64, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.match(CoreModule.FILTER_MATERIAL_ITEM)).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Purifier").containerSupplier(DefaultContainerProvider.container(MachinesModule.PURIFIER_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private final InventoryLocator inventoryLocator = new InventoryLocator();
    private int timeToGo = 0;
    private ILiquidCrystalData processing = null;

    public PurifierTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_PURIFIER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(PurifierTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }

    public void tickServer() {
        if (!this.tankHook.checkTanks()) {
            this.maybeOutput();
            return;
        }
        if (this.timeToGo >= 0) {
            if (!this.hasFilter()) {
                return;
            }
            if (this.timeToGo == 0) {
                this.maybeOutput();
                return;
            }
            --this.timeToGo;
        } else {
            if (!DeepResonanceFluidHelper.isValidLiquidCrystalStack(this.tankHook.getTank1().drain(1, IFluidHandler.FluidAction.SIMULATE))) {
                this.timeToGo = 20;
                return;
            }
            this.processing = DeepResonanceFluidHelper.readCrystalDataFromStack(this.tankHook.getTank1().drain(((Integer)PurifierConfig.RCL_PER_PURIFY.get()).intValue(), IFluidHandler.FluidAction.EXECUTE));
            this.timeToGo = (Integer)PurifierConfig.TICKS_PER_PURIFY.get();
        }
        this.m_6596_();
    }

    private void maybeOutput() {
        if (this.processing != null) {
            if (!this.hasFilter()) {
                return;
            }
            int purify = this.doPurify(this.processing);
            if (purify < 0) {
                return;
            }
            if (this.f_58857_.f_46441_.nextInt(purify) == 0) {
                this.consumeFilter();
            }
        }
        this.timeToGo = -1;
        this.m_6596_();
    }

    private void consumeFilter() {
        this.items.decrStackSize(0, 1);
        ItemStack spentMaterial = new ItemStack((ItemLike)CoreModule.SPENT_FILTER_ITEM.get(), 1);
        this.inventoryLocator.ejectStack(this.f_58857_, this.f_58858_, spentMaterial, this.f_58858_, OrientationTools.HORIZONTAL_DIRECTION_VALUES);
    }

    private int doPurify(@Nonnull ILiquidCrystalData fluidData) {
        double maxPurityToAdd;
        if (!this.tankHook.tank2Present()) {
            return -1;
        }
        IFluidHandler outputTank = this.tankHook.getTank2();
        int tryAmount = outputTank.fill(fluidData.getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
        if (tryAmount != fluidData.getAmount()) {
            return -1;
        }
        double purity = fluidData.getPurity();
        double addedPurity = maxPurityToAdd = (double)((Integer)PurifierConfig.ADDED_PURITY.get()).intValue() / 100.0;
        double maxPurity = ((double)((Integer)PurifierConfig.MAX_PURITY.get()).intValue() + 0.1) / 100.0;
        if (purity + addedPurity > (maxPurity *= fluidData.getQuality()) && (addedPurity = maxPurity - purity) < 1.0E-4) {
            outputTank.fill(fluidData.getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
            this.processing = null;
            return 100000;
        }
        fluidData.setPurity(purity += addedPurity);
        outputTank.fill(fluidData.getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
        this.processing = null;
        return (int)((maxPurityToAdd - addedPurity) * 40.0 / maxPurityToAdd + 1.0);
    }

    private boolean hasFilter() {
        return this.items.getStackInSlot(0).m_41720_() == CoreModule.FILTER_MATERIAL_ITEM.get();
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("timeToGo", this.timeToGo);
        if (this.processing != null) {
            CompoundTag tag = new CompoundTag();
            this.processing.getFluidStack().writeToNBT(tag);
            tagCompound.m_128365_("processing", (Tag)tag);
        }
        super.m_183515_(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        this.timeToGo = tagCompound.m_128451_("timeToGo");
        this.processing = tagCompound.m_128441_("processing") ? DeepResonanceFluidHelper.readCrystalDataFromStack(FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound.m_128469_("processing"))) : null;
        super.m_142466_(tagCompound);
    }
}

