/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.SmelterConfig;
import mcjty.deepresonance.modules.tank.util.DualTankHook;
import mcjty.deepresonance.util.DeepResonanceFluidHelper;
import mcjty.deepresonance.util.DeepResonanceTags;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SmelterTileEntity
extends TickingTileEntity {
    public static final int SLOT = 0;
    private final DualTankHook tankHook = new DualTankHook((BlockEntity)this, Direction.DOWN, Direction.UP);
    @GuiValue
    private int processTimeLeft = 0;
    @GuiValue
    private int processTime = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.generic().in().out(), 0, 64, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((integer, itemStack) -> true).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)SmelterConfig.POWER_MAXIMUM.get()).intValue(), (long)((Integer)SmelterConfig.POWER_PER_TICK_IN.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Smelter").containerSupplier(DefaultContainerProvider.container(MachinesModule.SMELTER_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)this)).energyHandler(() -> this.energyStorage).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private float finalQuality = 1.0f;
    private float finalPurity = 0.1f;

    public SmelterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_SMELTER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(SmelterTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{BlockStateProperties.f_61448_});
            }
        };
    }

    public void tickServer() {
        if (this.processTimeLeft > 0) {
            if (this.canWork()) {
                --this.processTimeLeft;
                this.energyStorage.consumeEnergy((long)((Integer)SmelterConfig.POWER_PER_ORE_TICK.get()).intValue());
                if (this.processTimeLeft == 0) {
                    this.finishSmelting();
                }
            }
        } else {
            boolean newworking;
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            boolean oldworking = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
            if (this.canWork() && this.inputSlotValid()) {
                this.startSmelting();
                newworking = true;
            } else {
                newworking = false;
            }
            if (newworking != oldworking) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(newworking));
                this.f_58857_.m_7731_(this.m_58899_(), state, 11);
            }
        }
    }

    private boolean canWork() {
        if (!this.tankHook.checkTankContents((Fluid)Fluids.f_76195_, null)) {
            return false;
        }
        if ((double)this.tankHook.getTank1().getFluidInTank(0).getAmount() < (double)this.tankHook.getTank1().getTankCapacity(0) * 0.25) {
            return false;
        }
        int fill = (Integer)SmelterConfig.RCL_PER_ORE.get();
        if (this.tankHook.getTank2().fill(DeepResonanceFluidHelper.makeLiquidCrystalStack(fill), IFluidHandler.FluidAction.SIMULATE) != fill) {
            return false;
        }
        return this.energyStorage.getEnergyStored() >= (Integer)SmelterConfig.POWER_PER_ORE_TICK.get();
    }

    private boolean inputSlotValid() {
        return !this.items.getStackInSlot(0).m_41619_() && DeepResonanceTags.RESONANT_ORE_ITEM.m_8110_((Object)this.items.getStackInSlot(0).m_41720_());
    }

    private void startSmelting() {
        ItemStack stack = this.items.extractItem(0, 1, false);
        if (stack.m_41619_()) {
            return;
        }
        IFluidHandler lavaTank = this.tankHook.getTank1();
        float percentage = (float)lavaTank.getFluidInTank(0).getAmount() / (float)lavaTank.getTankCapacity(0);
        if (percentage < 0.4f) {
            this.finalQuality = 1.0f - (0.4f - percentage);
            this.finalPurity = 0.1f;
        } else if (percentage > 0.75f) {
            this.finalQuality = -1.0f;
            this.finalPurity = 0.0f;
        } else if (percentage > 0.6f) {
            this.finalQuality = 1.0f - (percentage - 0.6f) * 6.666f;
            this.finalPurity = 0.1f - (percentage - 0.6f) * 0.3f;
        } else {
            this.finalQuality = 1.0f;
            this.finalPurity = 0.1f;
        }
        lavaTank.drain(new FluidStack((Fluid)Fluids.f_76195_, ((Integer)SmelterConfig.LAVA_COST.get()).intValue()), IFluidHandler.FluidAction.EXECUTE);
        int processTimeConfig = (Integer)SmelterConfig.PROCESS_TIME.get();
        this.processTime = this.processTimeLeft = (int)((short)(processTimeConfig + (int)((percentage - 0.5f) * (float)processTimeConfig)));
    }

    private void finishSmelting() {
        if (this.finalQuality > 0.0f) {
            FluidStack stack = DeepResonanceFluidHelper.makeLiquidCrystalStack((Integer)SmelterConfig.RCL_PER_ORE.get(), this.finalQuality, this.finalPurity, 0.1f, 0.1f);
            this.tankHook.getTank2().fill(stack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("processTime", this.processTime);
        tagCompound.m_128405_("processTimeLeft", this.processTimeLeft);
        tagCompound.m_128350_("finalQuality", this.finalQuality);
        tagCompound.m_128350_("finalPurity", this.finalPurity);
        super.m_183515_(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.processTime = (short)tagCompound.m_128451_("processTime");
        this.processTimeLeft = (short)tagCompound.m_128451_("processTimeLeft");
        this.finalQuality = tagCompound.m_128457_("finalQuality");
        this.finalPurity = tagCompound.m_128457_("finalPurity");
    }

    public int getProgress() {
        if (this.processTime == 0) {
            return 0;
        }
        return (int)((float)(this.processTime - this.processTimeLeft) / (float)this.processTime * 100.0f);
    }

    public int getMaxPower() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getCurrentPower() {
        return this.energyStorage.getEnergyStored();
    }
}

