/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.ValveConfig;
import mcjty.deepresonance.modules.tank.util.DualTankHook;
import mcjty.deepresonance.util.DeepResonanceFluidHelper;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ValveTileEntity
extends TickingTileEntity {
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(0));
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Valve").containerSupplier(DefaultContainerProvider.container(MachinesModule.VALVE_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));
    private final DualTankHook tankHook = new DualTankHook((BlockEntity)this, Direction.UP, Direction.DOWN);
    private int progress = 0;
    @GuiValue
    public static final Value<?, Float> VALUE_MINPURITY = Value.create((String)"minPurity", (Type)Type.FLOAT, ValveTileEntity::getMinPurity, ValveTileEntity::setMinPurity);
    private float minPurity = 1.0f;
    @GuiValue
    public static final Value<?, Float> VALUE_STRENGTH = Value.create((String)"minStrength", (Type)Type.FLOAT, ValveTileEntity::getMinStrength, ValveTileEntity::setMinStrength);
    private float minStrength = 1.0f;
    @GuiValue
    public static final Value<?, Float> VALUE_EFFICIENCY = Value.create((String)"minEfficiency", (Type)Type.FLOAT, ValveTileEntity::getMinEfficiency, ValveTileEntity::setMinEfficiency);
    private float minEfficiency = 1.0f;
    @GuiValue
    public static final Value<?, Integer> VALUE_MAXMB = Value.create((String)"maxMb", (Type)Type.INTEGER, ValveTileEntity::getMaxMb, ValveTileEntity::setMaxMb);
    private int maxMb = 0;

    public ValveTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_VALVE.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(ValveTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[0]);
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void tickServer() {
        if (!this.isMachineEnabled()) {
            return;
        }
        --this.progress;
        this.m_6596_();
        if (this.progress > 0) {
            return;
        }
        this.progress = (Integer)ValveConfig.TICKS_PER_OPERATION.get();
        if (!this.tankHook.checkTanks()) {
            return;
        }
        IFluidHandler top = this.tankHook.getTank1();
        IFluidHandler bottom = this.tankHook.getTank2();
        int rcl = (Integer)ValveConfig.RCL_PER_OPERATION.get();
        FluidStack fluidStack = top.drain(rcl, IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.isEmpty()) {
            return;
        }
        int amt = fluidStack.getAmount();
        if (bottom.fill(DeepResonanceFluidHelper.makeLiquidCrystalStack(amt), IFluidHandler.FluidAction.SIMULATE) == amt) {
            LiquidCrystalData data = DeepResonanceFluidHelper.readCrystalDataFromStack(fluidStack);
            if (data.getPurity() < (double)this.minPurity) {
                return;
            }
            if (data.getStrength() < (double)this.minStrength) {
                return;
            }
            if (data.getEfficiency() < (double)this.minEfficiency) {
                return;
            }
            if (this.maxMb > 0) {
                int fluidAmount = bottom.getFluidInTank(0).getAmount();
                if (fluidAmount < this.maxMb) {
                    int toDrain = Math.min(this.maxMb - fluidAmount, rcl);
                    fluidStack = top.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                    bottom.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                fluidStack = top.drain(rcl, IFluidHandler.FluidAction.EXECUTE);
                bottom.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public int getMaxMb() {
        return this.maxMb;
    }

    public void setMaxMb(int maxMb) {
        this.maxMb = maxMb;
        this.m_6596_();
    }

    public float getMinEfficiency() {
        return this.minEfficiency;
    }

    public void setMinEfficiency(float minEfficiency) {
        this.minEfficiency = minEfficiency;
        this.m_6596_();
    }

    public float getMinPurity() {
        return this.minPurity;
    }

    public void setMinPurity(float minPurity) {
        this.minPurity = minPurity;
        this.m_6596_();
    }

    public float getMinStrength() {
        return this.minStrength;
    }

    public void setMinStrength(float minStrength) {
        this.minStrength = minStrength;
        this.m_6596_();
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("progress", this.progress);
        tagCompound.m_128350_("minPurity", this.minPurity);
        tagCompound.m_128350_("minStrength", this.minStrength);
        tagCompound.m_128350_("minEfficiency", this.minEfficiency);
        tagCompound.m_128405_("maxMb", this.maxMb);
        super.m_183515_(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.progress = tagCompound.m_128451_("progress");
        this.minPurity = tagCompound.m_128457_("minPurity");
        this.minStrength = tagCompound.m_128457_("minStrength");
        this.minEfficiency = tagCompound.m_128457_("minEfficiency");
        this.maxMb = tagCompound.m_128451_("maxMb");
    }
}

