/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.CrystallizerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CrystallizerRenderer
implements BlockEntityRenderer<CrystallizerTileEntity> {
    private static final ItemStack stack = new ItemStack((ItemLike)CoreModule.RESONATING_CRYSTAL_GENERATED.get());

    public CrystallizerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)MachinesModule.TYPE_CRYSTALIZER.get()), CrystallizerRenderer::new);
    }

    public void render(@Nonnull CrystallizerTileEntity tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int progress = tile.getProgress();
        if (tile.hasCrystal()) {
            progress = 100;
        }
        if (progress > 0) {
            matrixStack.m_85836_();
            float scale = 0.75f + 0.45f * ((float)progress / 100.0f);
            float f = Math.floorMod(tile.m_58904_().m_46467_(), 120);
            matrixStack.m_85837_(0.5, 0.35 + 0.0 * (double)progress, 0.5);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(f * 3.0f));
            matrixStack.m_85841_(scale, scale, scale);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            BakedModel ibakedmodel = itemRenderer.m_174264_(stack, (Level)Minecraft.m_91087_().f_91073_, null, 0);
            itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GROUND, false, matrixStack, type -> buffer.m_6299_(RenderType.m_110451_()), 0x780078, combinedOverlay, ibakedmodel);
            matrixStack.m_85849_();
        }
    }
}

