/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.blocks;

import java.util.Collections;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.tank.data.DRTankHandler;
import mcjty.deepresonance.modules.tank.data.DRTankNetwork;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.multiblock.MultiblockSupport;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TankTileEntity
extends GenericTileEntity
implements IMultiblockConnector {
    private int blobId = -1;
    private Fluid clientRenderFluid;
    private float renderHeight;
    private FluidStack preservedFluid = FluidStack.EMPTY;
    @Cap(type=CapType.FLUIDS)
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(this::createFluidHandler);

    public TankTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TankModule.TYPE_TANK.get(), pos, state);
    }

    public void setClientData(float newHeight, Fluid render) {
        boolean dirty = false;
        if (newHeight >= 0.0f && this.renderHeight != newHeight) {
            this.renderHeight = newHeight;
            dirty = true;
        }
        if (this.clientRenderFluid != render) {
            this.clientRenderFluid = render;
            dirty = true;
        }
        if (dirty) {
            this.markDirtyClient();
        }
    }

    public float getClientRenderHeight() {
        return this.renderHeight;
    }

    public Fluid getClientRenderFluid() {
        return this.clientRenderFluid;
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("blobid", this.blobId);
        this.saveClientDataToNBT(tagCompound);
        super.m_183515_(tagCompound);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag tag = new CompoundTag();
        this.preservedFluid.writeToNBT(tag);
        this.getOrCreateInfo(tagCompound).m_128365_("preserved", (Tag)tag);
    }

    public void m_142466_(CompoundTag tagCompound) {
        this.blobId = tagCompound.m_128441_("blobid") ? tagCompound.m_128451_("blobid") : -1;
        this.loadClientDataFromNBT(tagCompound);
        super.m_142466_(tagCompound);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.preservedFluid = info.m_128441_("preserved") ? FluidStack.loadFluidStackFromNBT((CompoundTag)info.m_128469_("preserved")) : FluidStack.EMPTY;
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128350_("renderC", this.renderHeight);
        if (this.clientRenderFluid != null) {
            tagCompound.m_128359_("fluidC", this.clientRenderFluid.getRegistryName().toString());
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.renderHeight = tagCompound.m_128457_("renderC");
        this.clientRenderFluid = tagCompound.m_128441_("fluidC") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tagCompound.m_128461_("fluidC"))) : null;
    }

    public InteractionResult onBlockActivated(BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        if (FluidUtil.getFluidHandler((ItemStack)player.m_21120_(hand)).isPresent()) {
            if (!this.f_58857_.f_46443_) {
                FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)this.m_58904_(), (BlockPos)result.m_82425_(), (Direction)result.m_82434_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.onBlockActivated(state, player, hand, result);
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.m_5776_()) {
            CompoundTag tag;
            this.addBlockToNetwork();
            TankBlob network = this.getBlob();
            if (network != null && (tag = stack.m_41783_()) != null) {
                this.getDriver().modify(this.getMultiblockId(), holder -> {
                    CompoundTag infoTag = tag.m_128469_("BlockEntityTag").m_128469_("Info");
                    if (infoTag.m_128441_("preserved")) {
                        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)infoTag.m_128469_("preserved"));
                        ((TankBlob)holder.getMb()).fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    }
                });
            }
        }
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (!world.m_5776_()) {
            BlockState stateDown;
            BlockState stateUp;
            if (newstate.m_60734_() != GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                TankBlob network = this.getBlob();
                if (network != null) {
                    network.getData().ifPresent(data -> {
                        this.preservedFluid = data.getFluidStack().copy();
                        int amount = data.getAmount() / network.getTankBlocks();
                        this.preservedFluid.setAmount(amount);
                        data.setAmount(data.getAmount() - amount);
                        this.m_6596_();
                    });
                }
                this.removeBlockFromNetwork();
            }
            if ((stateUp = world.m_8055_(pos.m_7494_())).m_60734_() == GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                world.m_7260_(pos.m_7494_(), stateUp, stateUp, 3);
            }
            if ((stateDown = world.m_8055_(pos.m_7495_())).m_60734_() == GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                world.m_7260_(pos.m_7495_(), stateDown, stateDown, 3);
            }
        }
    }

    public void addBlockToNetwork() {
        TankBlob newMb = new TankBlob().setTankBlocks(1);
        newMb.updateDistribution(Collections.singleton(this.f_58858_));
        MultiblockSupport.addBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), DRTankNetwork.getNetwork(this.f_58857_).getDriver(), (IMultiblock)newMb);
        this.updateHeightsForClient();
    }

    public void removeBlockFromNetwork() {
        MultiblockSupport.removeBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), DRTankNetwork.getNetwork(this.f_58857_).getDriver());
    }

    private void updateHeightsForClient() {
        int id = this.getMultiblockId();
        if (id != -1) {
            TankBlob blob = this.getBlob();
            FluidStack fluidStack = blob.getData().map(LiquidCrystalData::getFluidStack).orElse(FluidStack.EMPTY);
            int amount = fluidStack.getAmount();
            int capacityPerTank = blob.getCapacityPerTank();
            DRTankNetwork.foreach(this.f_58857_, id, blockPos -> {
                BlockEntity be = this.f_58857_.m_7702_(blockPos);
                if (be instanceof TankTileEntity) {
                    float height;
                    int countBelow = blob.getBlocksBelowY(blockPos.m_123342_());
                    int countAtY = blob.getBlocksAtY(blockPos.m_123342_());
                    if (amount <= countBelow * capacityPerTank) {
                        height = 0.0f;
                    } else if (amount > (countBelow + countAtY) * capacityPerTank) {
                        height = 1.0f;
                    } else {
                        height = amount - countBelow * capacityPerTank;
                        height /= (float)(countAtY * capacityPerTank);
                    }
                    ((TankTileEntity)be).setClientData(height, fluidStack.getFluid());
                }
            }, this.f_58858_);
        }
    }

    public ResourceLocation getId() {
        return DRTankNetwork.TANK_NETWORK_ID;
    }

    public int getMultiblockId() {
        return this.blobId;
    }

    public void setMultiblockId(int newId) {
        if (this.blobId != newId) {
            this.blobId = newId;
            this.m_6596_();
        }
    }

    public TankBlob getBlob() {
        if (this.blobId == -1) {
            return null;
        }
        DRTankNetwork network = DRTankNetwork.getNetwork(this.f_58857_);
        return network.getOrCreateBlob(this.blobId);
    }

    private MultiblockDriver<TankBlob> getDriver() {
        return DRTankNetwork.getNetwork(this.f_58857_).getDriver();
    }

    @Nonnull
    private IFluidHandler createFluidHandler() {
        return new DRTankHandler(this.f_58857_, this::getMultiblockId){

            @Override
            public void onUpdate() {
                TankTileEntity.this.updateHeightsForClient();
                TankTileEntity.this.m_6596_();
                DRTankNetwork.getNetwork(TankTileEntity.this.f_58857_).save();
            }
        };
    }
}

