/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.tank.blocks.TankTileEntity;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class TankTESR
implements BlockEntityRenderer<TankTileEntity> {
    public static final ResourceLocation TANK_BOTTOM = new ResourceLocation("deepresonance", "block/tank_bottom");
    public static final ResourceLocation TANK_TOP = new ResourceLocation("deepresonance", "block/tank_top");
    public static final ResourceLocation TANK_SIDE = new ResourceLocation("deepresonance", "block/tank_side");

    public TankTESR(BlockEntityRendererProvider.Context context) {
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TankModule.TYPE_TANK.get()), TankTESR::new);
    }

    public void render(@Nonnull TankTileEntity tileTank, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TankTESR.renderInternal(tileTank, matrixStackIn, bufferIn, combinedLightIn);
    }

    public static void renderInternal(TankTileEntity tileTank, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        BlockPos pos = tileTank.m_58899_();
        Fluid fluidToRender = tileTank.getClientRenderFluid();
        Set dirs = Arrays.stream(OrientationTools.DIRECTION_VALUES).filter(dir -> {
            if (dir == Direction.DOWN && (double)tileTank.getClientRenderHeight() > 1.0E-4 && fluidToRender != null && fluidToRender != Fluids.f_76191_ && ItemBlockRenderTypes.canRenderInLayer((FluidState)fluidToRender.m_76145_(), (RenderType)RenderType.m_110451_())) {
                return false;
            }
            BlockEntity tile = tileTank.m_58904_().m_7702_(pos.m_142300_(dir));
            return !(tile instanceof TankTileEntity) || ((TankTileEntity)tile).getClientRenderFluid() != fluidToRender;
        }).collect(Collectors.toCollection(() -> EnumSet.noneOf(Direction.class)));
        float scale = tileTank.getClientRenderHeight();
        if (fluidToRender != null) {
            int color = fluidToRender.getAttributes().getColor((BlockAndTintGetter)tileTank.m_58904_(), tileTank.m_58899_());
            int luminosity = fluidToRender.getAttributes().getLuminosity();
            int block = LightTexture.m_109883_((int)combinedLightIn);
            int packed = LightTexture.m_109885_((int)Math.max(luminosity, block), (int)0);
            TankTESR.render(matrixStackIn, bufferIn, fluidToRender, dirs, combinedLightIn, packed, scale, color);
        }
    }

    private static void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, Fluid renderFluid, Set<Direction> dirs, int combinedLightIn, int liquidBrightness, float scale, int color) {
        matrixStackIn.m_85836_();
        TankTESR.renderModel(matrixStackIn, bufferIn.m_6299_(RenderType.m_110466_()), dirs, combinedLightIn);
        if (renderFluid != null) {
            for (RenderType renderType : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((FluidState)renderFluid.m_76145_(), (RenderType)renderType)) continue;
                TankTESR.renderFluid(scale, color, bufferIn.m_6299_(renderType), renderFluid, dirs, liquidBrightness, matrixStackIn);
            }
        }
        matrixStackIn.m_85849_();
    }

    private static void renderModel(PoseStack matrixStack, VertexConsumer vertexBuilder, Set<Direction> dirs, int brightness) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        if (dirs.contains(Direction.UP)) {
            TextureAtlasSprite tank_top = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(TANK_TOP);
            RenderHelper.drawQuad((Matrix4f)matrix, (VertexConsumer)vertexBuilder, (TextureAtlasSprite)tank_top, (Direction)Direction.UP, (boolean)true, (float)0.1f, (RenderSettings)RenderSettings.builder().brightness(brightness).build());
        }
        if (dirs.contains(Direction.DOWN)) {
            TextureAtlasSprite tank_bottom = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(TANK_BOTTOM);
            RenderHelper.drawQuad((Matrix4f)matrix, (VertexConsumer)vertexBuilder, (TextureAtlasSprite)tank_bottom, (Direction)Direction.DOWN, (boolean)true, (float)0.1f, (RenderSettings)RenderSettings.builder().brightness(brightness).build());
        }
        TextureAtlasSprite tank_side = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(TANK_SIDE);
        for (Direction dir : OrientationTools.HORIZONTAL_DIRECTION_VALUES) {
            RenderHelper.drawQuad((Matrix4f)matrix, (VertexConsumer)vertexBuilder, (TextureAtlasSprite)tank_side, (Direction)dir, (boolean)true, (float)0.1f, (RenderSettings)RenderSettings.builder().brightness(brightness).build());
        }
    }

    private static void renderFluid(float scale, int color, VertexConsumer vertexBuilder, Fluid fluidToRender, Set<Direction> dirs, int brightness, PoseStack matrixStack) {
        float offset = -0.002f;
        TextureAtlasSprite fluid = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidToRender.getAttributes().getStillTexture());
        float u1 = fluid.m_118409_();
        float v1 = fluid.m_118411_();
        float u2 = fluid.m_118410_();
        float v2 = fluid.m_118412_();
        float edge = 0.18125f;
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        if (scale > 0.0f) {
            RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)0.0f, (float)(scale + offset), (float)0.0f, (float)u1, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
            RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)0.0f, (float)(scale + offset), (float)1.0f, (float)u1, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
            RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)1.0f, (float)(scale + offset), (float)1.0f, (float)u2, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
            RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)1.0f, (float)(scale + offset), (float)0.0f, (float)u2, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
            if (scale > edge) {
                if (scale > 1.0f - edge) {
                    scale = 1.0f - edge;
                }
                v2 -= (fluid.m_118412_() - fluid.m_118411_()) * (1.0f - scale);
                if (dirs.contains(Direction.NORTH)) {
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(1.0f - edge), (float)scale, (float)(-offset), (float)u1, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(1.0f - edge), (float)edge, (float)(-offset), (float)u1, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)edge, (float)edge, (float)(-offset), (float)u2, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)edge, (float)scale, (float)(-offset), (float)u2, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                }
                if (dirs.contains(Direction.WEST)) {
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(-offset), (float)edge, (float)(1.0f - edge), (float)u1, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(-offset), (float)scale, (float)(1.0f - edge), (float)u1, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(-offset), (float)scale, (float)edge, (float)u2, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(-offset), (float)edge, (float)edge, (float)u2, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                }
                if (dirs.contains(Direction.SOUTH)) {
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(1.0f - edge), (float)edge, (float)(1.0f + offset), (float)u1, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(1.0f - edge), (float)scale, (float)(1.0f + offset), (float)u1, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)edge, (float)scale, (float)(1.0f + offset), (float)u2, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)edge, (float)edge, (float)(1.0f + offset), (float)u2, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                }
                if (dirs.contains(Direction.EAST)) {
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(1.0f + offset), (float)scale, (float)(1.0f - edge), (float)u1, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(1.0f + offset), (float)edge, (float)(1.0f - edge), (float)u1, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(1.0f + offset), (float)edge, (float)edge, (float)u2, (float)v2, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                    RenderHelper.vt((VertexConsumer)vertexBuilder, (Matrix4f)matrix, (float)(1.0f + offset), (float)scale, (float)edge, (float)u2, (float)v1, (int)b1, (int)b2, (float)r, (float)g, (float)b, (float)a);
                }
            }
        }
    }
}

