/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.data;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.tank.data.DRTankNetwork;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.util.LiquidCrystalData;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DRTankHandler
implements IFluidHandler,
IFluidTank {
    private final Level level;
    private final Supplier<Integer> blobIdGetter;

    public DRTankHandler(Level level, Supplier<Integer> blobIdGetter) {
        this.level = level;
        this.blobIdGetter = blobIdGetter;
    }

    public int getTanks() {
        return 1;
    }

    private Optional<LiquidCrystalData> getData() {
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob == null) {
            return Optional.empty();
        }
        return blob.getData();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getData().map(LiquidCrystalData::getFluidStack).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            return blob.getCapacity();
        }
        return 0;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            int filled = blob.fill(resource, action);
            if (filled > 0 && action.execute()) {
                this.onUpdate();
            }
            return filled;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            FluidStack drained = blob.drain(resource, action);
            if (!drained.isEmpty() && action.execute()) {
                this.onUpdate();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            FluidStack drained = blob.drain(maxDrain, action);
            if (!drained.isEmpty() && action.execute()) {
                this.onUpdate();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.getData().map(LiquidCrystalData::getFluidStack).orElse(FluidStack.EMPTY);
    }

    public int getFluidAmount() {
        return this.getData().map(LiquidCrystalData::getAmount).orElse(0);
    }

    public int getCapacity() {
        TankBlob blob = DRTankNetwork.getNetwork(this.level).getBlob(this.blobIdGetter.get());
        if (blob != null) {
            return blob.getCapacity();
        }
        return 0;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public void onUpdate() {
    }
}

