/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.data;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.deepresonance.api.fluid.ILiquidCrystalData;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.multiblock.IMultiblock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankBlob
implements IMultiblock {
    private LiquidCrystalData data;
    private int tankBlocks;
    private int minY;
    private int[] blocksPerLevel;

    public TankBlob() {
    }

    public TankBlob(TankBlob other) {
        this.data = other.data;
        this.tankBlocks = other.tankBlocks;
        this.minY = other.minY;
        this.blocksPerLevel = other.blocksPerLevel;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getBlocksAtY(int y) {
        if (this.blocksPerLevel == null) {
            return 0;
        }
        if (y >= this.minY && y < this.minY + this.blocksPerLevel.length) {
            return this.blocksPerLevel[y - this.minY];
        }
        return 0;
    }

    public int getBlocksBelowY(int y) {
        int total = 0;
        for (int i = this.minY; i < y; ++i) {
            total += this.getBlocksAtY(i);
        }
        return total;
    }

    public int getCapacityPerTank() {
        return 10000;
    }

    public int getCapacity() {
        return this.tankBlocks * 10 * 1000;
    }

    public void merge(TankBlob other) {
        if (this.data != null) {
            other.getData().ifPresent(d -> this.data.merge((ILiquidCrystalData)d));
        } else {
            this.data = other.getData().orElse(null);
        }
        this.tankBlocks += other.getTankBlocks();
        if (this.blocksPerLevel == null) {
            this.minY = other.minY;
            this.blocksPerLevel = other.blocksPerLevel;
        } else if (other.blocksPerLevel != null) {
            int minY = Math.min(this.minY, other.minY);
            int maxY = Math.max(this.minY + this.blocksPerLevel.length, other.minY + other.blocksPerLevel.length);
            int[] mergedBlocksPerLevel = new int[maxY - minY + 1];
            for (int y = minY; y <= maxY; ++y) {
                int ithis = y - this.minY;
                int iother = y - other.minY;
                mergedBlocksPerLevel[y - minY] = ithis >= 0 && ithis < this.blocksPerLevel.length ? this.blocksPerLevel[ithis] : 0;
                int n = y - minY;
                mergedBlocksPerLevel[n] = mergedBlocksPerLevel[n] + (iother >= 0 && iother < other.blocksPerLevel.length ? other.blocksPerLevel[iother] : 0);
            }
            this.minY = minY;
            this.blocksPerLevel = mergedBlocksPerLevel;
        }
    }

    public void updateDistribution(Set<BlockPos> blocks) {
        int minY = blocks.stream().map(Vec3i::m_123342_).min(Integer::compareTo).orElse(0);
        int maxY = blocks.stream().map(Vec3i::m_123342_).max(Integer::compareTo).orElse(0);
        this.blocksPerLevel = new int[maxY - minY + 1];
        Arrays.fill(this.blocksPerLevel, 0);
        blocks.forEach(b -> {
            int n = b.m_123342_() - minY;
            this.blocksPerLevel[n] = this.blocksPerLevel[n] + 1;
        });
        this.minY = minY;
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (this.data == null || this.data.getFluidStack().isEmpty()) {
            int amountToTransfer = Math.min(stack.getAmount(), this.getCapacity());
            if (action.execute()) {
                this.data = LiquidCrystalData.fromStack(stack);
                this.data.setAmount(amountToTransfer);
            }
            return amountToTransfer;
        }
        if (this.data.getFluidStack().getFluid() == stack.getFluid()) {
            int amountToTransfer = Math.min(stack.getAmount(), this.getCapacity() - this.data.getFluidStack().getAmount());
            if (action.execute()) {
                stack = stack.copy();
                stack.setAmount(amountToTransfer);
                this.data.merge(stack);
            }
            return amountToTransfer;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || this.data == null || this.data.getFluidStack().isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (resource.getFluid() != this.data.getFluidStack().getFluid()) {
            return FluidStack.EMPTY;
        }
        if (resource.getAmount() >= this.data.getAmount()) {
            FluidStack result = this.data.getFluidStack();
            if (action.execute()) {
                this.data = null;
            }
            return result;
        }
        FluidStack result = this.data.getFluidStack().copy();
        result.setAmount(resource.getAmount());
        if (action.execute()) {
            this.data.getFluidStack().setAmount(this.data.getFluidStack().getAmount() - result.getAmount());
        }
        return result;
    }

    @Nonnull
    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        if (amount <= 0 || this.data == null || this.data.getFluidStack().isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (amount >= this.data.getAmount()) {
            FluidStack result = this.data.getFluidStack().copy();
            if (action.execute()) {
                this.data = null;
            }
            return result;
        }
        FluidStack result = this.data.getFluidStack().copy();
        result.setAmount(amount);
        if (action.execute()) {
            this.data.getFluidStack().setAmount(this.data.getFluidStack().getAmount() - amount);
        }
        return result;
    }

    @Nonnull
    public Optional<LiquidCrystalData> getData() {
        return Optional.ofNullable(this.data);
    }

    public TankBlob copyData(LiquidCrystalData data) {
        this.data = LiquidCrystalData.fromStack(data.getFluidStack());
        return this;
    }

    public void setStack(FluidStack stack) {
        this.data = LiquidCrystalData.fromStack(stack);
    }

    public TankBlob setTankBlocks(int tankBlocks) {
        this.tankBlocks = tankBlocks;
        return this;
    }

    public int getTankBlocks() {
        return this.tankBlocks;
    }

    public static TankBlob load(CompoundTag tagCompound) {
        TankBlob blob = new TankBlob();
        blob.data = LiquidCrystalData.fromStack(FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound.m_128469_("fluid")));
        blob.setTankBlocks(tagCompound.m_128451_("refcount"));
        blob.minY = tagCompound.m_128451_("miny");
        blob.blocksPerLevel = (int[])(tagCompound.m_128441_("blocksperlevel") ? tagCompound.m_128465_("blocksperlevel") : null);
        return blob;
    }

    public static CompoundTag save(CompoundTag tagCompound, TankBlob network) {
        if (network.data != null) {
            tagCompound.m_128365_("fluid", (Tag)network.data.getFluidStack().writeToNBT(new CompoundTag()));
        }
        tagCompound.m_128405_("refcount", network.tankBlocks);
        tagCompound.m_128405_("miny", network.minY);
        if (network.blocksPerLevel != null) {
            tagCompound.m_128385_("blocksperlevel", network.blocksPerLevel);
        }
        return tagCompound;
    }
}

