/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.util;

import javax.annotation.Nonnull;
import mcjty.deepresonance.api.fluid.ILiquidCrystalData;
import mcjty.deepresonance.modules.core.CoreModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class LiquidCrystalData
implements ILiquidCrystalData {
    private final FluidStack referenceStack;

    private LiquidCrystalData(FluidStack referenceStack) {
        this.referenceStack = referenceStack.copy();
    }

    public LiquidCrystalData(FriendlyByteBuf buf) {
        this.referenceStack = buf.readFluidStack();
    }

    public static FluidStack makeLiquidCrystalStack(int amount, float quality, float purity, float strength, float efficiency) {
        LiquidCrystalData data = new LiquidCrystalData(new FluidStack((Fluid)CoreModule.LIQUID_CRYSTAL.get(), amount));
        data.setAmount(amount);
        data.setStats(quality, purity, strength, efficiency);
        return data.getFluidStack();
    }

    @Nonnull
    public static LiquidCrystalData fromStack(FluidStack stack) {
        return new LiquidCrystalData(stack);
    }

    @Override
    public void merge(ILiquidCrystalData other) {
        FluidStack otherFluid = other.getFluidStack();
        this.merge(otherFluid);
    }

    @Override
    public void merge(FluidStack otherFluid) {
        if (this.referenceStack.getFluid() != otherFluid.getFluid()) {
            return;
        }
        if (this.referenceStack.getFluid() == CoreModule.LIQUID_CRYSTAL.get() && otherFluid.getFluid() == CoreModule.LIQUID_CRYSTAL.get()) {
            double quality = this.mix(otherFluid, "quality");
            double purity = this.mix(otherFluid, "purity");
            double strength = this.mix(otherFluid, "strength");
            double efficiency = this.mix(otherFluid, "efficiency");
            this.referenceStack.setAmount(this.referenceStack.getAmount() + otherFluid.getAmount());
            this.setStats(quality, purity, strength, efficiency);
        } else {
            this.referenceStack.setAmount(this.referenceStack.getAmount() + otherFluid.getAmount());
        }
    }

    private void setStats(double quality, double purity, double strength, double efficiency) {
        CompoundTag tag = this.referenceStack.getOrCreateTag();
        tag.m_128347_("quality", quality);
        tag.m_128347_("purity", purity);
        tag.m_128347_("strength", strength);
        tag.m_128347_("efficiency", efficiency);
    }

    private double mix(FluidStack other, String tag) {
        double f = (float)other.getAmount() / ((float)this.getAmount() + (float)other.getAmount());
        double thisValue = this.referenceStack.getTag() == null ? 0.0 : this.referenceStack.getTag().m_128459_(tag);
        double otherValue = other.getTag() == null ? 0.0 : other.getTag().m_128459_(tag);
        return (1.0 - f) * thisValue + f * otherValue;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFluidStack(this.referenceStack);
    }

    @Override
    public double getQuality() {
        CompoundTag tag = this.referenceStack.getTag();
        return tag == null ? 0.0 : tag.m_128459_("quality");
    }

    @Override
    public void setQuality(double quality) {
        this.referenceStack.getOrCreateTag().m_128347_("quality", quality);
    }

    @Override
    public double getPurity() {
        CompoundTag tag = this.referenceStack.getTag();
        return tag == null ? 0.0 : tag.m_128459_("purity");
    }

    @Override
    public void setPurity(double purity) {
        this.referenceStack.getOrCreateTag().m_128347_("purity", purity);
    }

    @Override
    public double getStrength() {
        CompoundTag tag = this.referenceStack.getTag();
        return tag == null ? 0.0 : tag.m_128459_("strength");
    }

    @Override
    public void setStrength(double strength) {
        this.referenceStack.getOrCreateTag().m_128347_("strength", strength);
    }

    @Override
    public double getEfficiency() {
        CompoundTag tag = this.referenceStack.getTag();
        return tag == null ? 0.0 : tag.m_128459_("efficiency");
    }

    @Override
    public void setEfficiency(double efficiency) {
        this.referenceStack.getOrCreateTag().m_128347_("efficiency", efficiency);
    }

    @Override
    public int getAmount() {
        return this.referenceStack.getAmount();
    }

    @Override
    public void setAmount(int i) {
        if (!this.referenceStack.isEmpty()) {
            this.referenceStack.setAmount(i);
        }
    }

    @Override
    public FluidStack getFluidStack() {
        return this.referenceStack;
    }

    public String toString() {
        return "Amount: " + this.referenceStack.getAmount() + " ,Quality: " + this.getQuality() + " ,Purity: " + this.getPurity() + " ,Strength: " + this.getStrength() + " ,Efficiency: " + this.getEfficiency();
    }
}

