/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.thevortex.allthemodium.crafting.ATMCraftingSetup;
import com.thevortex.allthemodium.events.ArmorEvents;
import com.thevortex.allthemodium.events.BlockBreak;
import com.thevortex.allthemodium.init.ModItems;
import com.thevortex.allthemodium.registry.ModRegistry;
import com.thevortex.allthemodium.worldgen.MiningDimSource;
import com.thevortex.allthemodium.worldgen.TheOtherDimSource;
import com.thevortex.allthemodium.worldgen.biomes.ATMBiomes;
import com.thevortex.allthemodium.worldgen.structures.APStructure;
import com.thevortex.allthemodium.worldgen.structures.ATMConfiguredStructures;
import com.thevortex.allthemodium.worldgen.structures.ATMStructures;
import com.thevortex.allthemodium.worldgen.structures.DungeonStructure;
import com.thevortex.allthemodium.worldgen.structures.PVStructure;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="allthemodium")
@Mod.EventBusSubscriber(modid="allthemodium", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AllTheModium {
    public static final ResourceKey<Level> OverWorld = Level.f_46428_;
    public static final ResourceKey<Level> Nether = Level.f_46429_;
    public static final ResourceKey<Level> The_End = Level.f_46430_;
    public static final ResourceLocation MINING_DIM_ID = new ResourceLocation("allthemodium", "mining");
    public static final ResourceLocation THE_OTHER_DIM_ID = new ResourceLocation("allthemodium", "the_other");
    public static final ResourceKey<Level> Mining = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)MINING_DIM_ID);
    public static final ResourceKey<Level> THE_OTHER = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)THE_OTHER_DIM_ID);
    public static final Logger LOGGER = LogManager.getLogger((String)"allthemodium");
    public static boolean ALLOW_TELEPORT_MINING = false;
    public static final CreativeModeTab GROUP = new CreativeModeTab("allthemodium"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModRegistry.ALLTHEMODIUM_ORE_ITEM.get());
        }
    };
    private static Method GETCODEC_METHOD;

    public AllTheModium() {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)MINING_DIM_ID, MiningDimSource.CODEC);
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)THE_OTHER_DIM_ID, TheOtherDimSource.CODEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModRegistry.FLUIDS.register(modEventBus);
        ModRegistry.BLOCKS.register(modEventBus);
        ModRegistry.SHAPED_BLOCKS.register(modEventBus);
        ModRegistry.STAIRBLOCKS.register(modEventBus);
        ModRegistry.SLABBLOCKS.register(modEventBus);
        ModRegistry.WALLBLOCKS.register(modEventBus);
        ModRegistry.PILLARBLOCKS.register(modEventBus);
        ModRegistry.ITEMS.register(modEventBus);
        ModRegistry.ENTITIES.register(modEventBus);
        ModRegistry.FEATURES.register(modEventBus);
        ModRegistry.CARVERS.register(modEventBus);
        ATMCraftingSetup.REGISTRY.register(modEventBus);
        ATMStructures.STRUCTURES.register(modEventBus);
        modEventBus.register(ModRegistry.class);
        modEventBus.addListener(this::setup);
        if (ModList.get().isLoaded("mekanism")) {
            // empty if block
        }
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, APStructure::setupStructureSpawns);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, DungeonStructure::setupStructureSpawns);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, PVStructure::setupStructureSpawns);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(BlockBreak.class);
        MinecraftForge.EVENT_BUS.register(ArmorEvents.class);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ATMStructures.setupStructures();
            ATMConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap STStructureToMultiMap = new HashMap();
            AllTheModium.associateBiomeToConfiguredStructure(STStructureToMultiMap, ATMConfiguredStructures.CONFIGURED_VILLAGE, ATMBiomes.WARPED_FOREST);
            AllTheModium.associateBiomeToConfiguredStructure(STStructureToMultiMap, ATMConfiguredStructures.CONFIGURED_DUNGEON, ATMBiomes.THE_OTHER);
            AllTheModium.associateBiomeToConfiguredStructure(STStructureToMultiMap, ATMConfiguredStructures.CONFIGURED_VILLAGE, ATMBiomes.CRIMSON_FOREST);
            AllTheModium.associateBiomeToConfiguredStructure(STStructureToMultiMap, ATMConfiguredStructures.CONFIGURED_PYRAMID, ATMBiomes.DESERT);
            AllTheModium.associateBiomeToConfiguredStructure(STStructureToMultiMap, ATMConfiguredStructures.CONFIGURED_PYRAMID, ATMBiomes.DESERT_HILLS);
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !STStructureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            STStructureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)ATMStructures.PYRAMID.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)ATMStructures.PYRAMID.get()));
            tempMap.putIfAbsent((StructureFeature)ATMStructures.DUNGEON.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)ATMStructures.DUNGEON.get()));
            tempMap.putIfAbsent((StructureFeature)ATMStructures.VILLAGE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)ATMStructures.VILLAGE.get()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="allthemodium")
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            AxeItem.f_150683_ = new ImmutableMap.Builder().put((Object)((Block)ModRegistry.SOUL_LOG.get()), (Object)((Block)ModRegistry.SOUL_LOG_STRIPPED.get())).put((Object)((Block)ModRegistry.SOUL_LOG_0.get()), (Object)((Block)ModRegistry.SOUL_LOG_STRIPPED.get())).put((Object)((Block)ModRegistry.SOUL_LOG_1.get()), (Object)((Block)ModRegistry.SOUL_LOG_STRIPPED.get())).put((Object)((Block)ModRegistry.SOUL_LOG_2.get()), (Object)((Block)ModRegistry.SOUL_LOG_STRIPPED.get())).put((Object)((Block)ModRegistry.DEMONIC_LOG.get()), (Object)((Block)ModRegistry.DEMONIC_LOG_STRIPPED.get())).put((Object)((Block)ModRegistry.ANCIENT_LOG_0.get()), (Object)((Block)ModRegistry.ANCIENT_LOG_STRIPPED.get())).put((Object)((Block)ModRegistry.ANCIENT_LOG_1.get()), (Object)((Block)ModRegistry.ANCIENT_LOG_STRIPPED.get())).put((Object)((Block)ModRegistry.ANCIENT_LOG_2.get()), (Object)((Block)ModRegistry.ANCIENT_LOG_STRIPPED.get())).put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).put((Object)Blocks.f_50686_, (Object)Blocks.f_50687_).put((Object)Blocks.f_50688_, (Object)Blocks.f_50689_).put((Object)Blocks.f_50695_, (Object)Blocks.f_50696_).put((Object)Blocks.f_50697_, (Object)Blocks.f_50698_).build();
            ModItems.init(event);
            if (ModList.get().isLoaded("iceandfire")) {
                // empty if block
            }
        }
    }
}

