/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.client;

import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "allthemodium", fileHelper);
    }

    protected void registerStatesAndModels() {
        List<Block> entries = ModRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> !(block instanceof GrassBlock)).filter(block -> !(block instanceof LiquidBlock)).collect(Collectors.toList());
        entries.forEach(this::simpleBlockAndItem);
        this.logBlock((RotatedPillarBlock)ModRegistry.ANCIENT_LOG_0.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.ANCIENT_LOG_1.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.ANCIENT_LOG_2.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.ANCIENT_LOG_STRIPPED.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.ANCIENT_BOOKSHELF.get());
        this.simpleBlockItem((Block)ModRegistry.ANCIENT_LOG_0.get(), (ModelFile)this.models().getBuilder("ancient_log_0"));
        this.simpleBlockItem((Block)ModRegistry.ANCIENT_LOG_1.get(), (ModelFile)this.models().getBuilder("ancient_log_1"));
        this.simpleBlockItem((Block)ModRegistry.ANCIENT_LOG_2.get(), (ModelFile)this.models().getBuilder("ancient_log_2"));
        this.simpleBlockItem((Block)ModRegistry.ANCIENT_LOG_STRIPPED.get(), (ModelFile)this.models().getBuilder("stripped_ancient_log"));
        this.simpleBlockItem((Block)ModRegistry.ANCIENT_BOOKSHELF.get(), (ModelFile)this.models().getBuilder("ancient_bookshelf"));
        this.stairsBlock((StairBlock)ModRegistry.ANCIENT_WOODEN_STAIRS.get(), new ResourceLocation("allthemodium", "block/ancient_planks"));
        this.logBlock((RotatedPillarBlock)ModRegistry.SOUL_LOG.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.SOUL_LOG_0.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.SOUL_LOG_1.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.SOUL_LOG_2.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.SOUL_LOG_STRIPPED.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.SOUL_BOOKSHELF.get());
        this.simpleBlockItem((Block)ModRegistry.SOUL_LOG.get(), (ModelFile)this.models().getBuilder("soul_log"));
        this.simpleBlockItem((Block)ModRegistry.SOUL_LOG_0.get(), (ModelFile)this.models().getBuilder("soul_log_0"));
        this.simpleBlockItem((Block)ModRegistry.SOUL_LOG_1.get(), (ModelFile)this.models().getBuilder("soul_log_1"));
        this.simpleBlockItem((Block)ModRegistry.SOUL_LOG_2.get(), (ModelFile)this.models().getBuilder("soul_log_2"));
        this.simpleBlockItem((Block)ModRegistry.SOUL_LOG_STRIPPED.get(), (ModelFile)this.models().getBuilder("stripped_soul_log"));
        this.simpleBlockItem((Block)ModRegistry.SOUL_BOOKSHELF.get(), (ModelFile)this.models().getBuilder("soul_bookshelf"));
        this.stairsBlock((StairBlock)ModRegistry.SOUL_WOODEN_STAIRS.get(), new ResourceLocation("allthemodium", "block/soul_planks"));
        this.logBlock((RotatedPillarBlock)ModRegistry.DEMONIC_LOG.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.DEMONIC_LOG_STRIPPED.get());
        this.logBlock((RotatedPillarBlock)ModRegistry.DEMONIC_BOOKSHELF.get());
        this.simpleBlockItem((Block)ModRegistry.DEMONIC_LOG.get(), (ModelFile)this.models().getBuilder("demonic_log"));
        this.simpleBlockItem((Block)ModRegistry.DEMONIC_LOG_STRIPPED.get(), (ModelFile)this.models().getBuilder("stripped_demonic_log"));
        this.simpleBlockItem((Block)ModRegistry.DEMONIC_BOOKSHELF.get(), (ModelFile)this.models().getBuilder("demonic_bookshelf"));
        this.stairsBlock((StairBlock)ModRegistry.DEMONIC_WOODEN_STAIRS.get(), new ResourceLocation("allthemodium", "block/demonic_planks"));
        this.stairsBlock((StairBlock)ModRegistry.ANCIENT_STONE_STAIRS.get(), new ResourceLocation("allthemodium", "block/ancient_stone"));
        this.stairsBlock((StairBlock)ModRegistry.ANCIENT_SMOOTH_STONE_STAIRS.get(), new ResourceLocation("allthemodium", "block/ancient_smooth_stone"));
        this.stairsBlock((StairBlock)ModRegistry.ANCIENT_STONE_BRICK_STAIRS.get(), new ResourceLocation("allthemodium", "block/ancient_stone_bricks"));
        this.stairsBlock((StairBlock)ModRegistry.ANCIENT_MOSSY_STONE_STAIRS.get(), new ResourceLocation("allthemodium", "block/ancient_mossy_stone"));
        this.stairsBlock((StairBlock)ModRegistry.ANCIENT_CHISELED_STONE_STAIRS.get(), new ResourceLocation("allthemodium", "block/ancient_chiseled_stone_bricks"));
        this.stairsBlock((StairBlock)ModRegistry.ANCIENT_CRACKED_STONE_STAIRS.get(), new ResourceLocation("allthemodium", "block/ancient_cracked_stone_bricks"));
        this.stairsBlock((StairBlock)ModRegistry.ANCIENT_POLISHED_STONE_STAIRS.get(), new ResourceLocation("allthemodium", "block/ancient_polished_stone"));
        this.fenceBlock(ModRegistry.ANCIENT_WOOD_FENCE_, "ancient_wooden_fence", new ResourceLocation("allthemodium", "block/ancient_planks"));
        this.fenceGateBlock(ModRegistry.ANCIENT_WOOD_FENCE_GATE_, "ancient_wooden_fence_gate", new ResourceLocation("allthemodium", "block/ancient_planks"));
        this.fenceBlock(ModRegistry.DEMONIC_WOOD_FENCE_, "demonic_wooden_fence", new ResourceLocation("allthemodium", "block/demonic_planks"));
        this.fenceGateBlock(ModRegistry.DEMONIC_WOOD_FENCE_GATE_, "demonic_wooden_fence_gate", new ResourceLocation("allthemodium", "block/demonic_planks"));
        this.fenceBlock(ModRegistry.SOUL_WOOD_FENCE_, "soul_wooden_fence", new ResourceLocation("allthemodium", "block/soul_planks"));
        this.fenceGateBlock(ModRegistry.SOUL_WOOD_FENCE_GATE_, "soul_wooden_fence_gate", new ResourceLocation("allthemodium", "block/soul_planks"));
        this.wallBlock(ModRegistry.ANCIENT_STONE_WALL_, "ancient_stone_wall", new ResourceLocation("allthemodium", "block/ancient_stone"));
        this.wallBlock(ModRegistry.ANCIENT_SMOOTH_STONE_WALL_, "ancient_smooth_stone_wall", new ResourceLocation("allthemodium", "block/ancient_smooth_stone"));
        this.wallBlock(ModRegistry.ANCIENT_POLISHED_STONE_WALL_, "ancient_polished_stone_wall", new ResourceLocation("allthemodium", "block/ancient_polished_stone"));
        this.wallBlock(ModRegistry.ANCIENT_MOSSY_STONE_WALL_, "ancient_mossy_stone_wall", new ResourceLocation("allthemodium", "block/ancient_mossy_stone"));
        this.wallBlock(ModRegistry.ANCIENT_STONE_BRICK_WALL_, "ancient_stone_brick_wall", new ResourceLocation("allthemodium", "block/ancient_stone_bricks"));
        this.wallBlock(ModRegistry.ANCIENT_CHISELED_STONE_BRICK_WALL_, "ancient_chiseled_stone_brick_wall", new ResourceLocation("allthemodium", "block/ancient_chiseled_stone_bricks"));
        this.wallBlock(ModRegistry.ANCIENT_CRACKED_STONE_BRICK_WALL_, "ancient_cracked_stone_brick_wall", new ResourceLocation("allthemodium", "block/ancient_cracked_stone_bricks"));
        this.slabBlock((SlabBlock)ModRegistry.ANCIENT_WOODEN_SLABS.get(), new ResourceLocation("allthemodium", "block/ancient_planks"), new ResourceLocation("allthemodium", "block/ancient_planks"));
        this.slabBlock((SlabBlock)ModRegistry.DEMONIC_WOODEN_SLABS.get(), new ResourceLocation("allthemodium", "block/demonic_planks"), new ResourceLocation("allthemodium", "block/demonic_planks"));
        this.slabBlock((SlabBlock)ModRegistry.SOUL_WOODEN_SLABS.get(), new ResourceLocation("allthemodium", "block/soul_planks"), new ResourceLocation("allthemodium", "block/soul_planks"));
        this.slabBlock((SlabBlock)ModRegistry.ANCIENT_STONE_SLABS.get(), new ResourceLocation("allthemodium", "block/ancient_stone"), new ResourceLocation("allthemodium", "block/ancient_stone"));
        this.slabBlock((SlabBlock)ModRegistry.ANCIENT_SMOOTH_STONE_SLABS.get(), new ResourceLocation("allthemodium", "block/ancient_smooth_stone"), new ResourceLocation("allthemodium", "block/ancient_smooth_stone"));
        this.slabBlock((SlabBlock)ModRegistry.ANCIENT_STONE_BRICK_SLABS.get(), new ResourceLocation("allthemodium", "block/ancient_stone_bricks"), new ResourceLocation("allthemodium", "block/ancient_stone_bricks"));
        this.slabBlock((SlabBlock)ModRegistry.ANCIENT_MOSSY_STONE_SLABS.get(), new ResourceLocation("allthemodium", "block/ancient_mossy_stone"), new ResourceLocation("allthemodium", "block/ancient_mossy_stone"));
        this.slabBlock((SlabBlock)ModRegistry.ANCIENT_CHISELED_STONE_SLABS.get(), new ResourceLocation("allthemodium", "block/ancient_chiseled_stone_bricks"), new ResourceLocation("allthemodium", "block/ancient_chiseled_stone_bricks"));
        this.slabBlock((SlabBlock)ModRegistry.ANCIENT_CRACKED_STONE_SLABS.get(), new ResourceLocation("allthemodium", "block/ancient_cracked_stone_bricks"), new ResourceLocation("allthemodium", "block/ancient_cracked_stone_bricks"));
        this.slabBlock((SlabBlock)ModRegistry.ANCIENT_POLISHED_STONE_SLABS.get(), new ResourceLocation("allthemodium", "block/ancient_polished_stone"), new ResourceLocation("allthemodium", "block/ancient_polished_stone"));
        this.doorBlock(ModRegistry.ANCIENT_DOOR, new ResourceLocation("allthemodium", "block/ancient_door_bottom"), new ResourceLocation("allthemodium", "block/ancient_door_top"));
        this.doorBlock(ModRegistry.DEMONIC_DOOR, new ResourceLocation("allthemodium", "block/demonic_door_bottom"), new ResourceLocation("allthemodium", "block/demonic_door_top"));
        this.doorBlock(ModRegistry.SOUL_DOOR, new ResourceLocation("allthemodium", "block/soul_door_bottom"), new ResourceLocation("allthemodium", "block/soul_door_top"));
    }

    private void simpleBlockAndItem(Block block) {
        String blockName = Objects.requireNonNull(block.getRegistryName()).toString();
        this.simpleBlock(block);
        BlockModelBuilder builder = (BlockModelBuilder)this.models().getBuilder(blockName);
        this.simpleBlockItem(block, (ModelFile)builder);
    }
}

