/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.RegistryObject;

public class LootTables
extends LootTableProvider {
    public LootTables(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(BlockLoots::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((name, table) -> net.minecraft.world.level.storage.loot.LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    public static class BlockLoots
    extends BlockLoot {
        private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        public void addTables() {
            this.getKnownBlocks().forEach(this::dropRaw);
        }

        private void dropRaw(Block block) {
            if (block instanceof LiquidBlock) {
                return;
            }
            if (block.getRegistryName().m_135815_().contains("ancient_bookshelf")) {
                this.m_124175_((Block)ModRegistry.ANCIENT_BOOKSHELF.get(), p_124241_ -> BlockLoots.m_176042_((Block)p_124241_, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
            }
            if (block instanceof OreBlock) {
                String oretype = block.getRegistryName().m_135815_();
                if (oretype.contains("allthemodium_ore") || oretype.contains("allthemodium_slate_ore")) {
                    this.m_124175_(block, block1 -> BlockLoots.m_124139_((Block)block1, (Item)((Item)ModRegistry.RAW_ALLTHEMODIUM.get())));
                }
                if (oretype.contains("vibranium_ore")) {
                    this.m_124175_(block, block1 -> BlockLoots.m_124139_((Block)block1, (Item)((Item)ModRegistry.RAW_VIBRANIUM.get())));
                }
                if (oretype.contains("unobtainium_ore")) {
                    this.m_124175_(block, block1 -> BlockLoots.m_124139_((Block)block1, (Item)((Item)ModRegistry.RAW_UNOBTAINIUM.get())));
                }
                if (oretype.contains("raw_")) {
                    this.m_124288_(block);
                }
            } else {
                this.m_124288_(block);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return Stream.of(ModRegistry.BLOCKS.getEntries(), ModRegistry.STAIRBLOCKS.getEntries(), ModRegistry.SLABBLOCKS.getEntries(), ModRegistry.WALLBLOCKS.getEntries(), ModRegistry.PILLARBLOCKS.getEntries()).filter(block -> !(block instanceof LeavesBlock)).flatMap(Collection::stream).map(RegistryObject::get).collect(Collectors.toList());
        }

        protected Iterable<Block> getKnownStairs() {
            return ModRegistry.STAIRBLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        protected Iterable<Block> getKnownSlabs() {
            return ModRegistry.SLABBLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        protected Iterable<Block> getKnownWalls() {
            return ModRegistry.WALLBLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        protected Iterable<Block> getunKnownBlocks() {
            return ModRegistry.PILLARBLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }
    }
}

