/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.worldgen.features;

import com.mojang.serialization.Codec;
import com.thevortex.allthemodium.reference.TagRegistry;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class OtherDripstoneCluster
extends Feature<DripstoneClusterConfiguration> {
    public OtherDripstoneCluster(Codec<DripstoneClusterConfiguration> p_159575_) {
        super(p_159575_);
    }

    public boolean m_142674_(FeaturePlaceContext<DripstoneClusterConfiguration> p_159605_) {
        WorldGenLevel worldgenlevel = p_159605_.m_159774_();
        BlockPos blockpos = p_159605_.m_159777_();
        DripstoneClusterConfiguration dripstoneclusterconfiguration = (DripstoneClusterConfiguration)p_159605_.m_159778_();
        Random random = p_159605_.m_159776_();
        if (!DripstoneUtils.m_159628_((LevelAccessor)worldgenlevel, (BlockPos)blockpos)) {
            return false;
        }
        int i = dripstoneclusterconfiguration.f_160760_.m_142270_(random);
        float f = dripstoneclusterconfiguration.f_160766_.m_142269_(random);
        float f1 = dripstoneclusterconfiguration.f_160765_.m_142269_(random);
        int j = dripstoneclusterconfiguration.f_160761_.m_142270_(random);
        int k = dripstoneclusterconfiguration.f_160761_.m_142270_(random);
        for (int l = -j; l <= j; ++l) {
            for (int i1 = -k; i1 <= k; ++i1) {
                double d0 = this.getChanceOfStalagmiteOrStalactite(j, k, l, i1, dripstoneclusterconfiguration);
                BlockPos blockpos1 = blockpos.m_142082_(l, 0, i1);
                this.placeColumn(worldgenlevel, random, blockpos1, l, i1, f, d0, i, f1, dripstoneclusterconfiguration);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel p_159594_, Random p_159595_, BlockPos p_159596_, int p_159597_, int p_159598_, float p_159599_, double p_159600_, int p_159601_, float p_159602_, DripstoneClusterConfiguration p_159603_) {
        Optional optional = Column.m_158175_((LevelSimulatedReader)p_159594_, (BlockPos)p_159596_, (int)p_159603_.f_160759_, DripstoneUtils::m_159664_, DripstoneUtils::m_159649_);
        if (optional.isPresent()) {
            OptionalInt optionalint = ((Column)optional.get()).m_142011_();
            OptionalInt optionalint1 = ((Column)optional.get()).m_142009_();
            if (optionalint.isPresent() || optionalint1.isPresent()) {
                boolean flag3;
                int j1;
                int j3;
                int i3;
                boolean flag2;
                int j;
                boolean flag1;
                Column column;
                boolean flag;
                boolean bl = flag = p_159595_.nextFloat() < p_159599_;
                if (flag && optionalint1.isPresent() && this.canPlacePool(p_159594_, p_159596_.m_175288_(optionalint1.getAsInt()))) {
                    int i = optionalint1.getAsInt();
                    column = ((Column)optional.get()).m_158181_(OptionalInt.of(i - 1));
                    p_159594_.m_7731_(p_159596_.m_175288_(i), Blocks.f_49990_.m_49966_(), 2);
                } else {
                    column = (Column)optional.get();
                }
                OptionalInt optionalint2 = column.m_142009_();
                boolean bl2 = flag1 = p_159595_.nextDouble() < p_159600_;
                if (optionalint.isPresent() && flag1 && !this.isLava((LevelReader)p_159594_, p_159596_.m_175288_(optionalint.getAsInt()))) {
                    int k = p_159603_.f_160764_.m_142270_(p_159595_);
                    this.replaceBlocksWithDripstoneBlocks(p_159594_, p_159596_.m_175288_(optionalint.getAsInt()), k, Direction.UP);
                    int l = optionalint2.isPresent() ? Math.min(p_159601_, optionalint.getAsInt() - optionalint2.getAsInt()) : p_159601_;
                    j = this.getDripstoneHeight(p_159595_, p_159597_, p_159598_, p_159602_, l, p_159603_);
                } else {
                    j = 0;
                }
                boolean bl3 = flag2 = p_159595_.nextDouble() < p_159600_;
                if (optionalint2.isPresent() && flag2 && !this.isLava((LevelReader)p_159594_, p_159596_.m_175288_(optionalint2.getAsInt()))) {
                    int i1 = p_159603_.f_160764_.m_142270_(p_159595_);
                    this.replaceBlocksWithDripstoneBlocks(p_159594_, p_159596_.m_175288_(optionalint2.getAsInt()), i1, Direction.DOWN);
                    i3 = optionalint.isPresent() ? Math.max(0, j + Mth.m_144928_((Random)p_159595_, (int)(-p_159603_.f_160762_), (int)p_159603_.f_160762_)) : this.getDripstoneHeight(p_159595_, p_159597_, p_159598_, p_159602_, p_159601_, p_159603_);
                } else {
                    i3 = 0;
                }
                if (optionalint.isPresent() && optionalint2.isPresent() && optionalint.getAsInt() - j <= optionalint2.getAsInt() + i3) {
                    int k1 = optionalint2.getAsInt();
                    int l1 = optionalint.getAsInt();
                    int i2 = Math.max(l1 - j, k1 + 1);
                    int j2 = Math.min(k1 + i3, l1 - 1);
                    int k2 = Mth.m_144928_((Random)p_159595_, (int)i2, (int)(j2 + 1));
                    int l2 = k2 - 1;
                    j3 = l1 - k2;
                    j1 = l2 - k1;
                } else {
                    j3 = j;
                    j1 = i3;
                }
                boolean bl4 = flag3 = p_159595_.nextBoolean() && j3 > 0 && j1 > 0 && column.m_142030_().isPresent() && j3 + j1 == column.m_142030_().getAsInt();
                if (optionalint.isPresent()) {
                    DripstoneUtils.m_190847_((LevelAccessor)p_159594_, (BlockPos)p_159596_.m_175288_(optionalint.getAsInt() - 1), (Direction)Direction.DOWN, (int)j3, (boolean)flag3);
                }
                if (optionalint2.isPresent()) {
                    DripstoneUtils.m_190847_((LevelAccessor)p_159594_, (BlockPos)p_159596_.m_175288_(optionalint2.getAsInt() + 1), (Direction)Direction.UP, (int)j1, (boolean)flag3);
                }
            }
        }
    }

    private boolean isLava(LevelReader p_159586_, BlockPos p_159587_) {
        return p_159586_.m_8055_(p_159587_).m_60713_(Blocks.f_49991_);
    }

    private int getDripstoneHeight(Random p_159613_, int p_159614_, int p_159615_, float p_159616_, int p_159617_, DripstoneClusterConfiguration p_159618_) {
        if (p_159613_.nextFloat() > p_159616_) {
            return 0;
        }
        int i = Math.abs(p_159614_) + Math.abs(p_159615_);
        float f = (float)Mth.m_144851_((double)i, (double)0.0, (double)p_159618_.f_160769_, (double)((double)p_159617_ / 2.0), (double)0.0);
        return (int)OtherDripstoneCluster.randomBetweenBiased(p_159613_, 0.0f, p_159617_, f, p_159618_.f_160763_);
    }

    private boolean canPlacePool(WorldGenLevel p_159620_, BlockPos p_159621_) {
        BlockState blockstate = p_159620_.m_8055_(p_159621_);
        if (!(blockstate.m_60713_(Blocks.f_49990_) || blockstate.m_60713_(Blocks.f_152537_) || blockstate.m_60713_(Blocks.f_152588_))) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.canBeAdjacentToWater((LevelAccessor)p_159620_, p_159621_.m_142300_(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater((LevelAccessor)p_159620_, p_159621_.m_7495_());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(LevelAccessor p_159583_, BlockPos p_159584_) {
        BlockState blockstate = p_159583_.m_8055_(p_159584_);
        return blockstate.m_60620_(TagRegistry.ANCIENT_STONE) || blockstate.m_60819_().m_76153_((Tag)FluidTags.f_13131_);
    }

    private void replaceBlocksWithDripstoneBlocks(WorldGenLevel p_159589_, BlockPos p_159590_, int p_159591_, Direction p_159592_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_159590_.m_122032_();
        for (int i = 0; i < p_159591_; ++i) {
            if (!DripstoneUtils.m_190853_((LevelAccessor)p_159589_, (BlockPos)blockpos$mutableblockpos)) {
                return;
            }
            blockpos$mutableblockpos.m_122173_(p_159592_);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int p_159577_, int p_159578_, int p_159579_, int p_159580_, DripstoneClusterConfiguration p_159581_) {
        int i = p_159577_ - Math.abs(p_159579_);
        int j = p_159578_ - Math.abs(p_159580_);
        int k = Math.min(i, j);
        return Mth.m_184631_((float)k, (float)0.0f, (float)p_159581_.f_160768_, (float)p_159581_.f_160767_, (float)1.0f);
    }

    private static float randomBetweenBiased(Random p_159607_, float p_159608_, float p_159609_, float p_159610_, float p_159611_) {
        return ClampedNormalFloat.m_146434_((Random)p_159607_, (float)p_159610_, (float)p_159611_, (float)p_159608_, (float)p_159609_);
    }
}

